/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.util.FastNumberFormat;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationId;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ContainerId
implements Comparable<ContainerId> {
    public static final long CONTAINER_ID_BITMASK = 0xFFFFFFFFFFL;
    private static final String CONTAINER_PREFIX = "container_";
    private static final String EPOCH_PREFIX = "e";
    private static final int APP_ID_MIN_DIGITS = 4;
    private static final int ATTEMPT_ID_MIN_DIGITS = 2;
    private static final int EPOCH_MIN_DIGITS = 2;
    private static final int CONTAINER_ID_MIN_DIGITS = 6;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ContainerId newContainerId(ApplicationAttemptId appAttemptId, long containerId) {
        ContainerId id = Records.newRecord(ContainerId.class);
        id.setContainerId(containerId);
        id.setApplicationAttemptId(appAttemptId);
        id.build();
        return id;
    }

    @InterfaceAudience.Private
    @Deprecated
    @InterfaceStability.Unstable
    public static ContainerId newInstance(ApplicationAttemptId appAttemptId, int containerId) {
        ContainerId id = Records.newRecord(ContainerId.class);
        id.setContainerId(containerId);
        id.setApplicationAttemptId(appAttemptId);
        id.build();
        return id;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationAttemptId getApplicationAttemptId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setApplicationAttemptId(ApplicationAttemptId var1);

    @InterfaceAudience.Public
    @Deprecated
    @InterfaceStability.Unstable
    public abstract int getId();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getContainerId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setContainerId(long var1);

    public int hashCode() {
        int result = (int)(this.getContainerId() ^ this.getContainerId() >>> 32);
        result = 31 * result + this.getApplicationAttemptId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerId other = (ContainerId)obj;
        if (!this.getApplicationAttemptId().equals(other.getApplicationAttemptId())) {
            return false;
        }
        return this.getContainerId() == other.getContainerId();
    }

    @Override
    public int compareTo(ContainerId other) {
        int result = this.getApplicationAttemptId().compareTo(other.getApplicationAttemptId());
        if (result == 0) {
            return Long.compare(this.getContainerId(), other.getContainerId());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(CONTAINER_PREFIX);
        long epoch = this.getContainerId() >> 40;
        if (epoch > 0L) {
            sb.append(EPOCH_PREFIX);
            FastNumberFormat.format(sb, epoch, 2);
            sb.append('_');
        }
        ApplicationId appId = this.getApplicationAttemptId().getApplicationId();
        sb.append(appId.getClusterTimestamp());
        sb.append('_');
        FastNumberFormat.format(sb, appId.getId(), 4);
        sb.append('_');
        FastNumberFormat.format(sb, this.getApplicationAttemptId().getAttemptId(), 2);
        sb.append('_');
        FastNumberFormat.format(sb, 0xFFFFFFFFFFL & this.getContainerId(), 6);
        return sb.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ContainerId fromString(String containerIdStr) {
        if (!containerIdStr.startsWith(CONTAINER_PREFIX)) {
            throw new IllegalArgumentException("Invalid ContainerId prefix: " + containerIdStr);
        }
        try {
            int pos2;
            int pos1 = CONTAINER_PREFIX.length() - 1;
            long epoch = 0L;
            if (containerIdStr.regionMatches(pos1 + 1, EPOCH_PREFIX, 0, EPOCH_PREFIX.length())) {
                pos2 = containerIdStr.indexOf(95, pos1 + 1);
                if (pos2 < 0) {
                    throw new IllegalArgumentException("Invalid ContainerId: " + containerIdStr);
                }
                String epochStr = containerIdStr.substring(pos1 + 1 + EPOCH_PREFIX.length(), pos2);
                epoch = Integer.parseInt(epochStr);
                pos1 = pos2;
            }
            if ((pos2 = containerIdStr.indexOf(95, pos1 + 1)) < 0) {
                throw new IllegalArgumentException("Invalid ContainerId: " + containerIdStr);
            }
            long clusterTimestamp = Long.parseLong(containerIdStr.substring(pos1 + 1, pos2));
            int pos3 = containerIdStr.indexOf(95, pos2 + 1);
            if (pos3 < 0) {
                throw new IllegalArgumentException("Invalid ContainerId: " + containerIdStr);
            }
            int appId = Integer.parseInt(containerIdStr.substring(pos2 + 1, pos3));
            ApplicationId applicationId = ApplicationId.newInstance(clusterTimestamp, appId);
            int pos4 = containerIdStr.indexOf(95, pos3 + 1);
            if (pos4 < 0) {
                throw new IllegalArgumentException("Invalid ContainerId: " + containerIdStr);
            }
            int attemptId = Integer.parseInt(containerIdStr.substring(pos3 + 1, pos4));
            ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance(applicationId, attemptId);
            long id = Long.parseLong(containerIdStr.substring(pos4 + 1));
            long cid = epoch << 40 | id;
            ContainerId containerId = ContainerId.newContainerId(appAttemptId, cid);
            return containerId;
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid ContainerId: " + containerIdStr, n);
        }
    }

    protected abstract void build();
}

