/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationReport;
import shaded.org.apache.hadoop.yarn.api.records.QueueConfigurations;
import shaded.org.apache.hadoop.yarn.api.records.QueueState;
import shaded.org.apache.hadoop.yarn.api.records.QueueStatistics;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class QueueInfo {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static QueueInfo newInstance(String queueName, float capacity, float maximumCapacity, float currentCapacity, List<QueueInfo> childQueues, List<ApplicationReport> applications, QueueState queueState, Set<String> accessibleNodeLabels, String defaultNodeLabelExpression, QueueStatistics queueStatistics, boolean preemptionDisabled) {
        QueueInfo queueInfo = Records.newRecord(QueueInfo.class);
        queueInfo.setQueueName(queueName);
        queueInfo.setCapacity(capacity);
        queueInfo.setMaximumCapacity(maximumCapacity);
        queueInfo.setCurrentCapacity(currentCapacity);
        queueInfo.setChildQueues(childQueues);
        queueInfo.setApplications(applications);
        queueInfo.setQueueState(queueState);
        queueInfo.setAccessibleNodeLabels(accessibleNodeLabels);
        queueInfo.setDefaultNodeLabelExpression(defaultNodeLabelExpression);
        queueInfo.setQueueStatistics(queueStatistics);
        queueInfo.setPreemptionDisabled(preemptionDisabled);
        return queueInfo;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static QueueInfo newInstance(String queueName, float capacity, float maximumCapacity, float currentCapacity, List<QueueInfo> childQueues, List<ApplicationReport> applications, QueueState queueState, Set<String> accessibleNodeLabels, String defaultNodeLabelExpression, QueueStatistics queueStatistics, boolean preemptionDisabled, Map<String, QueueConfigurations> queueConfigurations) {
        QueueInfo queueInfo = QueueInfo.newInstance(queueName, capacity, maximumCapacity, currentCapacity, childQueues, applications, queueState, accessibleNodeLabels, defaultNodeLabelExpression, queueStatistics, preemptionDisabled);
        queueInfo.setQueueConfigurations(queueConfigurations);
        return queueInfo;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static QueueInfo newInstance(String queueName, float capacity, float maximumCapacity, float currentCapacity, List<QueueInfo> childQueues, List<ApplicationReport> applications, QueueState queueState, Set<String> accessibleNodeLabels, String defaultNodeLabelExpression, QueueStatistics queueStatistics, boolean preemptionDisabled, Map<String, QueueConfigurations> queueConfigurations, boolean intraQueuePreemptionDisabled) {
        QueueInfo queueInfo = QueueInfo.newInstance(queueName, capacity, maximumCapacity, currentCapacity, childQueues, applications, queueState, accessibleNodeLabels, defaultNodeLabelExpression, queueStatistics, preemptionDisabled, queueConfigurations);
        queueInfo.setIntraQueuePreemptionDisabled(intraQueuePreemptionDisabled);
        return queueInfo;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getQueueName();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getMaximumCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setMaximumCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getCurrentCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCurrentCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<QueueInfo> getChildQueues();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setChildQueues(List<QueueInfo> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<ApplicationReport> getApplications();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplications(List<ApplicationReport> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract QueueState getQueueState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueState(QueueState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Set<String> getAccessibleNodeLabels();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAccessibleNodeLabels(Set<String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getDefaultNodeLabelExpression();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setDefaultNodeLabelExpression(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract QueueStatistics getQueueStatistics();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setQueueStatistics(QueueStatistics var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Boolean getPreemptionDisabled();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPreemptionDisabled(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Map<String, QueueConfigurations> getQueueConfigurations();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueConfigurations(Map<String, QueueConfigurations> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Boolean getIntraQueuePreemptionDisabled();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setIntraQueuePreemptionDisabled(boolean var1);
}

