/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import java.io.Serializable;
import java.util.Comparator;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.records.ExecutionType;
import shaded.org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import shaded.org.apache.hadoop.yarn.api.records.Priority;
import shaded.org.apache.hadoop.yarn.api.records.Resource;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ResourceRequest
implements Comparable<ResourceRequest> {
    public static final String ANY = "*";

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ResourceRequest newInstance(Priority priority, String hostName, Resource capability, int numContainers) {
        return ResourceRequest.newBuilder().priority(priority).resourceName(hostName).capability(capability).numContainers(numContainers).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ResourceRequest newInstance(Priority priority, String hostName, Resource capability, int numContainers, boolean relaxLocality) {
        return ResourceRequest.newBuilder().priority(priority).resourceName(hostName).capability(capability).numContainers(numContainers).relaxLocality(relaxLocality).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ResourceRequest newInstance(Priority priority, String hostName, Resource capability, int numContainers, boolean relaxLocality, String labelExpression) {
        return ResourceRequest.newBuilder().priority(priority).resourceName(hostName).capability(capability).numContainers(numContainers).relaxLocality(relaxLocality).nodeLabelExpression(labelExpression).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static ResourceRequest newInstance(Priority priority, String hostName, Resource capability, int numContainers, boolean relaxLocality, String labelExpression, ExecutionTypeRequest executionTypeRequest) {
        return ResourceRequest.newBuilder().priority(priority).resourceName(hostName).capability(capability).numContainers(numContainers).relaxLocality(relaxLocality).nodeLabelExpression(labelExpression).executionTypeRequest(executionTypeRequest).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static ResourceRequest clone(ResourceRequest rr) {
        return ResourceRequest.newBuilder().priority(rr.getPriority()).resourceName(rr.getResourceName()).capability(rr.getCapability()).numContainers(rr.getNumContainers()).relaxLocality(rr.getRelaxLocality()).nodeLabelExpression(rr.getNodeLabelExpression()).executionTypeRequest(rr.getExecutionTypeRequest()).allocationRequestId(rr.getAllocationRequestId()).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceRequestBuilder newBuilder() {
        return new ResourceRequestBuilder();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static boolean isAnyLocation(String hostName) {
        return ANY.equals(hostName);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Priority getPriority();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getResourceName();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setResourceName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getNumContainers();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setNumContainers(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract boolean getRelaxLocality();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void setExecutionTypeRequest(ExecutionTypeRequest execSpec) {
        throw new UnsupportedOperationException();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public ExecutionTypeRequest getExecutionTypeRequest() {
        throw new UnsupportedOperationException();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setRelaxLocality(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract String getNodeLabelExpression();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract void setNodeLabelExpression(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public long getAllocationRequestId() {
        throw new UnsupportedOperationException();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void setAllocationRequestId(long allocationRequestID) {
        throw new UnsupportedOperationException();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setCapability(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getCapability();

    public int hashCode() {
        int prime = 2153;
        int result = 2459;
        Resource capability = this.getCapability();
        String hostName = this.getResourceName();
        Priority priority = this.getPriority();
        result = 2153 * result + (capability == null ? 0 : capability.hashCode());
        result = 2153 * result + (hostName == null ? 0 : hostName.hashCode());
        result = 2153 * result + this.getNumContainers();
        result = 2153 * result + (priority == null ? 0 : priority.hashCode());
        result = 2153 * result + Long.valueOf(this.getAllocationRequestId()).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRequest other = (ResourceRequest)obj;
        Resource capability = this.getCapability();
        if (capability == null ? other.getCapability() != null : !capability.equals(other.getCapability())) {
            return false;
        }
        String hostName = this.getResourceName();
        if (hostName == null ? other.getResourceName() != null : !hostName.equals(other.getResourceName())) {
            return false;
        }
        if (this.getNumContainers() != other.getNumContainers()) {
            return false;
        }
        Priority priority = this.getPriority();
        if (priority == null ? other.getPriority() != null : !priority.equals(other.getPriority())) {
            return false;
        }
        ExecutionTypeRequest execTypeRequest = this.getExecutionTypeRequest();
        if (execTypeRequest == null ? other.getExecutionTypeRequest() != null : !execTypeRequest.getExecutionType().equals((Object)other.getExecutionTypeRequest().getExecutionType())) {
            return false;
        }
        if (this.getAllocationRequestId() != other.getAllocationRequestId()) {
            return false;
        }
        if (this.getNodeLabelExpression() == null) {
            if (other.getNodeLabelExpression() != null) {
                return false;
            }
        } else {
            String label2;
            String label1 = this.getNodeLabelExpression().replaceAll("[\\t ]", "");
            String string = label2 = other.getNodeLabelExpression() == null ? null : other.getNodeLabelExpression().replaceAll("[\\t ]", "");
            if (!label1.equals(label2)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(ResourceRequest other) {
        int priorityComparison = this.getPriority().compareTo(other.getPriority());
        if (priorityComparison == 0) {
            int hostNameComparison = this.getResourceName().compareTo(other.getResourceName());
            if (hostNameComparison == 0) {
                int execTypeReqComparison = this.getExecutionTypeRequest().compareTo(other.getExecutionTypeRequest());
                if (execTypeReqComparison == 0) {
                    int capabilityComparison = this.getCapability().compareTo(other.getCapability());
                    if (capabilityComparison == 0) {
                        int numContainerComparison = this.getNumContainers() - other.getNumContainers();
                        if (numContainerComparison == 0) {
                            return Long.compare(this.getAllocationRequestId(), other.getAllocationRequestId());
                        }
                        return numContainerComparison;
                    }
                    return capabilityComparison;
                }
                return execTypeReqComparison;
            }
            return hostNameComparison;
        }
        return priorityComparison;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static class ResourceRequestComparator
    implements Comparator<ResourceRequest>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(ResourceRequest r1, ResourceRequest r2) {
            int ret = r1.getPriority().compareTo(r2.getPriority());
            if (ret == 0) {
                ret = Long.compare(r1.getAllocationRequestId(), r2.getAllocationRequestId());
            }
            if (ret == 0) {
                String h1 = r1.getResourceName();
                String h2 = r2.getResourceName();
                ret = h1.compareTo(h2);
            }
            if (ret == 0) {
                ret = r1.getExecutionTypeRequest().compareTo(r2.getExecutionTypeRequest());
            }
            if (ret == 0) {
                ret = r1.getCapability().compareTo(r2.getCapability());
            }
            return ret;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static final class ResourceRequestBuilder {
        private ResourceRequest resourceRequest = Records.newRecord(ResourceRequest.class);

        private ResourceRequestBuilder() {
            this.resourceRequest.setResourceName(ResourceRequest.ANY);
            this.resourceRequest.setNumContainers(1);
            this.resourceRequest.setPriority(Priority.newInstance(0));
            this.resourceRequest.setRelaxLocality(true);
            this.resourceRequest.setExecutionTypeRequest(ExecutionTypeRequest.newInstance());
        }

        @InterfaceAudience.Public
        @InterfaceStability.Stable
        public ResourceRequestBuilder priority(Priority priority) {
            this.resourceRequest.setPriority(priority);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Stable
        public ResourceRequestBuilder resourceName(String resourceName) {
            this.resourceRequest.setResourceName(resourceName);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Stable
        public ResourceRequestBuilder capability(Resource capability) {
            this.resourceRequest.setCapability(capability);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Stable
        public ResourceRequestBuilder numContainers(int numContainers) {
            this.resourceRequest.setNumContainers(numContainers);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Stable
        public ResourceRequestBuilder relaxLocality(boolean relaxLocality) {
            this.resourceRequest.setRelaxLocality(relaxLocality);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Evolving
        public ResourceRequestBuilder nodeLabelExpression(String nodeLabelExpression) {
            this.resourceRequest.setNodeLabelExpression(nodeLabelExpression);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Evolving
        public ResourceRequestBuilder executionTypeRequest(ExecutionTypeRequest executionTypeRequest) {
            this.resourceRequest.setExecutionTypeRequest(executionTypeRequest);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Evolving
        public ResourceRequestBuilder executionType(ExecutionType executionType) {
            this.resourceRequest.setExecutionTypeRequest(ExecutionTypeRequest.newInstance(executionType, true));
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Evolving
        public ResourceRequestBuilder allocationRequestId(long allocationRequestId) {
            this.resourceRequest.setAllocationRequestId(allocationRequestId);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Stable
        public ResourceRequest build() {
            return this.resourceRequest;
        }
    }
}

