/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.org.apache.hadoop.io;

import com.ibm.bi.org.apache.hadoop.io.ICryptoProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import mx4j.tools.remote.rmi.SSLRMIServerSocketFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;

public final class CryptoProvider {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static ICryptoProvider cryptoProvider;

    public static void initialize(ICryptoProvider aCryptoProvider) throws Exception {
        if (INITIALIZED.compareAndSet(false, true)) {
            cryptoProvider = aCryptoProvider;
            cryptoProvider.initialize();
        }
    }

    public static void terminate() throws Exception {
        if (cryptoProvider == null) {
            return;
        }
        cryptoProvider.terminate();
    }

    public static byte[] encrypt(byte[] data) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.encrypt(data);
    }

    public static byte[] decrypt(byte[] data) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.decrypt(data);
    }

    public static OutputStream createEncryptingOutputStream(OutputStream sourceOutputStream) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.createEncryptingOutputStream(sourceOutputStream);
    }

    public static InputStream createDecryptingInputStream(InputStream sourceInputStream) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.createDecryptingInputStream(sourceInputStream);
    }

    public static HttpConnection createHttpConnection(String host, int port, boolean isSecure) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.createHttpConnection(host, port, isSecure);
    }

    public static HttpClient createHttpClient(String host, int port, boolean isSecure) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.createHttpClient(host, port, isSecure);
    }

    public static ServerSocket createServerSocket(int port, boolean isSecure) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.createServerSocket(port, isSecure);
    }

    public static Socket createSocket(String host, int port, boolean isSecure) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.createSocket(host, port, isSecure);
    }

    public static SSLContext getSSLContext() throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.getSSLContext();
    }

    public static SSLRMIServerSocketFactory createRMIServerSocketFactory() throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.createRMIServerSocketFactory();
    }

    public static byte[] getToken(byte[] arg) throws Exception {
        if (cryptoProvider == null) {
            return null;
        }
        return cryptoProvider.getToken(arg);
    }

    public static boolean verifyToken(byte[] arg1, byte[] arg2) throws Exception {
        if (cryptoProvider == null) {
            return false;
        }
        return cryptoProvider.verifyToken(arg1, arg2);
    }
}

