/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.org.apache.hadoop.io;

import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.bytes.ByteBufferInputStream;

public class ParquetInputStream
extends InputStream {
    private InputStream is;
    private byte[] decryptedData;
    private int index;

    public ParquetInputStream(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int bytesRead;
        ByteBufferInputStream bais = (ByteBufferInputStream)this.is;
        if (this.index == 0) {
            byte[] data = new byte[bais.available()];
            int size = this.is.read(data);
            if (size != data.length) {
                return -1;
            }
            byte[] actualData = new byte[size - 1];
            System.arraycopy(data, 1, actualData, 0, size - 1);
            if (data[0] == 1) {
                try {
                    this.decryptedData = CryptoProvider.decrypt(actualData);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                this.decryptedData = actualData;
            }
        }
        if (this.index + (bytesRead = length) > this.decryptedData.length && (bytesRead = this.decryptedData.length - this.index) == 0) {
            return -1;
        }
        System.arraycopy(this.decryptedData, this.index, b, offset, bytesRead);
        this.index += bytesRead;
        return bytesRead;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

