/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.Hessian2Constants;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemote;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.io.HessianServiceException;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.util.CharBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Node;

public class Hessian2Input
extends AbstractHessianInput
implements Hessian2Constants {
    private static final double D_256 = 0.00390625;
    private static final int END_OF_DATA = -2;
    private static Field _detailMessageField;
    protected SerializerFactory _serializerFactory;
    protected ArrayList _refs;
    protected ArrayList _classDefs;
    protected ArrayList _types;
    private InputStream _is;
    private static final int SIZE = 256;
    private static final int GAP = 16;
    private final byte[] _buffer = new byte[256];
    private int _offset;
    private int _length;
    private String _method;
    private Reader _chunkReader;
    private InputStream _chunkInputStream;
    private Throwable _replyFault;
    private StringBuffer _sbuf = new StringBuffer();
    private boolean _isLastChunk;
    private int _chunkLength;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public Hessian2Input(InputStream is) {
        this._is = is;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this._serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        return this._serializerFactory;
    }

    protected final SerializerFactory findSerializerFactory() {
        SerializerFactory factory = this._serializerFactory;
        if (factory == null) {
            this._serializerFactory = factory = new SerializerFactory();
        }
        return factory;
    }

    public String getMethod() {
        return this._method;
    }

    public Throwable getReplyFault() {
        return this._replyFault;
    }

    public int readCall() throws IOException {
        int tag = this.read();
        if (tag != 99) {
            throw this.error(new CharBuffer().append("expected hessian call ('c') at code=").append(tag).append(" ch=").append((char)tag).toString());
        }
        int major = this.read();
        int minor = this.read();
        return (major << 16) + minor;
    }

    public String readMethod() throws IOException {
        int ch;
        int tag = this.read();
        if (tag != 109) {
            throw this.error(new CharBuffer().append("expected hessian method ('m') at code=").append(tag).append(" ch=").append((char)tag).toString());
        }
        int d1 = this.read();
        int d2 = this.read();
        this._isLastChunk = true;
        this._chunkLength = d1 * 256 + d2;
        this._sbuf.setLength(0);
        while ((ch = this.parseChar()) >= 0) {
            this._sbuf.append((char)ch);
        }
        this._method = this._sbuf.toString();
        return this._method;
    }

    public void startCall() throws IOException {
        this.readCall();
        while (this.readHeader() != null) {
            this.readObject();
        }
        this.readMethod();
    }

    public void completeCall() throws IOException {
        int tag = this.read();
        if (tag != 122) {
            if (tag < 0) {
                throw this.error("expected end of call ('z') at end of stream.");
            }
            throw this.error(new CharBuffer().append("expected end of call ('z') at '").append((char)tag).append("'.  Check method arguments and ensure method overloading is enabled if necessary").toString());
        }
    }

    public Object readReply(Class expectedClass) throws Throwable {
        int tag = this.read();
        if (tag != 114) {
            this.error("expected hessian reply");
        }
        int major = this.read();
        int minor = this.read();
        tag = this.read();
        if (tag == 102) {
            throw this.prepareFault();
        }
        if (tag >= 0) {
            --this._offset;
        }
        Object value = this.readObject(expectedClass);
        this.completeValueReply();
        return value;
    }

    public void startReply() throws Throwable {
        int tag = this.read();
        if (tag != 114) {
            this.error("expected hessian reply");
        }
        int major = this.read();
        int minor = this.read();
        tag = this.read();
        if (tag == 102) {
            throw this.prepareFault();
        }
        if (tag >= 0) {
            --this._offset;
        }
    }

    private Throwable prepareFault() throws IOException {
        HashMap fault = this.readFault();
        Object detail = fault.get("detail");
        String message = (String)fault.get("message");
        if (detail instanceof Throwable) {
            this._replyFault = (Throwable)detail;
            if (message != null && _detailMessageField != null) {
                try {
                    _detailMessageField.set(this._replyFault, message);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return this._replyFault;
        }
        String code = (String)fault.get("code");
        this._replyFault = new HessianServiceException(message, code, detail);
        return this._replyFault;
    }

    public void completeReply() throws IOException {
        int tag = this.read();
        if (tag != 122) {
            this.error("expected end of reply");
        }
    }

    public void completeValueReply() throws IOException {
        int tag = this.read();
        if (tag != 122) {
            this.error("expected end of reply");
        }
    }

    public String readHeader() throws IOException {
        int tag = this.read();
        if (tag == 72) {
            int ch;
            this._isLastChunk = true;
            this._chunkLength = (this.read() << 8) + this.read();
            this._sbuf.setLength(0);
            while ((ch = this.parseChar()) >= 0) {
                this._sbuf.append((char)ch);
            }
            return this._sbuf.toString();
        }
        if (tag >= 0) {
            --this._offset;
        }
        return null;
    }

    public void readNull() throws IOException {
        int tag = this.read();
        switch (tag) {
            case 78: {
                return;
            }
        }
        throw this.expect("null", tag);
    }

    public boolean readBoolean() throws IOException {
        int tag = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
        switch (tag) {
            case 84: {
                return true;
            }
            case 70: {
                return false;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return tag != 144;
            }
            case 200: {
                return this.read() != 0;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                this.read();
                return true;
            }
            case 212: {
                return 256 * this.read() + this.read() != 0;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 213: 
            case 214: 
            case 215: {
                this.read();
                this.read();
                return true;
            }
            case 73: {
                return this.parseInt() != 0;
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return tag != 224;
            }
            case 248: {
                return this.read() != 0;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                this.read();
                return true;
            }
            case 60: {
                return 256 * this.read() + this.read() != 0;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: {
                this.read();
                this.read();
                return true;
            }
            case 97: {
                return 0x1000000L * (long)this.read() + 65536L * (long)this.read() + (long)(256 * this.read()) + (long)this.read() != 0L;
            }
            case 76: {
                return this.parseLong() != 0L;
            }
            case 104: {
                return false;
            }
            case 105: {
                return true;
            }
            case 106: {
                return this.read() != 0;
            }
            case 107: {
                return 256 * this.read() + this.read() != 0;
            }
            case 110: {
                return 0x1000000L * (long)this.read() + 65536L * (long)this.read() + (long)(256 * this.read()) + (long)this.read() != 0L;
            }
            case 112: {
                return 256 * this.read() + this.read() != 0;
            }
            case 68: {
                return this.parseDouble() != 0.0;
            }
            case 78: {
                return false;
            }
        }
        throw this.expect("boolean", tag);
    }

    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    public final int readInt() throws IOException {
        int tag = this.read();
        switch (tag) {
            case 78: {
                return 0;
            }
            case 70: {
                return 0;
            }
            case 84: {
                return 1;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return tag - 144;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return (tag - 200 << 8) + this.read();
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                return (tag - 212 << 16) + 256 * this.read() + this.read();
            }
            case 73: 
            case 97: 
            case 110: {
                return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return tag - 224;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return (tag - 248 << 8) + this.read();
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return (tag - 60 << 16) + 256 * this.read() + this.read();
            }
            case 76: {
                return (int)this.parseLong();
            }
            case 106: {
                return (byte)(this._offset < this._length ? this._buffer[this._offset++] : this.read());
            }
            case 107: {
                return (short)(256 * this.read() + this.read());
            }
            case 104: {
                return 0;
            }
            case 105: {
                return 1;
            }
            case 112: {
                return (short)(256 * this.read() + this.read()) >> 8;
            }
            case 68: {
                return (int)this.parseDouble();
            }
        }
        throw this.expect("int", tag);
    }

    public long readLong() throws IOException {
        int tag = this.read();
        switch (tag) {
            case 78: {
                return 0L;
            }
            case 70: {
                return 0L;
            }
            case 84: {
                return 1L;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return tag - 144;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return (tag - 200 << 8) + this.read();
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                return (tag - 212 << 16) + 256 * this.read() + this.read();
            }
            case 106: {
                return (byte)(this._offset < this._length ? this._buffer[this._offset++] : this.read());
            }
            case 107: {
                return (short)(256 * this.read() + this.read());
            }
            case 73: 
            case 97: 
            case 110: {
                return this.parseInt();
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return tag - 224;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return (tag - 248 << 8) + this.read();
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return (tag - 60 << 16) + 256 * this.read() + this.read();
            }
            case 76: {
                return this.parseLong();
            }
            case 104: {
                return 0L;
            }
            case 105: {
                return 1L;
            }
            case 112: {
                return (short)(256 * this.read() + this.read()) >> 8;
            }
            case 68: {
                return (long)this.parseDouble();
            }
        }
        throw this.expect("long", tag);
    }

    public float readFloat() throws IOException {
        return (float)this.readDouble();
    }

    public double readDouble() throws IOException {
        int tag = this.read();
        switch (tag) {
            case 78: {
                return 0.0;
            }
            case 70: {
                return 0.0;
            }
            case 84: {
                return 1.0;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return tag - 144;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return (tag - 200 << 8) + this.read();
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                return (tag - 212 << 16) + 256 * this.read() + this.read();
            }
            case 73: 
            case 97: 
            case 110: {
                return this.parseInt();
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return tag - 224;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return (tag - 248 << 8) + this.read();
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return (tag - 60 << 16) + 256 * this.read() + this.read();
            }
            case 76: {
                return this.parseLong();
            }
            case 104: {
                return 0.0;
            }
            case 105: {
                return 1.0;
            }
            case 106: {
                return (byte)(this._offset < this._length ? this._buffer[this._offset++] : this.read());
            }
            case 107: {
                return (short)(256 * this.read() + this.read());
            }
            case 112: {
                return 0.00390625 * (double)((short)(256 * this.read() + this.read()));
            }
            case 113: {
                int f = this.parseInt();
                return Float.intBitsToFloat(f);
            }
            case 68: {
                return this.parseDouble();
            }
        }
        throw this.expect("double", tag);
    }

    public long readUTCDate() throws IOException {
        int tag = this.read();
        if (tag != 100) {
            throw this.error("expected date");
        }
        long b64 = this.read();
        long b56 = this.read();
        long b48 = this.read();
        long b40 = this.read();
        long b32 = this.read();
        long b24 = this.read();
        long b16 = this.read();
        long b8 = this.read();
        return (b64 << 56) + (b56 << 48) + (b48 << 40) + (b40 << 32) + (b32 << 24) + (b24 << 16) + (b16 << 8) + b8;
    }

    public int readChar() throws IOException {
        if (this._chunkLength > 0) {
            --this._chunkLength;
            if (this._chunkLength == 0 && this._isLastChunk) {
                this._chunkLength = -2;
            }
            int ch = this.parseUTF8Char();
            return ch;
        }
        if (this._chunkLength == -2) {
            this._chunkLength = 0;
            return -1;
        }
        int tag = this.read();
        switch (tag) {
            case 78: {
                return -1;
            }
            case 83: 
            case 88: 
            case 115: 
            case 120: {
                this._isLastChunk = tag == 83 || tag == 88;
                this._chunkLength = (this.read() << 8) + this.read();
                --this._chunkLength;
                int value = this.parseUTF8Char();
                if (this._chunkLength == 0 && this._isLastChunk) {
                    this._chunkLength = -2;
                }
                return value;
            }
        }
        throw new IOException(new CharBuffer().append("expected 'S' at ").append((char)tag).toString());
    }

    public int readString(char[] buffer, int offset, int length) throws IOException {
        int tag;
        int readLength = 0;
        if (this._chunkLength == -2) {
            this._chunkLength = 0;
            return -1;
        }
        if (this._chunkLength == 0) {
            tag = this.read();
            switch (tag) {
                case 78: {
                    return -1;
                }
                case 83: 
                case 88: 
                case 115: 
                case 120: {
                    this._isLastChunk = tag == 83 || tag == 88;
                    this._chunkLength = (this.read() << 8) + this.read();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this._isLastChunk = true;
                    this._chunkLength = tag - 0;
                    break;
                }
                default: {
                    throw new IOException(new CharBuffer().append("expected 'S' at ").append((char)tag).toString());
                }
            }
        }
        block8: while (length > 0) {
            if (this._chunkLength > 0) {
                buffer[offset++] = (char)this.parseUTF8Char();
                --this._chunkLength;
                --length;
                ++readLength;
                continue;
            }
            if (this._isLastChunk) {
                if (readLength == 0) {
                    return -1;
                }
                this._chunkLength = -2;
                return readLength;
            }
            tag = this.read();
            switch (tag) {
                case 83: 
                case 88: 
                case 115: 
                case 120: {
                    this._isLastChunk = tag == 83 || tag == 88;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block8;
                }
            }
            throw new IOException(new CharBuffer().append("expected 'S' at ").append((char)tag).toString());
        }
        if (readLength == 0) {
            return -1;
        }
        if (this._chunkLength > 0 || !this._isLastChunk) {
            return readLength;
        }
        this._chunkLength = -2;
        return readLength;
    }

    public String readString() throws IOException {
        int tag = this.read();
        switch (tag) {
            case 78: {
                return null;
            }
            case 73: {
                return String.valueOf(this.parseInt());
            }
            case 76: {
                return String.valueOf(this.parseLong());
            }
            case 68: {
                return String.valueOf(this.parseDouble());
            }
            case 83: 
            case 88: 
            case 115: 
            case 120: {
                int ch;
                this._isLastChunk = tag == 83 || tag == 88;
                this._chunkLength = (this.read() << 8) + this.read();
                this._sbuf.setLength(0);
                while ((ch = this.parseChar()) >= 0) {
                    this._sbuf.append((char)ch);
                }
                return this._sbuf.toString();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                int ch;
                this._isLastChunk = true;
                this._chunkLength = tag - 0;
                this._sbuf.setLength(0);
                while ((ch = this.parseChar()) >= 0) {
                    this._sbuf.append((char)ch);
                }
                return this._sbuf.toString();
            }
        }
        throw this.expect("string", tag);
    }

    public Node readNode() throws IOException {
        int tag = this.read();
        switch (tag) {
            case 78: {
                return null;
            }
            case 83: 
            case 88: 
            case 115: 
            case 120: {
                this._isLastChunk = tag == 83 || tag == 88;
                this._chunkLength = (this.read() << 8) + this.read();
                throw this.error("can't cope");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this._isLastChunk = true;
                this._chunkLength = tag - 0;
                throw this.error("can't cope");
            }
        }
        throw this.expect("string", tag);
    }

    public byte[] readBytes() throws IOException {
        int tag = this.read();
        switch (tag) {
            case 78: {
                return null;
            }
            case 66: 
            case 98: {
                int data;
                this._isLastChunk = tag == 66;
                this._chunkLength = (this.read() << 8) + this.read();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((data = this.parseByte()) >= 0) {
                    bos.write(data);
                }
                return bos.toByteArray();
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                int data;
                this._isLastChunk = true;
                this._chunkLength = tag - 32;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((data = this.parseByte()) >= 0) {
                    bos.write(data);
                }
                return bos.toByteArray();
            }
        }
        throw this.expect("bytes", tag);
    }

    public int readByte() throws IOException {
        if (this._chunkLength > 0) {
            --this._chunkLength;
            if (this._chunkLength == 0 && this._isLastChunk) {
                this._chunkLength = -2;
            }
            return this.read();
        }
        if (this._chunkLength == -2) {
            this._chunkLength = 0;
            return -1;
        }
        int tag = this.read();
        switch (tag) {
            case 78: {
                return -1;
            }
            case 66: 
            case 98: {
                this._isLastChunk = tag == 66;
                this._chunkLength = (this.read() << 8) + this.read();
                int value = this.parseByte();
                if (this._chunkLength == 0 && this._isLastChunk) {
                    this._chunkLength = -2;
                }
                return value;
            }
        }
        throw new IOException(new CharBuffer().append("expected 'B' at ").append((char)tag).toString());
    }

    public int readBytes(byte[] buffer, int offset, int length) throws IOException {
        int tag;
        int readLength = 0;
        if (this._chunkLength == -2) {
            this._chunkLength = 0;
            return -1;
        }
        if (this._chunkLength == 0) {
            tag = this.read();
            switch (tag) {
                case 78: {
                    return -1;
                }
                case 66: 
                case 98: {
                    this._isLastChunk = tag == 66;
                    this._chunkLength = (this.read() << 8) + this.read();
                    break;
                }
                default: {
                    throw new IOException(new CharBuffer().append("expected 'B' at ").append((char)tag).toString());
                }
            }
        }
        block7: while (length > 0) {
            if (this._chunkLength > 0) {
                buffer[offset++] = (byte)this.read();
                --this._chunkLength;
                --length;
                ++readLength;
                continue;
            }
            if (this._isLastChunk) {
                if (readLength == 0) {
                    return -1;
                }
                this._chunkLength = -2;
                return readLength;
            }
            tag = this.read();
            switch (tag) {
                case 66: 
                case 98: {
                    this._isLastChunk = tag == 66;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block7;
                }
            }
            throw new IOException(new CharBuffer().append("expected 'B' at ").append((char)tag).toString());
        }
        if (readLength == 0) {
            return -1;
        }
        if (this._chunkLength > 0 || !this._isLastChunk) {
            return readLength;
        }
        this._chunkLength = -2;
        return readLength;
    }

    private HashMap readFault() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int code = this.read();
        while (code > 0 && code != 122) {
            --this._offset;
            Object key = this.readObject();
            Object value = this.readObject();
            if (key != null && value != null) {
                map.put(key, value);
            }
            code = this.read();
        }
        if (code != 122) {
            throw this.expect("fault", code);
        }
        return map;
    }

    public Object readObject(Class cl) throws IOException {
        if (cl == null || cl == Hessian2Input._resin_compat_class_0()) {
            return this.readObject();
        }
        int tag = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
        switch (tag) {
            case 78: {
                return null;
            }
            case 77: {
                String type = this.readType();
                Deserializer reader = this.findSerializerFactory().getObjectDeserializer(type);
                if (cl != reader.getType() && cl.isAssignableFrom(reader.getType())) {
                    return reader.readMap(this);
                }
                reader = this.findSerializerFactory().getDeserializer(cl);
                return reader.readMap(this);
            }
            case 79: {
                return this.readObjectDefinition(cl);
            }
            case 111: {
                int ref = this.readInt();
                ObjectDefinition def = (ObjectDefinition)this._classDefs.get(ref - 1);
                return this.readObjectInstance(cl, def);
            }
            case 86: {
                String type = this.readType();
                int length = this.readLength();
                Deserializer reader = this.findSerializerFactory().getObjectDeserializer(type);
                if (cl != reader.getType() && cl.isAssignableFrom(reader.getType())) {
                    return reader.readList(this, length);
                }
                reader = this.findSerializerFactory().getDeserializer(cl);
                Object v = reader.readList(this, length);
                return v;
            }
            case 118: {
                int ref = this.readInt();
                String type = (String)this._types.get(ref);
                int length = this.readInt();
                Deserializer reader = this.findSerializerFactory().getObjectDeserializer(type);
                if (cl != reader.getType() && cl.isAssignableFrom(reader.getType())) {
                    return reader.readLengthList(this, length);
                }
                reader = this.findSerializerFactory().getDeserializer(cl);
                Object v = reader.readLengthList(this, length);
                return v;
            }
            case 82: {
                int ref = this.parseInt();
                return this._refs.get(ref);
            }
            case 114: {
                String type = this.readType();
                String url = this.readString();
                return this.resolveRemote(type, url);
            }
        }
        if (tag >= 0) {
            --this._offset;
        }
        Object value = this.findSerializerFactory().getDeserializer(cl).readObject(this);
        return value;
    }

    public Object readObject() throws IOException {
        int tag = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
        switch (tag) {
            case 78: {
                return null;
            }
            case 84: {
                return new Boolean(true);
            }
            case 70: {
                return new Boolean(false);
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return new Integer(tag - 144);
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return new Integer((tag - 200 << 8) + this.read());
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                return new Integer((tag - 212 << 16) + 256 * this.read() + this.read());
            }
            case 73: {
                return new Integer(this.parseInt());
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return new Long(tag - 224);
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return new Long((tag - 248 << 8) + this.read());
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return new Long((tag - 60 << 16) + 256 * this.read() + this.read());
            }
            case 97: {
                return new Long(this.parseInt());
            }
            case 76: {
                return new Long(this.parseLong());
            }
            case 104: {
                return new Double(0.0);
            }
            case 105: {
                return new Double(1.0);
            }
            case 106: {
                return new Double((byte)this.read());
            }
            case 107: {
                return new Double((short)(256 * this.read() + this.read()));
            }
            case 110: {
                return new Double(this.parseInt());
            }
            case 112: {
                return new Double(0.00390625 * (double)((short)(256 * this.read() + this.read())));
            }
            case 68: {
                return new Double(this.parseDouble());
            }
            case 100: {
                return new Date(this.parseLong());
            }
            case 88: 
            case 120: {
                this._isLastChunk = tag == 88;
                this._chunkLength = (this.read() << 8) + this.read();
                return this.parseXML();
            }
            case 83: 
            case 115: {
                int data;
                this._isLastChunk = tag == 83;
                this._chunkLength = (this.read() << 8) + this.read();
                this._sbuf.setLength(0);
                while ((data = this.parseChar()) >= 0) {
                    this._sbuf.append((char)data);
                }
                return this._sbuf.toString();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                int data;
                this._isLastChunk = true;
                this._chunkLength = tag - 0;
                this._sbuf.setLength(0);
                while ((data = this.parseChar()) >= 0) {
                    this._sbuf.append((char)data);
                }
                return this._sbuf.toString();
            }
            case 66: 
            case 98: {
                int data;
                this._isLastChunk = tag == 66;
                this._chunkLength = (this.read() << 8) + this.read();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((data = this.parseByte()) >= 0) {
                    bos.write(data);
                }
                return bos.toByteArray();
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                this._isLastChunk = true;
                int len = tag - 32;
                this._chunkLength = 0;
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = (byte)this.read();
                }
                return data;
            }
            case 86: {
                String type = this.readType();
                int length = this.readLength();
                return this.findSerializerFactory().readList(this, length, type);
            }
            case 118: {
                int ref = this.readInt();
                String type = (String)this._types.get(ref);
                int length = this.readInt();
                Deserializer reader = this.findSerializerFactory().getObjectDeserializer(type);
                return reader.readLengthList(this, length);
            }
            case 77: {
                String type = this.readType();
                return this.findSerializerFactory().readMap(this, type);
            }
            case 79: {
                return this.readObjectDefinition(null);
            }
            case 111: {
                int ref = this.readInt();
                ObjectDefinition def = (ObjectDefinition)this._classDefs.get(ref - 1);
                return this.readObjectInstance(null, def);
            }
            case 82: {
                int ref = this.parseInt();
                return this._refs.get(ref);
            }
            case 101: {
                int ref = this.read();
                return this._refs.get(ref);
            }
            case 102: {
                int ref = 256 * this.read() + this.read();
                return this._refs.get(ref);
            }
            case 114: {
                String type = this.readType();
                String url = this.readString();
                return this.resolveRemote(type, url);
            }
        }
        throw this.error(new CharBuffer().append("unknown code:").append(tag).append(" ").append((char)tag).toString());
    }

    private Object readObjectDefinition(Class cl) throws IOException {
        String type = this.readLenString();
        int len = this.readInt();
        String[] fieldNames = new String[len];
        for (int i = 0; i < len; ++i) {
            fieldNames[i] = this.readString();
        }
        ObjectDefinition def = new ObjectDefinition(type, fieldNames);
        if (this._classDefs == null) {
            this._classDefs = new ArrayList();
        }
        this._classDefs.add(def);
        return this.readObjectInstance(cl, def);
    }

    private Object readObjectInstance(Class cl, ObjectDefinition def) throws IOException {
        String type = def.getType();
        String[] fieldNames = def.getFieldNames();
        if (cl != null) {
            Deserializer reader = this.findSerializerFactory().getObjectDeserializer(type);
            if (cl != reader.getType() && cl.isAssignableFrom(reader.getType())) {
                return reader.readObject(this, fieldNames);
            }
            reader = this.findSerializerFactory().getDeserializer(cl);
            return reader.readObject(this, fieldNames);
        }
        return this.findSerializerFactory().readObject(this, type, fieldNames);
    }

    private String readLenString() throws IOException {
        int ch;
        int len = this.readInt();
        this._isLastChunk = true;
        this._chunkLength = len;
        this._sbuf.setLength(0);
        while ((ch = this.parseChar()) >= 0) {
            this._sbuf.append((char)ch);
        }
        return this._sbuf.toString();
    }

    private String readLenString(int len) throws IOException {
        int ch;
        this._isLastChunk = true;
        this._chunkLength = len;
        this._sbuf.setLength(0);
        while ((ch = this.parseChar()) >= 0) {
            this._sbuf.append((char)ch);
        }
        return this._sbuf.toString();
    }

    public Object readRemote() throws IOException {
        String type = this.readType();
        String url = this.readString();
        return this.resolveRemote(type, url);
    }

    public Object readRef() throws IOException {
        return this._refs.get(this.parseInt());
    }

    public int readListStart() throws IOException {
        return this.read();
    }

    public int readMapStart() throws IOException {
        return this.read();
    }

    public boolean isEnd() throws IOException {
        int code;
        if (this._offset < this._length) {
            code = this._buffer[this._offset] & 0xFF;
        } else {
            code = this.read();
            if (code >= 0) {
                --this._offset;
            }
        }
        return code < 0 || code == 122;
    }

    public void readEnd() throws IOException {
        int code;
        int n = code = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
        if (code != 122) {
            throw this.error(new CharBuffer().append("unknown code:").append((char)code).toString());
        }
    }

    public void readMapEnd() throws IOException {
        int code;
        int n = code = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
        if (code != 122) {
            throw this.error(new CharBuffer().append("expected end of map ('z') at '").append((char)code).append("'").toString());
        }
    }

    public void readListEnd() throws IOException {
        int code;
        int n = code = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
        if (code != 122) {
            throw this.error(new CharBuffer().append("expected end of list ('z') at '").append((char)code).append("'").toString());
        }
    }

    public int addRef(Object ref) {
        if (this._refs == null) {
            this._refs = new ArrayList();
        }
        this._refs.add(ref);
        return this._refs.size() - 1;
    }

    public void setRef(int i, Object ref) {
        this._refs.set(i, ref);
    }

    public Object resolveRemote(String type, String url) throws IOException {
        HessianRemoteResolver resolver = this.getRemoteResolver();
        if (resolver != null) {
            return resolver.lookup(type, url);
        }
        return new HessianRemote(type, url);
    }

    public String readType() throws IOException {
        int code;
        int n = code = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
        if (code == 116) {
            int len = 256 * this.read() + this.read();
            String type = this.readLenString(len);
            if (this._types == null) {
                this._types = new ArrayList();
            }
            this._types.add(type);
            return type;
        }
        if (code == 84) {
            int ref = this.readInt();
            return (String)this._types.get(ref);
        }
        if (code >= 0) {
            --this._offset;
        }
        return "";
    }

    public int readLength() throws IOException {
        int code = this.read();
        if (code == 117) {
            return this.read();
        }
        if (code == 108) {
            return this.parseInt();
        }
        if (code >= 0) {
            --this._offset;
        }
        return -1;
    }

    private int parseInt() throws IOException {
        int offset = this._offset;
        if (offset + 3 < this._length) {
            byte[] buffer = this._buffer;
            int b32 = buffer[offset + 0] & 0xFF;
            int b24 = buffer[offset + 1] & 0xFF;
            int b16 = buffer[offset + 2] & 0xFF;
            int b8 = buffer[offset + 3] & 0xFF;
            this._offset = offset + 4;
            return (b32 << 24) + (b24 << 16) + (b16 << 8) + b8;
        }
        int b32 = this.read();
        int b24 = this.read();
        int b16 = this.read();
        int b8 = this.read();
        return (b32 << 24) + (b24 << 16) + (b16 << 8) + b8;
    }

    private long parseLong() throws IOException {
        long b64 = this.read();
        long b56 = this.read();
        long b48 = this.read();
        long b40 = this.read();
        long b32 = this.read();
        long b24 = this.read();
        long b16 = this.read();
        long b8 = this.read();
        return (b64 << 56) + (b56 << 48) + (b48 << 40) + (b40 << 32) + (b32 << 24) + (b24 << 16) + (b16 << 8) + b8;
    }

    private double parseDouble() throws IOException {
        long bits = this.parseLong();
        return Double.longBitsToDouble(bits);
    }

    Node parseXML() throws IOException {
        throw new UnsupportedOperationException();
    }

    private int parseChar() throws IOException {
        block5: while (this._chunkLength <= 0) {
            if (this._isLastChunk) {
                return -1;
            }
            int code = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
            switch (code) {
                case 115: 
                case 120: {
                    this._isLastChunk = false;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block5;
                }
                case 83: 
                case 88: {
                    this._isLastChunk = true;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block5;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this._isLastChunk = true;
                    this._chunkLength = code - 0;
                    continue block5;
                }
            }
            throw this.expect("string", code);
        }
        --this._chunkLength;
        return this.parseUTF8Char();
    }

    private int parseUTF8Char() throws IOException {
        int ch;
        int n = ch = this._offset < this._length ? this._buffer[this._offset++] & 0xFF : this.read();
        if (ch < 128) {
            return ch;
        }
        if ((ch & 0xE0) == 192) {
            int ch1 = this.read();
            int v = ((ch & 0x1F) << 6) + (ch1 & 0x3F);
            return v;
        }
        if ((ch & 0xF0) == 224) {
            int ch1 = this.read();
            int ch2 = this.read();
            int v = ((ch & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F);
            return v;
        }
        throw this.error("bad utf-8 encoding");
    }

    private int parseByte() throws IOException {
        block5: while (this._chunkLength <= 0) {
            if (this._isLastChunk) {
                return -1;
            }
            int code = this.read();
            switch (code) {
                case 98: {
                    this._isLastChunk = false;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block5;
                }
                case 66: {
                    this._isLastChunk = true;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block5;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    this._isLastChunk = true;
                    this._chunkLength = code - 32;
                    continue block5;
                }
            }
            throw this.expect("byte[]", code);
        }
        --this._chunkLength;
        return this.read();
    }

    public InputStream readInputStream() throws IOException {
        int tag = this.read();
        switch (tag) {
            case 78: {
                return null;
            }
            case 66: 
            case 98: {
                this._isLastChunk = tag == 66;
                this._chunkLength = (this.read() << 8) + this.read();
                break;
            }
            default: {
                throw this.expect("inputStream", tag);
            }
        }
        return new InputStream(){
            boolean _isClosed = false;

            public int read() throws IOException {
                if (this._isClosed) {
                    return -1;
                }
                int ch = Hessian2Input.this.parseByte();
                if (ch < 0) {
                    this._isClosed = true;
                }
                return ch;
            }

            public int read(byte[] buffer, int offset, int length) throws IOException {
                if (this._isClosed) {
                    return -1;
                }
                int len = Hessian2Input.this.read(buffer, offset, length);
                if (len < 0) {
                    this._isClosed = true;
                }
                return len;
            }

            public void close() throws IOException {
                while (this.read() >= 0) {
                }
            }
        };
    }

    int read(byte[] buffer, int offset, int length) throws IOException {
        int readLength = 0;
        while (length > 0) {
            block5: while (this._chunkLength <= 0) {
                if (this._isLastChunk) {
                    return readLength == 0 ? -1 : readLength;
                }
                int code = this.read();
                switch (code) {
                    case 98: {
                        this._isLastChunk = false;
                        this._chunkLength = (this.read() << 8) + this.read();
                        continue block5;
                    }
                    case 66: {
                        this._isLastChunk = true;
                        this._chunkLength = (this.read() << 8) + this.read();
                        continue block5;
                    }
                }
                throw this.expect("byte[]", code);
            }
            int sublen = this._chunkLength;
            if (length < sublen) {
                sublen = length;
            }
            sublen = this._is.read(buffer, offset, sublen);
            offset += sublen;
            readLength += sublen;
            length -= sublen;
            this._chunkLength -= sublen;
        }
        return readLength;
    }

    public final int read() throws IOException {
        if (this._length <= this._offset && !this.readBuffer()) {
            return -1;
        }
        return this._buffer[this._offset++] & 0xFF;
    }

    private final boolean readBuffer() throws IOException {
        byte[] buffer = this._buffer;
        int offset = this._offset;
        int length = this._length;
        if (offset < length) {
            System.arraycopy(buffer, offset, buffer, 0, length - offset);
            offset = length - offset;
        } else {
            offset = 0;
        }
        int len = this._is.read(buffer, offset, 256 - offset);
        if (len <= 0) {
            this._length = offset;
            this._offset = 0;
            return offset > 0;
        }
        this._length = offset + len;
        this._offset = 0;
        return true;
    }

    public Reader getReader() {
        return null;
    }

    protected IOException expect(String expect, int ch) {
        if (ch < 0) {
            return this.error(new CharBuffer().append("expected ").append(expect).append(" at end of file").toString());
        }
        return this.error(new CharBuffer().append("expected ").append(expect).append(" at ").append(ch).toString());
    }

    protected IOException error(String message) {
        if (this._method != null) {
            return new HessianProtocolException(new CharBuffer().append(this._method).append(": ").append(message).toString());
        }
        return new HessianProtocolException(message);
    }

    public void close() {
    }

    static {
        try {
            _detailMessageField = Hessian2Input._resin_compat_class_1().getDeclaredField("detailMessage");
            _detailMessageField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Throwable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static final class ObjectDefinition {
        private final String _type;
        private final String[] _fields;

        ObjectDefinition(String type, String[] fields) {
            this._type = type;
            this._fields = fields;
        }

        String getType() {
            return this._type;
        }

        String[] getFieldNames() {
            return this._fields;
        }
    }
}

