/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ByteBasedPName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ByteBasedPNameFactory;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.NameTable;

public final class ByteBasedPNameTable
extends NameTable {
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    private int mCount;
    private int mMainHashMask;
    private int[] mMainHash;
    private ByteBasedPName[] mMainNames;
    private Bucket[] mCollList;
    private int mCollCount;
    private int mCollEnd;
    private transient boolean mNeedRehash;
    private boolean mMainHashShared;
    private boolean mMainNamesShared;
    private boolean mCollListShared;

    public ByteBasedPNameTable(int n2) {
        if (n2 < 16) {
            n2 = 16;
        } else if ((n2 & n2 - 1) != 0) {
            int n3;
            for (n3 = 16; n3 < n2; n3 += n3) {
            }
            n2 = n3;
        }
        this.mCount = 0;
        this.mMainHashShared = false;
        this.mMainNamesShared = false;
        this.mMainHashMask = n2 - 1;
        this.mMainHash = new int[n2];
        this.mMainNames = new ByteBasedPName[n2];
        this.mCollListShared = true;
        this.mCollList = null;
        this.mCollEnd = 0;
        this.mNeedRehash = false;
    }

    ByteBasedPNameTable(ByteBasedPNameTable byteBasedPNameTable) {
        this.mCount = byteBasedPNameTable.mCount;
        this.mMainHashMask = byteBasedPNameTable.mMainHashMask;
        this.mMainHash = byteBasedPNameTable.mMainHash;
        this.mMainNames = byteBasedPNameTable.mMainNames;
        this.mCollList = byteBasedPNameTable.mCollList;
        this.mCollCount = byteBasedPNameTable.mCollCount;
        this.mCollEnd = byteBasedPNameTable.mCollEnd;
        this.mNeedRehash = false;
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public boolean mergeFromChild(ByteBasedPNameTable byteBasedPNameTable) {
        if (byteBasedPNameTable.mCount <= this.mCount) {
            return false;
        }
        this.mCount = byteBasedPNameTable.mCount;
        this.mMainHashMask = byteBasedPNameTable.mMainHashMask;
        this.mMainHash = byteBasedPNameTable.mMainHash;
        this.mMainNames = byteBasedPNameTable.mMainNames;
        this.mCollList = byteBasedPNameTable.mCollList;
        this.mCollCount = byteBasedPNameTable.mCollCount;
        this.mCollEnd = byteBasedPNameTable.mCollEnd;
        byteBasedPNameTable.markAsShared();
        return true;
    }

    public void markAsShared() {
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public void nuke() {
        this.mMainHash = null;
        this.mMainNames = null;
        this.mCollList = null;
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean maybeDirty() {
        return !this.mMainHashShared;
    }

    public ByteBasedPName findSymbol(int n2, int n3, int n4) {
        Object object;
        int n5 = n2 & this.mMainHashMask;
        int n6 = this.mMainHash[n5];
        if ((n6 >> 8 ^ n2) << 8 == 0) {
            object = this.mMainNames[n5];
            if (object == null) {
                return null;
            }
            if (((ByteBasedPName)object).equals(n3, n4)) {
                return object;
            }
        } else if (n6 == 0) {
            return null;
        }
        if ((n6 &= 0xFF) > 0 && (object = this.mCollList[--n6]) != null) {
            return ((Bucket)object).find(n2, n3, n4);
        }
        return null;
    }

    public ByteBasedPName findSymbol(int n2, int[] nArray, int n3) {
        Object object;
        if (n3 < 3) {
            return this.findSymbol(n2, nArray[0], n3 < 2 ? 0 : nArray[1]);
        }
        int n4 = n2 & this.mMainHashMask;
        int n5 = this.mMainHash[n4];
        if ((n5 >> 8 ^ n2) << 8 == 0) {
            object = this.mMainNames[n4];
            if (object == null) {
                return null;
            }
            if (((ByteBasedPName)object).equals(nArray, n3)) {
                return object;
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n5 &= 0xFF) > 0 && (object = this.mCollList[--n5]) != null) {
            return ((Bucket)object).find(n2, nArray, n3);
        }
        return null;
    }

    public ByteBasedPName addSymbol(int n2, String string, int n3, int n4, int n5) {
        ByteBasedPName byteBasedPName = ByteBasedPNameFactory.getInstance().constructPName(n2, string, n3, n4, n5);
        this.doAddSymbol(n2, byteBasedPName);
        return byteBasedPName;
    }

    public ByteBasedPName addSymbol(int n2, String string, int n3, int[] nArray, int n4) {
        ByteBasedPName byteBasedPName = ByteBasedPNameFactory.getInstance().constructPName(n2, string, n3, nArray, n4);
        this.doAddSymbol(n2, byteBasedPName);
        return byteBasedPName;
    }

    public static final int calcHash(int n2) {
        int n3 = n2 * 31;
        n3 ^= n3 >>> 16;
        n3 ^= n3 >>> 8;
        return n3;
    }

    public static final int calcHash(int n2, int n3) {
        int n4 = n2 * 31 + n3;
        n4 ^= n4 >>> 16;
        n4 ^= n4 >>> 8;
        return n4;
    }

    public static final int calcHash(int[] nArray, int n2) {
        int n3 = nArray[0];
        for (int i2 = 1; i2 < n2; ++i2) {
            n3 = n3 * 31 + nArray[i2];
        }
        n3 ^= n3 >>> 16;
        n3 ^= n3 >>> 8;
        return n3;
    }

    public static int[] calcQuads(byte[] byArray) {
        int n2 = byArray.length;
        int[] nArray = new int[(n2 + 3) / 4];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            if (++i2 < n2) {
                n3 = n3 << 8 | byArray[i2] & 0xFF;
                if (++i2 < n2) {
                    n3 = n3 << 8 | byArray[i2] & 0xFF;
                    if (++i2 < n2) {
                        n3 = n3 << 8 | byArray[i2] & 0xFF;
                    }
                }
            }
            nArray[i2 >> 2] = n3;
        }
        return nArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[PNameTable, size: ");
        stringBuilder.append(this.mCount);
        stringBuilder.append('/');
        stringBuilder.append(this.mMainHash.length);
        stringBuilder.append(", ");
        stringBuilder.append(this.mCollCount);
        stringBuilder.append(" coll; avg length: ");
        int n2 = this.mCount;
        for (int i2 = 0; i2 < this.mCollEnd; ++i2) {
            int n3 = this.mCollList[i2].length();
            for (int i3 = 1; i3 <= n3; ++i3) {
                n2 += i3;
            }
        }
        double d2 = this.mCount == 0 ? 0.0 : (double)n2 / (double)this.mCount;
        stringBuilder.append(d2);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void doAddSymbol(int n2, ByteBasedPName byteBasedPName) {
        int n3;
        int n4;
        if (this.mMainHashShared) {
            this.unshareMain();
        }
        if (this.mNeedRehash) {
            this.rehash();
        }
        ++this.mCount;
        int n5 = n2 & this.mMainHashMask;
        if (this.mMainNames[n5] == null) {
            this.mMainHash[n5] = n2 << 8;
            if (this.mMainNamesShared) {
                this.unshareNames();
            }
            this.mMainNames[n5] = byteBasedPName;
        } else {
            if (this.mCollListShared) {
                this.unshareCollision();
            }
            ++this.mCollCount;
            n4 = this.mMainHash[n5];
            n3 = n4 & 0xFF;
            if (n3 == 0) {
                if (this.mCollEnd <= 254) {
                    if ((n3 = this.mCollEnd++) >= this.mCollList.length) {
                        this.expandCollision();
                    }
                } else {
                    n3 = this.findBestBucket();
                }
                this.mMainHash[n5] = n4 & 0xFFFFFF00 | n3 + 1;
            } else {
                --n3;
            }
            this.mCollList[n3] = new Bucket(byteBasedPName, this.mCollList[n3]);
        }
        n4 = this.mMainHash.length;
        if (this.mCount > n4 >> 1) {
            n3 = n4 >> 2;
            if (this.mCount > n4 - n3) {
                this.mNeedRehash = true;
            } else if (this.mCollCount >= n3) {
                this.mNeedRehash = true;
            }
        }
    }

    private void rehash() {
        int n2;
        Bucket[] bucketArray;
        int n3;
        this.mNeedRehash = false;
        this.mMainNamesShared = false;
        int n4 = 0;
        int[] nArray = this.mMainHash;
        int n5 = nArray.length;
        this.mMainHash = new int[n5 + n5];
        this.mMainHashMask = n5 + n5 - 1;
        ByteBasedPName[] byteBasedPNameArray = this.mMainNames;
        this.mMainNames = new ByteBasedPName[n5 + n5];
        for (n3 = 0; n3 < n5; ++n3) {
            bucketArray = byteBasedPNameArray[n3];
            if (bucketArray == null) continue;
            ++n4;
            n2 = bucketArray.hashCode();
            int n6 = n2 & this.mMainHashMask;
            this.mMainNames[n6] = bucketArray;
            this.mMainHash[n6] = n2 << 8;
        }
        n3 = this.mCollEnd;
        if (n3 == 0) {
            return;
        }
        this.mCollCount = 0;
        this.mCollEnd = 0;
        this.mCollListShared = false;
        bucketArray = this.mCollList;
        this.mCollList = new Bucket[bucketArray.length];
        for (n2 = 0; n2 < n3; ++n2) {
            Bucket bucket = bucketArray[n2];
            while (bucket != null) {
                ++n4;
                ByteBasedPName byteBasedPName = bucket.mName;
                int n7 = byteBasedPName.hashCode();
                int n8 = n7 & this.mMainHashMask;
                int n9 = this.mMainHash[n8];
                if (this.mMainNames[n8] == null) {
                    this.mMainHash[n8] = n7 << 8;
                    this.mMainNames[n8] = byteBasedPName;
                } else {
                    ++this.mCollCount;
                    int n10 = n9 & 0xFF;
                    if (n10 == 0) {
                        if (this.mCollEnd <= 254) {
                            if ((n10 = this.mCollEnd++) >= this.mCollList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n10 = this.findBestBucket();
                        }
                        this.mMainHash[n8] = n9 & 0xFFFFFF00 | n10 + 1;
                    } else {
                        --n10;
                    }
                    this.mCollList[n10] = new Bucket(byteBasedPName, this.mCollList[n10]);
                }
                bucket = bucket.mNext;
            }
        }
        if (n4 != this.mCount) {
            throw new Error("Internal error: count after rehash " + n4 + "; should be " + this.mCount);
        }
    }

    private int findBestBucket() {
        Bucket[] bucketArray = this.mCollList;
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        int n4 = this.mCollEnd;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = bucketArray[i2].length();
            if (n5 >= n2) continue;
            if (n5 == 1) {
                return i2;
            }
            n2 = n5;
            n3 = i2;
        }
        return n3;
    }

    private void unshareMain() {
        int[] nArray = this.mMainHash;
        int n2 = this.mMainHash.length;
        this.mMainHash = new int[n2];
        System.arraycopy(nArray, 0, this.mMainHash, 0, n2);
        this.mMainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] bucketArray = this.mCollList;
        if (bucketArray == null) {
            this.mCollList = new Bucket[32];
        } else {
            int n2 = bucketArray.length;
            this.mCollList = new Bucket[n2];
            System.arraycopy(bucketArray, 0, this.mCollList, 0, n2);
        }
        this.mCollListShared = false;
    }

    private void unshareNames() {
        ByteBasedPName[] byteBasedPNameArray = this.mMainNames;
        int n2 = byteBasedPNameArray.length;
        this.mMainNames = new ByteBasedPName[n2];
        System.arraycopy(byteBasedPNameArray, 0, this.mMainNames, 0, n2);
        this.mMainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] bucketArray = this.mCollList;
        int n2 = bucketArray.length;
        this.mCollList = new Bucket[n2 + n2];
        System.arraycopy(bucketArray, 0, this.mCollList, 0, n2);
    }

    static final class Bucket {
        final ByteBasedPName mName;
        final Bucket mNext;

        Bucket(ByteBasedPName byteBasedPName, Bucket bucket) {
            this.mName = byteBasedPName;
            this.mNext = bucket;
        }

        public int length() {
            int n2 = 1;
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ++n2;
                bucket = bucket.mNext;
            }
            return n2;
        }

        public ByteBasedPName find(int n2, int n3, int n4) {
            if (this.mName.hashEquals(n2, n3, n4)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ByteBasedPName byteBasedPName = bucket.mName;
                if (byteBasedPName.hashEquals(n2, n3, n4)) {
                    return byteBasedPName;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public ByteBasedPName find(int n2, int[] nArray, int n3) {
            if (this.mName.hashEquals(n2, nArray, n3)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ByteBasedPName byteBasedPName = bucket.mName;
                if (byteBasedPName.hashEquals(n2, nArray, n3)) {
                    return byteBasedPName;
                }
                bucket = bucket.mNext;
            }
            return null;
        }
    }
}

