/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.IoStreamException;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.LocationImpl;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.InputBootstrapper;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.MergedStream;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ReaderConfig;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ReaderScanner;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.Utf32Reader;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.Utf8Scanner;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.XmlScanner;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.CharsetNames;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class ByteSourceBootstrapper
extends InputBootstrapper {
    private static final byte BYTE_NULL = 0;
    private static final byte BYTE_CR = 13;
    private static final byte BYTE_LF = 10;
    final InputStream _in;
    final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputLen;
    boolean mBigEndian = true;
    int mBytesPerChar = 0;
    boolean mHadBOM = false;
    boolean mByteSizeFound = false;

    private ByteSourceBootstrapper(ReaderConfig readerConfig, InputStream inputStream) {
        super(readerConfig);
        this._in = inputStream;
        this._inputBuffer = readerConfig.allocFullBBuffer(4000);
        this._inputPtr = 0;
        this._inputLen = 0;
    }

    private ByteSourceBootstrapper(ReaderConfig readerConfig, byte[] byArray, int n2, int n3) {
        super(readerConfig);
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputLen = n2 + n3;
        this._inputProcessed = -n2;
    }

    public static ByteSourceBootstrapper construct(ReaderConfig readerConfig, InputStream inputStream) throws XMLStreamException {
        return new ByteSourceBootstrapper(readerConfig, inputStream);
    }

    public static ByteSourceBootstrapper construct(ReaderConfig readerConfig, byte[] byArray, int n2, int n3) throws XMLStreamException {
        return new ByteSourceBootstrapper(readerConfig, byArray, n2, n3);
    }

    @Override
    public final XmlScanner bootstrap() throws XMLStreamException {
        try {
            XmlScanner xmlScanner = this.doBootstrap();
            return xmlScanner;
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        finally {
            this._config.freeSmallCBuffer(this.mKeyword);
        }
    }

    public XmlScanner doBootstrap() throws IOException, XMLStreamException {
        String string = null;
        this.determineStreamEncoding();
        if (this.hasXmlDeclaration()) {
            this.readXmlDeclaration();
            if (this.mFoundEncoding != null) {
                string = this.verifyXmlEncoding(this.mFoundEncoding);
            }
        }
        if (string == null) {
            string = this.mBytesPerChar == 2 ? (this.mBigEndian ? "UTF-16BE" : "UTF-16LE") : (this.mBytesPerChar == 4 ? (this.mBigEndian ? "UTF-32BE" : "UTF-32LE") : "UTF-8");
        }
        this._config.setActualEncoding(string);
        this._config.setXmlDeclInfo(this.mDeclaredXmlVersion, this.mFoundEncoding, this.mStandalone);
        if (string == "UTF-8" || string == "ISO-8859-1" || string == "US-ASCII") {
            return new Utf8Scanner(this._config, this._in, this._inputBuffer, this._inputPtr, this._inputLen);
        }
        if (string.startsWith("UTF-32")) {
            if (string == "UTF-32") {
                string = this.mBigEndian ? "UTF-32BE" : "UTF-32LE";
            }
            Utf32Reader utf32Reader = new Utf32Reader(this._config, this._in, this._inputBuffer, this._inputPtr, this._inputLen, this.mBigEndian);
            return new ReaderScanner(this._config, utf32Reader);
        }
        InputStream inputStream = this._in;
        if (this._inputPtr < this._inputLen) {
            inputStream = new MergedStream(this._config, inputStream, this._inputBuffer, this._inputPtr, this._inputLen);
        }
        if (string == "UTF-16") {
            string = this.mBigEndian ? "UTF-16BE" : "UTF-16LE";
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            return new ReaderScanner(this._config, inputStreamReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IoStreamException("Unsupported encoding: " + unsupportedEncodingException.getMessage());
        }
    }

    private void determineStreamEncoding() throws IOException {
        if (this.ensureLoaded(4)) {
            int n2 = this._inputPtr;
            int n3 = this._inputBuffer[this._inputPtr] << 24 | (this._inputBuffer[this._inputPtr + 1] & 0xFF) << 16 | (this._inputBuffer[this._inputPtr + 2] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 3] & 0xFF;
            block0 : switch (n3) {
                case 65279: {
                    this.mBigEndian = true;
                    this._inputPtr += 4;
                    this.mBytesPerChar = 4;
                    break;
                }
                case -131072: {
                    this.mBigEndian = false;
                    this._inputPtr += 4;
                    this.mBytesPerChar = 4;
                    break;
                }
                case 65534: {
                    this.reportWeirdUCS4("2143");
                    break;
                }
                case -16842752: {
                    this.reportWeirdUCS4("3412");
                    break;
                }
                default: {
                    int n4 = n3 >>> 16;
                    if (n4 == 65279) {
                        this._inputPtr += 2;
                        this.mBytesPerChar = 2;
                        this.mBigEndian = true;
                        break;
                    }
                    if (n4 == 65534) {
                        this._inputPtr += 2;
                        this.mBytesPerChar = 2;
                        this.mBigEndian = false;
                        break;
                    }
                    if (n3 >>> 8 == 0xEFBBBF) {
                        this._inputPtr += 3;
                        this.mBytesPerChar = 1;
                        this.mBigEndian = true;
                        break;
                    }
                    switch (n3) {
                        case 60: {
                            this.mBigEndian = true;
                            this.mBytesPerChar = 4;
                            break block0;
                        }
                        case 0x3C000000: {
                            this.mBytesPerChar = 4;
                            this.mBigEndian = false;
                            break block0;
                        }
                        case 15360: {
                            this.reportWeirdUCS4("2143");
                            break block0;
                        }
                        case 0x3C0000: {
                            this.reportWeirdUCS4("3412");
                            break block0;
                        }
                        case 3932223: {
                            this.mBytesPerChar = 2;
                            this.mBigEndian = true;
                            break block0;
                        }
                        case 1006649088: {
                            this.mBytesPerChar = 2;
                            this.mBigEndian = false;
                            break block0;
                        }
                        case 1010792557: {
                            this.mBytesPerChar = 1;
                            this.mBigEndian = true;
                            break block0;
                        }
                        case 1282385812: {
                            this.reportEBCDIC();
                        }
                    }
                }
            }
            this.mHadBOM = this._inputPtr > n2;
            this._inputRowStart = this._inputPtr;
        }
        boolean bl2 = this.mByteSizeFound = this.mBytesPerChar > 0;
        if (!this.mByteSizeFound) {
            this.mBytesPerChar = 1;
            this.mBigEndian = true;
        }
    }

    protected boolean hasXmlDeclaration() throws IOException, XMLStreamException {
        if (this.mBytesPerChar == 1) {
            if (this.ensureLoaded(6) && this._inputBuffer[this._inputPtr] == 60 && this._inputBuffer[this._inputPtr + 1] == 63 && this._inputBuffer[this._inputPtr + 2] == 120 && this._inputBuffer[this._inputPtr + 3] == 109 && this._inputBuffer[this._inputPtr + 4] == 108 && (this._inputBuffer[this._inputPtr + 5] & 0xFF) <= 32) {
                this._inputPtr += 6;
                return true;
            }
        } else if (this.ensureLoaded(6 * this.mBytesPerChar)) {
            int n2 = this._inputPtr;
            if (this.nextMultiByte() == 60 && this.nextMultiByte() == 63 && this.nextMultiByte() == 120 && this.nextMultiByte() == 109 && this.nextMultiByte() == 108 && this.nextMultiByte() <= 32) {
                return true;
            }
            this._inputPtr = n2;
        }
        return false;
    }

    protected String verifyXmlEncoding(String string) throws XMLStreamException {
        if ((string = CharsetNames.normalize(string)) == "UTF-8") {
            this.verifyEncoding(string, 1);
        } else if (string == "ISO-8859-1") {
            this.verifyEncoding(string, 1);
        } else if (string == "US-ASCII") {
            this.verifyEncoding(string, 1);
        } else if (string == "UTF-16") {
            this.verifyEncoding(string, 2);
        } else if (string == "UTF-16LE") {
            this.verifyEncoding(string, 2, false);
        } else if (string == "UTF-16BE") {
            this.verifyEncoding(string, 2, true);
        } else if (string == "UTF-32") {
            this.verifyEncoding(string, 4);
        } else if (string == "UTF-32LE") {
            this.verifyEncoding(string, 4, false);
        } else if (string == "UTF-32BE") {
            this.verifyEncoding(string, 4, true);
        }
        return string;
    }

    protected boolean ensureLoaded(int n2) throws IOException {
        int n3;
        for (int i2 = this._inputLen - this._inputPtr; i2 < n2; i2 += n3) {
            n3 = this._in == null ? -1 : this._in.read(this._inputBuffer, this._inputLen, this._inputBuffer.length - this._inputLen);
            if (n3 < 1) {
                return false;
            }
            this._inputLen += n3;
        }
        return true;
    }

    protected void loadMore() throws IOException, XMLStreamException {
        this._inputProcessed += this._inputLen;
        this._inputRowStart -= this._inputLen;
        this._inputPtr = 0;
        this._inputLen = this._in == null ? -1 : this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (this._inputLen < 1) {
            this.reportEof();
        }
    }

    @Override
    protected void pushback() {
        this._inputPtr -= this.mBytesPerChar;
    }

    @Override
    protected int getNext() throws IOException, XMLStreamException {
        if (this.mBytesPerChar > 1) {
            return this.nextMultiByte();
        }
        byte by2 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
        return by2 & 0xFF;
    }

    @Override
    protected int getNextAfterWs(boolean bl2) throws IOException, XMLStreamException {
        int n2 = this.mBytesPerChar > 1 ? this.skipMbWs() : this.skipSbWs();
        if (bl2 && n2 == 0) {
            this.reportUnexpectedChar(this.getNext(), "; expected a white space");
        }
        if (this.mBytesPerChar > 1) {
            return this.nextMultiByte();
        }
        byte by2 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
        return by2 & 0xFF;
    }

    @Override
    protected int checkKeyword(String string) throws IOException, XMLStreamException {
        if (this.mBytesPerChar > 1) {
            return this.checkMbKeyword(string);
        }
        return this.checkSbKeyword(string);
    }

    @Override
    protected int readQuotedValue(char[] cArray, int n2) throws IOException, XMLStreamException {
        boolean bl2;
        int n3 = 0;
        int n4 = cArray.length;
        boolean bl3 = bl2 = this.mBytesPerChar > 1;
        while (n3 < n4) {
            int n5;
            if (bl2) {
                n5 = this.nextMultiByte();
                if (n5 == 13 || n5 == 10) {
                    this.skipMbLF(n5);
                    n5 = 10;
                }
            } else {
                int n6;
                int n7 = n6 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
                if (n6 == 0) {
                    this.reportNull();
                }
                if (n6 == 13 || n6 == 10) {
                    this.skipSbLF((byte)n6);
                    n6 = 10;
                }
                n5 = n6 & 0xFF;
            }
            if (n5 == n2) {
                return n3 < n4 ? n3 : -1;
            }
            if (n3 >= n4) continue;
            cArray[n3++] = (char)n5;
        }
        return -1;
    }

    @Override
    protected Location getLocation() {
        int n2 = this._inputProcessed + this._inputPtr;
        int n3 = this._inputPtr - this._inputRowStart;
        if (this.mBytesPerChar > 1) {
            n2 /= this.mBytesPerChar;
            n3 /= this.mBytesPerChar;
        }
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), n2, this._inputRow, n3);
    }

    protected byte nextByte() throws IOException, XMLStreamException {
        if (this._inputPtr >= this._inputLen) {
            this.loadMore();
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected int skipSbWs() throws IOException, XMLStreamException {
        int n2 = 0;
        while (true) {
            byte by2;
            byte by3 = by2 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            if ((by2 & 0xFF) > 32) {
                --this._inputPtr;
                break;
            }
            if (by2 == 13 || by2 == 10) {
                this.skipSbLF(by2);
            } else if (by2 == 0) {
                this.reportNull();
            }
            ++n2;
        }
        return n2;
    }

    protected void skipSbLF(byte by2) throws IOException, XMLStreamException {
        if (by2 == 13) {
            byte by3;
            byte by4 = by3 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            if (by3 != 10) {
                --this._inputPtr;
            }
        }
        ++this._inputRow;
        this._inputRowStart = this._inputPtr;
    }

    protected int checkSbKeyword(String string) throws IOException, XMLStreamException {
        int n2 = string.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            byte by2;
            byte by3 = by2 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            if (by2 == 0) {
                this.reportNull();
            }
            if ((by2 & 0xFF) == string.charAt(i2)) continue;
            return by2 & 0xFF;
        }
        return 0;
    }

    protected int nextMultiByte() throws IOException, XMLStreamException {
        int n2;
        byte by2;
        byte by3 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
        byte by4 = by2 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
        if (this.mBytesPerChar == 2) {
            n2 = this.mBigEndian ? (by3 & 0xFF) << 8 | by2 & 0xFF : by3 & 0xFF | (by2 & 0xFF) << 8;
        } else {
            byte by5 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            byte by6 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            n2 = this.mBigEndian ? by3 << 24 | (by2 & 0xFF) << 16 | (by5 & 0xFF) << 8 | by6 & 0xFF : by6 << 24 | (by5 & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
        }
        if (n2 == 0) {
            this.reportNull();
        }
        return n2;
    }

    protected int skipMbWs() throws IOException, XMLStreamException {
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.nextMultiByte()) > 32) {
                this._inputPtr -= this.mBytesPerChar;
                break;
            }
            if (n3 == 13 || n3 == 10) {
                this.skipMbLF(n3);
            } else if (n3 == 0) {
                this.reportNull();
            }
            ++n2;
        }
        return n2;
    }

    protected void skipMbLF(int n2) throws IOException, XMLStreamException {
        int n3;
        if (n2 == 13 && (n3 = this.nextMultiByte()) != 10) {
            this._inputPtr -= this.mBytesPerChar;
        }
        ++this._inputRow;
        this._inputRowStart = this._inputPtr;
    }

    protected int checkMbKeyword(String string) throws IOException, XMLStreamException {
        int n2 = string.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = this.nextMultiByte();
            if (n3 == 0) {
                this.reportNull();
            }
            if (n3 == string.charAt(i2)) continue;
            return n3;
        }
        return 0;
    }

    private void verifyEncoding(String string, int n2) throws XMLStreamException {
        if (this.mByteSizeFound && n2 != this.mBytesPerChar) {
            this.reportXmlProblem("Declared encoding '" + string + "' uses " + n2 + " bytes per character; but physical encoding appeared to use " + this.mBytesPerChar + "; cannot decode");
        }
    }

    private void verifyEncoding(String string, int n2, boolean bl2) throws XMLStreamException {
        if (this.mByteSizeFound) {
            this.verifyEncoding(string, n2);
            if (bl2 != this.mBigEndian) {
                String string2 = bl2 ? "big" : "little";
                this.reportXmlProblem("Declared encoding '" + string + "' has different endianness (" + string2 + " endian) than what physical ordering appeared to be; cannot decode");
            }
        }
    }

    private void reportWeirdUCS4(String string) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string + ") detected");
    }

    private void reportEBCDIC() throws IOException {
        throw new CharConversionException("Unsupported encoding (EBCDIC)");
    }
}

