/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.WFCException;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ReaderConfig;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.XmlScanner;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.XmlConsts;
import java.io.IOException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public abstract class InputBootstrapper
implements XmlConsts {
    public static final String ERR_XMLDECL_KW_VERSION = "; expected keyword 'version'";
    public static final String ERR_XMLDECL_KW_ENCODING = "; expected keyword 'encoding'";
    public static final String ERR_XMLDECL_KW_STANDALONE = "; expected keyword 'standalone'";
    public static final String ERR_XMLDECL_END_MARKER = "; expected \"?>\" end marker";
    public static final String ERR_XMLDECL_EXP_SPACE = "; expected a white space";
    public static final String ERR_XMLDECL_EXP_EQ = "; expected '=' after ";
    public static final String ERR_XMLDECL_EXP_ATTRVAL = "; expected a quote character enclosing value for ";
    protected int _inputProcessed = 0;
    protected int _inputRow = 0;
    protected int _inputRowStart = 0;
    final ReaderConfig _config;
    int mDeclaredXmlVersion = 0;
    String mFoundEncoding;
    String mStandalone;
    final char[] mKeyword;

    protected InputBootstrapper(ReaderConfig readerConfig) {
        this._config = readerConfig;
        this.mKeyword = readerConfig.allocSmallCBuffer(60);
    }

    public abstract XmlScanner bootstrap() throws XMLStreamException;

    protected void readXmlDeclaration() throws IOException, XMLStreamException {
        int n2 = this.getNextAfterWs(false);
        if (n2 != 118) {
            this.reportUnexpectedChar(n2, ERR_XMLDECL_KW_VERSION);
        } else {
            this.mDeclaredXmlVersion = this.readXmlVersion();
            n2 = this.getWsOrChar(63);
        }
        if (n2 == 101) {
            this.mFoundEncoding = this.readXmlEncoding();
            n2 = this.getWsOrChar(63);
        }
        if (n2 == 115) {
            this.mStandalone = this.readXmlStandalone();
            n2 = this.getWsOrChar(63);
        }
        if (n2 != 63) {
            this.reportUnexpectedChar(n2, ERR_XMLDECL_END_MARKER);
        }
        if ((n2 = this.getNext()) != 62) {
            this.reportUnexpectedChar(n2, ERR_XMLDECL_END_MARKER);
        }
    }

    private final int readXmlVersion() throws IOException, XMLStreamException {
        int n2;
        int n3 = this.checkKeyword("version");
        if (n3 != 0) {
            this.reportUnexpectedChar(n3, "version");
        }
        if ((n2 = this.readQuotedValue(this.mKeyword, n3 = this.handleEq("version"))) == 3 && this.mKeyword[0] == '1' && this.mKeyword[1] == '.') {
            n3 = this.mKeyword[2];
            if (n3 == 48) {
                return 256;
            }
            if (n3 == 49) {
                return 272;
            }
        }
        String string = n2 < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (n2 == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, n2) + "'");
        this.reportPseudoAttrProblem("version", string, "1.0", "1.1");
        return 0;
    }

    private final String readXmlEncoding() throws IOException, XMLStreamException {
        int n2;
        int n3 = this.checkKeyword("encoding");
        if (n3 != 0) {
            this.reportUnexpectedChar(n3, "encoding");
        }
        if ((n2 = this.readQuotedValue(this.mKeyword, n3 = this.handleEq("encoding"))) == 0) {
            this.reportPseudoAttrProblem("encoding", null, null, null);
        }
        if (n2 < 0) {
            return new String(this.mKeyword);
        }
        return new String(this.mKeyword, 0, n2);
    }

    private final String readXmlStandalone() throws IOException, XMLStreamException {
        int n2;
        int n3 = this.checkKeyword("standalone");
        if (n3 != 0) {
            this.reportUnexpectedChar(n3, "standalone");
        }
        if ((n2 = this.readQuotedValue(this.mKeyword, n3 = this.handleEq("standalone"))) == 2) {
            if (this.mKeyword[0] == 'n' && this.mKeyword[1] == 'o') {
                return "no";
            }
        } else if (n2 == 3 && this.mKeyword[0] == 'y' && this.mKeyword[1] == 'e' && this.mKeyword[2] == 's') {
            return "yes";
        }
        String string = n2 < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (n2 == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, n2) + "'");
        this.reportPseudoAttrProblem("standalone", string, "yes", "no");
        return string;
    }

    private final int handleEq(String string) throws IOException, XMLStreamException {
        int n2 = this.getNextAfterWs(false);
        if (n2 != 61) {
            this.reportUnexpectedChar(n2, "; expected '=' after '" + string + "'");
        }
        if ((n2 = this.getNextAfterWs(false)) != 34 && n2 != 39) {
            this.reportUnexpectedChar(n2, "; expected a quote character enclosing value for '" + string + "'");
        }
        return n2;
    }

    private final int getWsOrChar(int n2) throws IOException, XMLStreamException {
        int n3 = this.getNext();
        if (n3 == n2) {
            return n3;
        }
        if (n3 > 32) {
            this.reportUnexpectedChar(n3, "; expected either '" + (char)n2 + "' or white space");
        }
        if (n3 == 10 || n3 == 13) {
            this.pushback();
        }
        return this.getNextAfterWs(false);
    }

    protected abstract void pushback();

    protected abstract int getNext() throws IOException, XMLStreamException;

    protected abstract int getNextAfterWs(boolean var1) throws IOException, XMLStreamException;

    protected abstract int checkKeyword(String var1) throws IOException, XMLStreamException;

    protected abstract int readQuotedValue(char[] var1, int var2) throws IOException, XMLStreamException;

    protected abstract Location getLocation();

    protected void reportXmlProblem(String string) throws XMLStreamException {
        throw new WFCException(string, this.getLocation());
    }

    protected void reportNull() throws XMLStreamException {
        this.reportXmlProblem("Illegal null byte/char in input stream");
    }

    protected void reportEof() throws XMLStreamException {
        this.reportXmlProblem("Unexpected end-of-input in xml declaration");
    }

    protected void reportUnexpectedChar(int n2, String string) throws XMLStreamException {
        String string2 = Character.isISOControl((char)n2) ? "Unexpected character (CTRL-CHAR, code " + n2 + ")" + string : "Unexpected character '" + (char)n2 + "' (code " + n2 + ")" + string;
        this.reportXmlProblem(string2);
    }

    protected final void reportPseudoAttrProblem(String string, String string2, String string3, String string4) throws XMLStreamException {
        String string5;
        String string6 = string5 = string3 == null ? "" : "; expected \"" + string3 + "\" or \"" + string4 + "\"";
        if (string2 == null || string2.length() == 0) {
            this.reportXmlProblem("Missing XML pseudo-attribute '" + string + "' value" + string5);
        }
        this.reportXmlProblem("Invalid XML pseudo-attribute '" + string + "' value " + string2 + string5);
    }
}

