/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ReaderConfig;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class Utf32Reader
extends Reader {
    static final char NULL_CHAR = '\u0000';
    final ReaderConfig mConfig;
    protected InputStream mIn;
    protected byte[] mBuffer;
    protected int mPtr;
    protected int mLength;
    final boolean mBigEndian;
    char mSurrogate = '\u0000';
    int mCharCount = 0;
    int mByteCount = 0;
    char[] mTmpBuf = null;

    public Utf32Reader(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl2) {
        this.mConfig = readerConfig;
        this.mBigEndian = bl2;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.mIn;
        if (inputStream != null) {
            this.mIn = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mTmpBuf == null) {
            this.mTmpBuf = new char[1];
        }
        if (this.read(this.mTmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this.mTmpBuf[0];
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        if (this.mBuffer == null) {
            return -1;
        }
        if (n3 < 1) {
            return n3;
        }
        if (n2 < 0 || n2 + n3 > cArray.length) {
            this.reportBounds(cArray, n2, n3);
        }
        n3 += n2;
        int n4 = n2;
        if (this.mSurrogate != '\u0000') {
            cArray[n4++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            int n5 = this.mLength - this.mPtr;
            if (n5 < 4 && !this.loadMore(n5)) {
                return -1;
            }
        }
        byte[] byArray = this.mBuffer;
        while (n4 < n3) {
            int n6 = this.mPtr;
            int n7 = this.mBigEndian ? byArray[n6] << 24 | (byArray[n6 + 1] & 0xFF) << 16 | (byArray[n6 + 2] & 0xFF) << 8 | byArray[n6 + 3] & 0xFF : byArray[n6] & 0xFF | (byArray[n6 + 1] & 0xFF) << 8 | (byArray[n6 + 2] & 0xFF) << 16 | byArray[n6 + 3] << 24;
            this.mPtr += 4;
            if (n7 >= 55296) {
                if (n7 > 0x10FFFF) {
                    this.reportInvalid(n7, n4 - n2, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                }
                if (n7 > 65535) {
                    cArray[n4++] = (char)(55296 + ((n7 -= 65536) >> 10));
                    n7 = 0xDC00 | n7 & 0x3FF;
                    if (n4 >= n3) {
                        this.mSurrogate = (char)n7;
                        break;
                    }
                } else if (n7 < 57344) {
                    this.reportInvalid(n7, n4 - n2, "(a surrogate char) ");
                } else if (n7 >= 65534) {
                    this.reportInvalid(n7, n4 - n2, "");
                }
            }
            cArray[n4++] = (char)n7;
            if (this.mPtr < this.mLength) continue;
            break;
        }
        n3 = n4 - n2;
        this.mCharCount += n3;
        return n3;
    }

    private boolean loadMore(int n2) throws IOException {
        int n3;
        this.mByteCount += this.mLength - n2;
        if (n2 > 0) {
            if (this.mPtr > 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    this.mBuffer[n3] = this.mBuffer[this.mPtr + n3];
                }
                this.mPtr = 0;
            }
            this.mLength = n2;
        } else {
            this.mPtr = 0;
            n3 = this.mIn.read(this.mBuffer);
            if (n3 < 1) {
                this.mLength = 0;
                if (n3 < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
            this.mLength = n3;
        }
        while (this.mLength < 4) {
            n3 = this.mIn.read(this.mBuffer, this.mLength, this.mBuffer.length - this.mLength);
            if (n3 < 1) {
                if (n3 < 0) {
                    this.freeBuffers();
                    this.reportUnexpectedEOF(this.mLength, 4);
                }
                this.reportStrangeStream();
            }
            this.mLength += n3;
        }
        return true;
    }

    public final void freeBuffers() {
        byte[] byArray = this.mBuffer;
        if (byArray != null) {
            this.mBuffer = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(byArray);
            }
        }
    }

    private void reportUnexpectedEOF(int n2, int n3) throws IOException {
        int n4 = this.mByteCount + n2;
        int n5 = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n2 + ", needed " + n3 + ", at char #" + n5 + ", byte #" + n4 + ")");
    }

    private void reportInvalid(int n2, int n3, String string) throws IOException {
        int n4 = this.mByteCount + this.mPtr - 1;
        int n5 = this.mCharCount + n3;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n2) + string + " at char #" + n5 + ", byte #" + n4 + ")");
    }

    protected void reportBounds(char[] cArray, int n2, int n3) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n2 + "," + n3 + "), cbuf[" + cArray.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

