/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WNameFactory;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.NameTable;
import javax.xml.stream.XMLStreamException;

public final class WNameTable
extends NameTable {
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    final WNameFactory mNameFactory;
    final WNameTable mParent;
    private int mCount;
    private int mMainHashMask;
    private int[] mMainHash;
    private WName[] mMainNames;
    private Bucket[] mCollList;
    private int mCollCount;
    private int mCollEnd;
    private transient boolean mNeedRehash;
    private boolean mMainHashShared;
    private boolean mMainNamesShared;
    private boolean mCollListShared;

    protected WNameTable(int n2) {
        this.mNameFactory = null;
        this.mParent = null;
        if (n2 < 16) {
            n2 = 16;
        } else if ((n2 & n2 - 1) != 0) {
            int n3;
            for (n3 = 16; n3 < n2; n3 += n3) {
            }
            n2 = n3;
        }
        this.mCount = 0;
        this.mMainHashShared = false;
        this.mMainNamesShared = false;
        this.mMainHashMask = n2 - 1;
        this.mMainHash = new int[n2];
        this.mMainNames = new WName[n2];
        this.mCollListShared = true;
        this.mCollList = null;
        this.mCollEnd = 0;
        this.mNeedRehash = false;
    }

    private WNameTable(WNameTable wNameTable, WNameFactory wNameFactory) {
        this.mParent = wNameTable;
        this.mNameFactory = wNameFactory;
        this.mCount = wNameTable.mCount;
        this.mMainHashMask = wNameTable.mMainHashMask;
        this.mMainHash = wNameTable.mMainHash;
        this.mMainNames = wNameTable.mMainNames;
        this.mCollList = wNameTable.mCollList;
        this.mCollCount = wNameTable.mCollCount;
        this.mCollEnd = wNameTable.mCollEnd;
        this.mNeedRehash = false;
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    protected synchronized WNameTable createChild(WNameFactory wNameFactory) {
        return new WNameTable(this, wNameFactory);
    }

    public boolean mergeToParent() {
        boolean bl2 = this.mParent.mergeFromChild(this);
        this.markAsShared();
        return bl2;
    }

    private synchronized boolean mergeFromChild(WNameTable wNameTable) {
        if (wNameTable.mCount <= this.mCount) {
            return false;
        }
        this.mCount = wNameTable.mCount;
        this.mMainHashMask = wNameTable.mMainHashMask;
        this.mMainHash = wNameTable.mMainHash;
        this.mMainNames = wNameTable.mMainNames;
        this.mCollList = wNameTable.mCollList;
        this.mCollCount = wNameTable.mCollCount;
        this.mCollEnd = wNameTable.mCollEnd;
        return true;
    }

    public void markAsShared() {
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public void nuke() {
        this.mMainHash = null;
        this.mMainNames = null;
        this.mCollList = null;
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean maybeDirty() {
        return !this.mMainHashShared;
    }

    public WName findSymbol(String string) throws XMLStreamException {
        WName wName;
        Object object;
        int n2 = string.hashCode();
        int n3 = n2 & this.mMainHashMask;
        int n4 = this.mMainHash[n3];
        if ((n4 >> 8 ^ n2) << 8 == 0 && (object = this.mMainNames[n3]) != null && ((WName)object).hasName(string)) {
            return object;
        }
        if (n4 != 0 && (n4 &= 0xFF) > 0 && (object = this.mCollList[--n4]) != null && (wName = ((Bucket)object).find(string)) != null) {
            return wName;
        }
        object = this.mNameFactory.constructName(string);
        this.addSymbol((WName)object);
        return object;
    }

    public WName findSymbol(String string, String string2) throws XMLStreamException {
        WName wName;
        Object object;
        int n2 = string2.hashCode() ^ string.hashCode();
        int n3 = n2 & this.mMainHashMask;
        int n4 = this.mMainHash[n3];
        if ((n4 >> 8 ^ n2) << 8 == 0 && (object = this.mMainNames[n3]) != null && ((WName)object).hasName(string, string2)) {
            return object;
        }
        if (n4 != 0 && (n4 &= 0xFF) > 0 && (object = this.mCollList[--n4]) != null && (wName = ((Bucket)object).find(string, string2)) != null) {
            return wName;
        }
        object = this.mNameFactory.constructName(string, string2);
        this.addSymbol((WName)object);
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[WNameTable, size: ");
        stringBuilder.append(this.mCount);
        stringBuilder.append('/');
        stringBuilder.append(this.mMainHash.length);
        stringBuilder.append(", ");
        stringBuilder.append(this.mCollCount);
        stringBuilder.append(" coll; avg length: ");
        int n2 = this.mCount;
        for (int i2 = 0; i2 < this.mCollEnd; ++i2) {
            int n3 = this.mCollList[i2].length();
            for (int i3 = 1; i3 <= n3; ++i3) {
                n2 += i3;
            }
        }
        double d2 = this.mCount == 0 ? 0.0 : (double)n2 / (double)this.mCount;
        stringBuilder.append(d2);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toDebugString() {
        Object object;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[WNameTable, size: ");
        stringBuilder.append(this.mCount);
        stringBuilder.append('/');
        stringBuilder.append(this.mMainHash.length);
        stringBuilder.append(" -> ");
        for (n2 = 0; n2 < this.mMainHash.length; ++n2) {
            stringBuilder.append("\n#");
            stringBuilder.append(n2);
            stringBuilder.append(": 0x");
            stringBuilder.append(Integer.toHexString(this.mMainHash[n2]));
            stringBuilder.append(" == ");
            object = this.mMainNames[n2];
            if (object == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append('\"');
            stringBuilder.append(((WName)object).toString());
            stringBuilder.append('\"');
        }
        stringBuilder.append("\nSpill(");
        stringBuilder.append(this.mCollEnd);
        stringBuilder.append("):");
        for (n2 = 0; n2 < this.mCollEnd; ++n2) {
            object = this.mCollList[n2];
            stringBuilder.append("\nsp#");
            stringBuilder.append(n2);
            stringBuilder.append(": ");
            stringBuilder.append(((Bucket)object).toDebugString());
        }
        return stringBuilder.toString();
    }

    private void addSymbol(WName wName) {
        int n2;
        int n3;
        if (this.mMainHashShared) {
            this.unshareMain();
        }
        if (this.mNeedRehash) {
            this.rehash();
        }
        int n4 = wName.hashCode();
        ++this.mCount;
        int n5 = n4 & this.mMainHashMask;
        if (this.mMainNames[n5] == null) {
            this.mMainHash[n5] = n4 << 8;
            if (this.mMainNamesShared) {
                this.unshareNames();
            }
            this.mMainNames[n5] = wName;
        } else {
            if (this.mCollListShared) {
                this.unshareCollision();
            }
            ++this.mCollCount;
            n3 = this.mMainHash[n5];
            n2 = n3 & 0xFF;
            if (n2 == 0) {
                if (this.mCollEnd <= 254) {
                    if ((n2 = this.mCollEnd++) >= this.mCollList.length) {
                        this.expandCollision();
                    }
                } else {
                    n2 = this.findBestBucket();
                }
                this.mMainHash[n5] = n3 & 0xFFFFFF00 | n2 + 1;
            } else {
                --n2;
            }
            this.mCollList[n2] = new Bucket(wName, this.mCollList[n2]);
        }
        n3 = this.mMainHash.length;
        if (this.mCount > n3 >> 1) {
            n2 = n3 >> 2;
            if (this.mCount > n3 - n2) {
                this.mNeedRehash = true;
            } else if (this.mCollCount >= n2) {
                this.mNeedRehash = true;
            }
        }
    }

    private void rehash() {
        int n2;
        Bucket[] bucketArray;
        int n3;
        this.mNeedRehash = false;
        this.mMainNamesShared = false;
        int n4 = 0;
        int[] nArray = this.mMainHash;
        int n5 = nArray.length;
        this.mMainHash = new int[n5 + n5];
        this.mMainHashMask = n5 + n5 - 1;
        WName[] wNameArray = this.mMainNames;
        this.mMainNames = new WName[n5 + n5];
        for (n3 = 0; n3 < n5; ++n3) {
            bucketArray = wNameArray[n3];
            if (bucketArray == null) continue;
            ++n4;
            n2 = bucketArray.hashCode();
            int n6 = n2 & this.mMainHashMask;
            this.mMainNames[n6] = bucketArray;
            this.mMainHash[n6] = n2 << 8;
        }
        n3 = this.mCollEnd;
        if (n3 == 0) {
            return;
        }
        this.mCollCount = 0;
        this.mCollEnd = 0;
        this.mCollListShared = false;
        bucketArray = this.mCollList;
        this.mCollList = new Bucket[bucketArray.length];
        for (n2 = 0; n2 < n3; ++n2) {
            Bucket bucket = bucketArray[n2];
            while (bucket != null) {
                ++n4;
                WName wName = bucket.mName;
                int n7 = wName.hashCode();
                int n8 = n7 & this.mMainHashMask;
                int n9 = this.mMainHash[n8];
                if (this.mMainNames[n8] == null) {
                    this.mMainHash[n8] = n7 << 8;
                    this.mMainNames[n8] = wName;
                } else {
                    ++this.mCollCount;
                    int n10 = n9 & 0xFF;
                    if (n10 == 0) {
                        if (this.mCollEnd <= 254) {
                            if ((n10 = this.mCollEnd++) >= this.mCollList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n10 = this.findBestBucket();
                        }
                        this.mMainHash[n8] = n9 & 0xFFFFFF00 | n10 + 1;
                    } else {
                        --n10;
                    }
                    this.mCollList[n10] = new Bucket(wName, this.mCollList[n10]);
                }
                bucket = bucket.mNext;
            }
        }
        if (n4 != this.mCount) {
            throw new Error("Internal error: count after rehash " + n4 + "; should be " + this.mCount);
        }
    }

    private int findBestBucket() {
        Bucket[] bucketArray = this.mCollList;
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        int n4 = this.mCollEnd;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = bucketArray[i2].length();
            if (n5 >= n2) continue;
            if (n5 == 1) {
                return i2;
            }
            n2 = n5;
            n3 = i2;
        }
        return n3;
    }

    private void unshareMain() {
        int[] nArray = this.mMainHash;
        int n2 = this.mMainHash.length;
        this.mMainHash = new int[n2];
        System.arraycopy(nArray, 0, this.mMainHash, 0, n2);
        this.mMainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] bucketArray = this.mCollList;
        if (bucketArray == null) {
            this.mCollList = new Bucket[32];
        } else {
            int n2 = bucketArray.length;
            this.mCollList = new Bucket[n2];
            System.arraycopy(bucketArray, 0, this.mCollList, 0, n2);
        }
        this.mCollListShared = false;
    }

    private void unshareNames() {
        WName[] wNameArray = this.mMainNames;
        int n2 = wNameArray.length;
        this.mMainNames = new WName[n2];
        System.arraycopy(wNameArray, 0, this.mMainNames, 0, n2);
        this.mMainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] bucketArray = this.mCollList;
        int n2 = bucketArray.length;
        this.mCollList = new Bucket[n2 + n2];
        System.arraycopy(bucketArray, 0, this.mCollList, 0, n2);
    }

    static final class Bucket {
        final WName mName;
        final Bucket mNext;

        Bucket(WName wName, Bucket bucket) {
            this.mName = wName;
            this.mNext = bucket;
        }

        public int length() {
            int n2 = 1;
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ++n2;
                bucket = bucket.mNext;
            }
            return n2;
        }

        public WName find(String string) {
            if (this.mName.hasName(string)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                WName wName = bucket.mName;
                if (wName.hasName(string)) {
                    return wName;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public WName find(String string, String string2) {
            if (this.mName.hasName(string, string2)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                WName wName = bucket.mName;
                if (wName.hasName(string, string2)) {
                    return wName;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public String toDebugString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[Bucket(");
            stringBuilder.append(this.length());
            stringBuilder.append("): ");
            Bucket bucket = this;
            while (bucket != null) {
                stringBuilder.append('\"');
                stringBuilder.append(bucket.mName.toString());
                stringBuilder.append("\" -> ");
                bucket = bucket.mNext;
            }
            stringBuilder.append("NULL]");
            return stringBuilder.toString();
        }
    }
}

