/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.CommonConfig;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WNameFactory;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WNameTable;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.BufferRecycler;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public final class WriterConfig
extends CommonConfig {
    protected static final String DEFAULT_AUTOMATIC_NS_PREFIX = "ans";
    static final int F_NS_REPAIRING = 1;
    static final int F_AUTO_CLOSE_OUTPUT = 16;
    static final int F_NS_AWARE = 32;
    static final int F_AUTO_EMPTY_ELEMS = 64;
    static final int PROP_AUTO_NS_PREFIX = -2;
    static final int DEFAULT_FLAGS = 32;
    private static final HashMap<String, Integer> sProperties = new HashMap();
    private String _propAutoNsPrefix;
    private final EncodingContext _encodingContext;
    private String _encoding;
    static final ThreadLocal<SoftReference<BufferRecycler>> mRecyclerRef;
    BufferRecycler _currRecycler = null;

    private WriterConfig(String string, int n2, int n3, EncodingContext encodingContext, String string2) {
        super(n2, n3);
        this._encoding = string;
        this._encodingContext = encodingContext;
        SoftReference<BufferRecycler> softReference = mRecyclerRef.get();
        if (softReference != null) {
            this._currRecycler = softReference.get();
        }
        this._flags = n2;
        this._flagMods = n3;
        this._propAutoNsPrefix = string2;
    }

    public WriterConfig() {
        this(null, 32, 0, new EncodingContext(), DEFAULT_AUTOMATIC_NS_PREFIX);
    }

    public void setActualEncodingIfNotSet(String string) {
        if (this._encoding == null || this._encoding.length() == 0) {
            this._encoding = string;
        }
    }

    public void doAutoCloseOutput(boolean bl2) {
        this.setFlag(16, bl2);
    }

    public void enableXml11() {
    }

    public WriterConfig createNonShared() {
        return new WriterConfig(this._encoding, this._flags, this._flagMods, this._encodingContext, this._propAutoNsPrefix);
    }

    @Override
    public boolean isXml11() {
        return false;
    }

    @Override
    public String getExternalEncoding() {
        return this.getActualEncoding();
    }

    @Override
    public String getActualEncoding() {
        return this._encoding;
    }

    public String getPreferredEncoding() {
        return this._encoding;
    }

    @Override
    public Object getProperty(String string, boolean bl2) {
        Integer n2 = sProperties.get(string);
        if (n2 == null) {
            if (sProperties.containsKey(string)) {
                return null;
            }
            return super.getProperty(string, bl2);
        }
        int n3 = n2;
        if (n3 >= 0) {
            return this.hasFlag(n3);
        }
        switch (n3) {
            case -2: {
                return this._propAutoNsPrefix;
            }
        }
        return null;
    }

    @Override
    public boolean setProperty(String string, Object object) {
        Integer n2 = sProperties.get(string);
        if (n2 == null) {
            if (sProperties.containsKey(string)) {
                return false;
            }
            return super.setProperty(string, object);
        }
        int n3 = n2;
        if (n3 >= 0) {
            boolean bl2 = (Boolean)object;
            if (n3 == 32 && !bl2) {
                return false;
            }
            this.setFlag(n3, bl2);
            return true;
        }
        switch (n3) {
            case -2: {
                this._propAutoNsPrefix = object.toString();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPropertySupported(String string) {
        return sProperties.containsKey(string) || super.isPropertySupported(string);
    }

    public boolean willRepairNamespaces() {
        return this.hasFlag(1);
    }

    public boolean isNamespaceAware() {
        return this.hasFlag(32);
    }

    public boolean willAutoCloseOutput() {
        return this.hasFlag(16);
    }

    public String getAutomaticNsPrefix() {
        return this._propAutoNsPrefix;
    }

    public void configureForXmlConformance() {
    }

    public void configureForRobustness() {
    }

    public void configureForSpeed() {
    }

    public boolean willCheckStructure() {
        return true;
    }

    public boolean willCheckContent() {
        return true;
    }

    public boolean willCheckNames() {
        return false;
    }

    public boolean willCheckAttributes() {
        return false;
    }

    public boolean willFixContent() {
        return true;
    }

    public boolean willEscapeCR() {
        return true;
    }

    public char[] allocMediumCBuffer(int n2) {
        char[] cArray;
        if (this._currRecycler != null && (cArray = this._currRecycler.getMediumCBuffer(n2)) != null) {
            return cArray;
        }
        return new char[n2];
    }

    public void freeMediumCBuffer(char[] cArray) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnMediumCBuffer(cArray);
    }

    public char[] allocFullCBuffer(int n2) {
        char[] cArray;
        if (this._currRecycler != null && (cArray = this._currRecycler.getFullCBuffer(n2)) != null) {
            return cArray;
        }
        return new char[n2];
    }

    public void freeFullCBuffer(char[] cArray) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnFullCBuffer(cArray);
    }

    public byte[] allocFullBBuffer(int n2) {
        byte[] byArray;
        if (this._currRecycler != null && (byArray = this._currRecycler.getFullBBuffer(n2)) != null) {
            return byArray;
        }
        return new byte[n2];
    }

    public void freeFullBBuffer(byte[] byArray) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnFullBBuffer(byArray);
    }

    private BufferRecycler createRecycler() {
        BufferRecycler bufferRecycler = new BufferRecycler();
        mRecyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        return bufferRecycler;
    }

    public WNameTable getUtf8Symbols(WNameFactory wNameFactory) {
        return this._encodingContext.getUtf8Symbols(wNameFactory);
    }

    public WNameTable getLatin1Symbols(WNameFactory wNameFactory) {
        return this._encodingContext.getLatin1Symbols(wNameFactory);
    }

    public WNameTable getAsciiSymbols(WNameFactory wNameFactory) {
        return this._encodingContext.getAsciiSymbols(wNameFactory);
    }

    public WNameTable getCharSymbols(WNameFactory wNameFactory) {
        return this._encodingContext.getCharSymbols(wNameFactory);
    }

    static {
        sProperties.put("javax.xml.stream.isRepairingNamespaces", 1);
        sProperties.put("javax.xml.stream.isNamespaceAware", 32);
        sProperties.put("javax.xml.stream.reporter", null);
        sProperties.put("com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.autoCloseOutput", 16);
        sProperties.put("com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.automaticEmptyElements", 64);
        sProperties.put("com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.automaticNsPrefix", -2);
        sProperties.put("com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.textEscaper", null);
        sProperties.put("com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.attrValueEscaper", null);
        mRecyclerRef = new ThreadLocal();
    }

    static final class EncodingContext {
        WNameTable mUtf8Table;
        WNameTable mLatin1Table;
        WNameTable mAsciiTable;
        WNameTable mCharTable;

        EncodingContext() {
        }

        public synchronized WNameTable getUtf8Symbols(WNameFactory wNameFactory) {
            if (this.mUtf8Table == null) {
                this.mUtf8Table = new WNameTable(64);
            }
            return this.mUtf8Table.createChild(wNameFactory);
        }

        public synchronized WNameTable getLatin1Symbols(WNameFactory wNameFactory) {
            if (this.mLatin1Table == null) {
                this.mLatin1Table = new WNameTable(64);
            }
            return this.mLatin1Table.createChild(wNameFactory);
        }

        public synchronized WNameTable getAsciiSymbols(WNameFactory wNameFactory) {
            if (this.mAsciiTable == null) {
                this.mAsciiTable = new WNameTable(64);
            }
            return this.mAsciiTable.createChild(wNameFactory);
        }

        public synchronized WNameTable getCharSymbols(WNameFactory wNameFactory) {
            if (this.mCharTable == null) {
                this.mCharTable = new WNameTable(64);
            }
            return this.mCharTable.createChild(wNameFactory);
        }
    }
}

