/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public final class URLUtil {
    private URLUtil() {
    }

    public static URL urlFromSystemId(String string) throws IOException {
        try {
            int n2 = string.indexOf(58, 0);
            if (n2 >= 3 && n2 <= 8) {
                return new URL(string);
            }
            return URLUtil.fileToURL(new File(string));
        }
        catch (MalformedURLException malformedURLException) {
            URLUtil.throwIoException(malformedURLException, string);
            return null;
        }
    }

    public static URL urlFromSystemId(String string, URL uRL) throws IOException {
        if (uRL == null) {
            return URLUtil.urlFromSystemId(string);
        }
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            URLUtil.throwIoException(malformedURLException, string);
            return null;
        }
    }

    public static URL urlFromCurrentDir() throws IOException {
        return URLUtil.fileToURL(new File("a").getAbsoluteFile().getParentFile());
    }

    public static InputStream inputStreamFromURL(URL uRL) throws IOException {
        String string;
        if ("file".equals(uRL.getProtocol()) && ((string = uRL.getHost()) == null || string.length() == 0)) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }

    public static OutputStream outputStreamFromURL(URL uRL) throws IOException {
        String string;
        if ("file".equals(uRL.getProtocol()) && ((string = uRL.getHost()) == null || string.length() == 0)) {
            return new FileOutputStream(uRL.getPath());
        }
        return uRL.openConnection().getOutputStream();
    }

    public static URL fileToURL(File file) throws IOException {
        String string = file.getAbsolutePath();
        char c2 = File.separatorChar;
        if (c2 != '/') {
            string = string.replace(c2, '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = "/" + string;
        }
        return new URL("file", "", string);
    }

    public static String fileToSystemId(File file) throws IOException {
        return URLUtil.fileToURL(file).toExternalForm();
    }

    public static String urlToSystemId(URL uRL) {
        return uRL.toExternalForm();
    }

    private static void throwIoException(MalformedURLException malformedURLException, String string) throws IOException {
        IOException iOException = new IOException("[resolving systemId '" + string + "']: " + malformedURLException.toString());
        iOException.initCause(malformedURLException);
        throw iOException;
    }
}

