/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.json;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.ObjectCodec;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.SerializableString;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.StreamWriteCapability;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.Version;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.base.GeneratorBase;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.CharTypes;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.CharacterEscapes;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.IOContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.DefaultPrettyPrinter;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.JacksonFeatureSet;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.VersionUtil;
import java.io.IOException;

public abstract class JsonGeneratorImpl
extends GeneratorBase {
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    protected static final JacksonFeatureSet<StreamWriteCapability> JSON_WRITE_CAPABILITIES = DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    protected final IOContext _ioContext;
    protected int[] _outputEscapes = sOutputEscapes;
    protected int _maximumNonEscapedChar;
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;
    protected boolean _cfgUnqNames;

    public JsonGeneratorImpl(IOContext iOContext, int n2, ObjectCodec objectCodec) {
        super(n2, objectCodec);
        this._ioContext = iOContext;
        if (JsonGenerator.Feature.ESCAPE_NON_ASCII.enabledIn(n2)) {
            this._maximumNonEscapedChar = 127;
        }
        this._cfgUnqNames = !JsonGenerator.Feature.QUOTE_FIELD_NAMES.enabledIn(n2);
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        super.enable(feature);
        if (feature == JsonGenerator.Feature.QUOTE_FIELD_NAMES) {
            this._cfgUnqNames = false;
        }
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        super.disable(feature);
        if (feature == JsonGenerator.Feature.QUOTE_FIELD_NAMES) {
            this._cfgUnqNames = true;
        }
        return this;
    }

    @Override
    protected void _checkStdFeatureChanges(int n2, int n3) {
        super._checkStdFeatureChanges(n2, n3);
        this._cfgUnqNames = !JsonGenerator.Feature.QUOTE_FIELD_NAMES.enabledIn(n2);
    }

    @Override
    public JsonGenerator setHighestNonEscapedChar(int n2) {
        this._maximumNonEscapedChar = n2 < 0 ? 0 : n2;
        return this;
    }

    @Override
    public int getHighestEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    @Override
    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        this._outputEscapes = characterEscapes == null ? sOutputEscapes : characterEscapes.getEscapeCodesForAscii();
        return this;
    }

    @Override
    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    @Override
    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        this._rootValueSeparator = serializableString;
        return this;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return JSON_WRITE_CAPABILITIES;
    }

    protected void _verifyPrettyValueWrite(String string, int n2) throws IOException {
        switch (n2) {
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                break;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                break;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                break;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    break;
                }
                if (!this._writeContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                break;
            }
            case 5: {
                this._reportCantWriteValueExpectName(string);
                break;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    protected void _reportCantWriteValueExpectName(String string) throws IOException {
        this._reportError(String.format("Can not %s, expecting field name (context: %s)", string, this._writeContext.typeDesc()));
    }
}

