/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.DefaultPrettyPrinter;
import java.io.IOException;

public class DefaultIndenter
extends DefaultPrettyPrinter.NopIndenter {
    private static final long serialVersionUID = 1L;
    public static final String SYS_LF;
    public static final DefaultIndenter SYSTEM_LINEFEED_INSTANCE;
    private static final int INDENT_LEVELS = 16;
    private final char[] indents;
    private final int charsPerLevel;
    private final String eol;

    public DefaultIndenter() {
        this("  ", SYS_LF);
    }

    public DefaultIndenter(String string, String string2) {
        this.charsPerLevel = string.length();
        this.indents = new char[string.length() * 16];
        int n2 = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            string.getChars(0, string.length(), this.indents, n2);
            n2 += string.length();
        }
        this.eol = string2;
    }

    public DefaultIndenter withLinefeed(String string) {
        if (string.equals(this.eol)) {
            return this;
        }
        return new DefaultIndenter(this.getIndent(), string);
    }

    public DefaultIndenter withIndent(String string) {
        if (string.equals(this.getIndent())) {
            return this;
        }
        return new DefaultIndenter(string, this.eol);
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public void writeIndentation(JsonGenerator jsonGenerator, int n2) throws IOException {
        jsonGenerator.writeRaw(this.eol);
        if (n2 > 0) {
            n2 *= this.charsPerLevel;
            while (n2 > this.indents.length) {
                jsonGenerator.writeRaw(this.indents, 0, this.indents.length);
                n2 -= this.indents.length;
            }
            jsonGenerator.writeRaw(this.indents, 0, n2);
        }
    }

    public String getEol() {
        return this.eol;
    }

    public String getIndent() {
        return new String(this.indents, 0, this.charsPerLevel);
    }

    static {
        String string;
        try {
            string = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            string = "\n";
        }
        SYS_LF = string;
        SYSTEM_LINEFEED_INSTANCE = new DefaultIndenter("  ", SYS_LF);
    }
}

