/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.MapperFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.CoercionAction;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.CoercionInputShape;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.MutableCoercionConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.LogicalType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CoercionConfigs
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TARGET_TYPE_COUNT = LogicalType.values().length;
    protected CoercionAction _defaultAction;
    protected final MutableCoercionConfig _defaultCoercions;
    protected MutableCoercionConfig[] _perTypeCoercions;
    protected Map<Class<?>, MutableCoercionConfig> _perClassCoercions;

    public CoercionConfigs() {
        this(CoercionAction.TryConvert, new MutableCoercionConfig(), null, null);
    }

    protected CoercionConfigs(CoercionAction coercionAction, MutableCoercionConfig mutableCoercionConfig, MutableCoercionConfig[] mutableCoercionConfigArray, Map<Class<?>, MutableCoercionConfig> map) {
        this._defaultCoercions = mutableCoercionConfig;
        this._defaultAction = coercionAction;
        this._perTypeCoercions = mutableCoercionConfigArray;
        this._perClassCoercions = map;
    }

    public CoercionConfigs copy() {
        HashMap hashMap;
        MutableCoercionConfig[] mutableCoercionConfigArray;
        if (this._perTypeCoercions == null) {
            mutableCoercionConfigArray = null;
        } else {
            int n2 = this._perTypeCoercions.length;
            mutableCoercionConfigArray = new MutableCoercionConfig[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                mutableCoercionConfigArray[i2] = CoercionConfigs._copy(this._perTypeCoercions[i2]);
            }
        }
        if (this._perClassCoercions == null) {
            hashMap = null;
        } else {
            hashMap = new HashMap();
            for (Map.Entry<Class<?>, MutableCoercionConfig> entry : this._perClassCoercions.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().copy());
            }
        }
        return new CoercionConfigs(this._defaultAction, this._defaultCoercions.copy(), mutableCoercionConfigArray, hashMap);
    }

    private static MutableCoercionConfig _copy(MutableCoercionConfig mutableCoercionConfig) {
        if (mutableCoercionConfig == null) {
            return null;
        }
        return mutableCoercionConfig.copy();
    }

    public MutableCoercionConfig defaultCoercions() {
        return this._defaultCoercions;
    }

    public MutableCoercionConfig findOrCreateCoercion(LogicalType logicalType) {
        MutableCoercionConfig mutableCoercionConfig;
        if (this._perTypeCoercions == null) {
            this._perTypeCoercions = new MutableCoercionConfig[TARGET_TYPE_COUNT];
        }
        if ((mutableCoercionConfig = this._perTypeCoercions[logicalType.ordinal()]) == null) {
            this._perTypeCoercions[logicalType.ordinal()] = mutableCoercionConfig = new MutableCoercionConfig();
        }
        return mutableCoercionConfig;
    }

    public MutableCoercionConfig findOrCreateCoercion(Class<?> clazz) {
        MutableCoercionConfig mutableCoercionConfig;
        if (this._perClassCoercions == null) {
            this._perClassCoercions = new HashMap();
        }
        if ((mutableCoercionConfig = this._perClassCoercions.get(clazz)) == null) {
            mutableCoercionConfig = new MutableCoercionConfig();
            this._perClassCoercions.put(clazz, mutableCoercionConfig);
        }
        return mutableCoercionConfig;
    }

    public CoercionAction findCoercion(DeserializationConfig deserializationConfig, LogicalType logicalType, Class<?> clazz, CoercionInputShape coercionInputShape) {
        boolean bl2;
        CoercionAction coercionAction;
        Object object;
        if (this._perClassCoercions != null && clazz != null && (object = this._perClassCoercions.get(clazz)) != null && (coercionAction = object.findAction(coercionInputShape)) != null) {
            return coercionAction;
        }
        if (this._perTypeCoercions != null && logicalType != null && (object = this._perTypeCoercions[logicalType.ordinal()]) != null && (coercionAction = object.findAction(coercionInputShape)) != null) {
            return coercionAction;
        }
        object = this._defaultCoercions.findAction(coercionInputShape);
        if (object != null) {
            return object;
        }
        switch (coercionInputShape) {
            case EmptyArray: {
                return deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT) ? CoercionAction.AsNull : CoercionAction.Fail;
            }
            case Float: {
                if (logicalType != LogicalType.Integer) break;
                return deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT) ? CoercionAction.TryConvert : CoercionAction.Fail;
            }
            case Integer: {
                if (logicalType != LogicalType.Enum || !deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) break;
                return CoercionAction.Fail;
            }
        }
        boolean bl3 = bl2 = logicalType == LogicalType.Float || logicalType == LogicalType.Integer || logicalType == LogicalType.Boolean || logicalType == LogicalType.DateTime;
        if (bl2 && !deserializationConfig.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            return CoercionAction.Fail;
        }
        if (coercionInputShape == CoercionInputShape.EmptyString) {
            if (bl2 || deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
                return CoercionAction.AsNull;
            }
            if (logicalType == LogicalType.OtherScalar) {
                return CoercionAction.TryConvert;
            }
            return CoercionAction.Fail;
        }
        return this._defaultAction;
    }

    public CoercionAction findCoercionFromBlankString(DeserializationConfig deserializationConfig, LogicalType logicalType, Class<?> clazz, CoercionAction coercionAction) {
        MutableCoercionConfig mutableCoercionConfig;
        Boolean bl2 = null;
        CoercionAction coercionAction2 = null;
        if (this._perClassCoercions != null && clazz != null && (mutableCoercionConfig = this._perClassCoercions.get(clazz)) != null) {
            bl2 = mutableCoercionConfig.getAcceptBlankAsEmpty();
            coercionAction2 = mutableCoercionConfig.findAction(CoercionInputShape.EmptyString);
        }
        if (this._perTypeCoercions != null && logicalType != null && (mutableCoercionConfig = this._perTypeCoercions[logicalType.ordinal()]) != null) {
            if (bl2 == null) {
                bl2 = mutableCoercionConfig.getAcceptBlankAsEmpty();
            }
            if (coercionAction2 == null) {
                coercionAction2 = mutableCoercionConfig.findAction(CoercionInputShape.EmptyString);
            }
        }
        if (bl2 == null) {
            bl2 = this._defaultCoercions.getAcceptBlankAsEmpty();
        }
        if (coercionAction2 == null) {
            coercionAction2 = this._defaultCoercions.findAction(CoercionInputShape.EmptyString);
        }
        if (!Boolean.TRUE.equals(bl2)) {
            return coercionAction;
        }
        if (coercionAction2 != null) {
            return coercionAction2;
        }
        return deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) ? CoercionAction.AsNull : CoercionAction.Fail;
    }
}

