/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.NullValueProvider;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.SettableBeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.ValueInstantiator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.impl.NullsConstantProvider;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.StdDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.TypeFactory;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.AccessPattern;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public abstract class ContainerDeserializerBase<T>
extends StdDeserializer<T>
implements ValueInstantiator.Gettable {
    protected final JavaType _containerType;
    protected final NullValueProvider _nullProvider;
    protected final boolean _skipNullValues;
    protected final Boolean _unwrapSingle;

    protected ContainerDeserializerBase(JavaType javaType, NullValueProvider nullValueProvider, Boolean bl2) {
        super(javaType);
        this._containerType = javaType;
        this._unwrapSingle = bl2;
        this._nullProvider = nullValueProvider;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    protected ContainerDeserializerBase(JavaType javaType) {
        this(javaType, null, null);
    }

    protected ContainerDeserializerBase(ContainerDeserializerBase<?> containerDeserializerBase) {
        this(containerDeserializerBase, containerDeserializerBase._nullProvider, containerDeserializerBase._unwrapSingle);
    }

    protected ContainerDeserializerBase(ContainerDeserializerBase<?> containerDeserializerBase, NullValueProvider nullValueProvider, Boolean bl2) {
        super(containerDeserializerBase._containerType);
        this._containerType = containerDeserializerBase._containerType;
        this._nullProvider = nullValueProvider;
        this._unwrapSingle = bl2;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    @Override
    public JavaType getValueType() {
        return this._containerType;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        JsonDeserializer<Object> jsonDeserializer = this.getContentDeserializer();
        if (jsonDeserializer == null) {
            throw new IllegalArgumentException(String.format("Cannot handle managed/back reference '%s': type: container deserializer of type %s returned null for 'getContentDeserializer()'", string, this.getClass().getName()));
        }
        return jsonDeserializer.findBackReference(string);
    }

    public JavaType getContentType() {
        if (this._containerType == null) {
            return TypeFactory.unknownType();
        }
        return this._containerType.getContentType();
    }

    public abstract JsonDeserializer<Object> getContentDeserializer();

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        ValueInstantiator valueInstantiator = this.getValueInstantiator();
        if (valueInstantiator == null || !valueInstantiator.canCreateUsingDefault()) {
            JavaType javaType = this.getValueType();
            deserializationContext.reportBadDefinition(javaType, String.format("Cannot create empty instance of %s, no default Creator", javaType));
        }
        try {
            return valueInstantiator.createUsingDefault(deserializationContext);
        }
        catch (IOException iOException) {
            return ClassUtil.throwAsMappingException(deserializationContext, iOException);
        }
    }

    @Deprecated
    protected <BOGUS> BOGUS wrapAndThrow(Throwable throwable, Object object, String string) throws IOException {
        return this.wrapAndThrow(null, throwable, object, string);
    }

    protected <BOGUS> BOGUS wrapAndThrow(DeserializationContext deserializationContext, Throwable throwable, Object object, String string) throws IOException {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        if (deserializationContext != null && !deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(throwable);
        }
        if (throwable instanceof IOException && !(throwable instanceof JsonMappingException)) {
            throw (IOException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, ClassUtil.nonNull(string, "N/A"));
    }
}

