/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonProcessingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.MapperFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.ContextualDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.SettableBeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.ValueInstantiator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.impl.PropertyBasedCreator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.impl.PropertyValueBuffer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.StdDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedMethod;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.TypeDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.LogicalType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ClassUtil;
import java.io.IOException;

class FactoryBasedEnumDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _inputType;
    protected final boolean _hasArgs;
    protected final AnnotatedMethod _factory;
    protected final JsonDeserializer<?> _deser;
    protected final ValueInstantiator _valueInstantiator;
    protected final SettableBeanProperty[] _creatorProps;
    private transient PropertyBasedCreator _propCreator;

    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod, JavaType javaType, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) {
        super(clazz);
        this._factory = annotatedMethod;
        this._hasArgs = true;
        this._inputType = javaType.hasRawClass(String.class) ? null : javaType;
        this._deser = null;
        this._valueInstantiator = valueInstantiator;
        this._creatorProps = settableBeanPropertyArray;
    }

    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod) {
        super(clazz);
        this._factory = annotatedMethod;
        this._hasArgs = false;
        this._inputType = null;
        this._deser = null;
        this._valueInstantiator = null;
        this._creatorProps = null;
    }

    protected FactoryBasedEnumDeserializer(FactoryBasedEnumDeserializer factoryBasedEnumDeserializer, JsonDeserializer<?> jsonDeserializer) {
        super(factoryBasedEnumDeserializer._valueClass);
        this._inputType = factoryBasedEnumDeserializer._inputType;
        this._factory = factoryBasedEnumDeserializer._factory;
        this._hasArgs = factoryBasedEnumDeserializer._hasArgs;
        this._valueInstantiator = factoryBasedEnumDeserializer._valueInstantiator;
        this._creatorProps = factoryBasedEnumDeserializer._creatorProps;
        this._deser = jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        if (this._deser == null && this._inputType != null && this._creatorProps == null) {
            return new FactoryBasedEnumDeserializer(this, deserializationContext.findContextualValueDeserializer(this._inputType, beanProperty));
        }
        return this;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.FALSE;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Enum;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (this._deser != null) {
            object = this._deser.deserialize(jsonParser, deserializationContext);
        } else if (this._hasArgs) {
            JsonToken jsonToken = jsonParser.currentToken();
            if (this._creatorProps != null) {
                if (!jsonParser.isExpectedStartObjectToken()) {
                    JavaType javaType = this.getValueType(deserializationContext);
                    deserializationContext.reportInputMismatch(javaType, "Input mismatch reading Enum %s: properties-based `@JsonCreator` (%s) expects JSON Object (JsonToken.START_OBJECT), got JsonToken.%s", new Object[]{ClassUtil.getTypeDescription(javaType), this._factory, jsonParser.currentToken()});
                }
                if (this._propCreator == null) {
                    this._propCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, this._creatorProps, deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
                }
                jsonParser.nextToken();
                return this.deserializeEnumUsingPropertyBased(jsonParser, deserializationContext, this._propCreator);
            }
            object = jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.FIELD_NAME ? jsonParser.getText() : (jsonToken == JsonToken.VALUE_NUMBER_INT ? jsonParser.getNumberValue() : jsonParser.getValueAsString());
        } else {
            jsonParser.skipChildren();
            try {
                return this._factory.call();
            }
            catch (Exception exception) {
                Throwable throwable = ClassUtil.throwRootCauseIfIOE(exception);
                return deserializationContext.handleInstantiationProblem(this._valueClass, null, throwable);
            }
        }
        try {
            return this._factory.callOnWith(this._valueClass, object);
        }
        catch (Exception exception) {
            Throwable throwable = ClassUtil.throwRootCauseIfIOE(exception);
            if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL) && throwable instanceof IllegalArgumentException) {
                return null;
            }
            return deserializationContext.handleInstantiationProblem(this._valueClass, object, throwable);
        }
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        if (this._deser == null) {
            return this.deserialize(jsonParser, deserializationContext);
        }
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected Object deserializeEnumUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyBasedCreator propertyBasedCreator) throws IOException {
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        JsonToken jsonToken = jsonParser.currentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.currentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
            if (!(propertyValueBuffer.readIdProperty(string) && settableBeanProperty == null || settableBeanProperty == null)) {
                propertyValueBuffer.assignParameter(settableBeanProperty, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, settableBeanProperty));
            }
            jsonToken = jsonParser.nextToken();
        }
        return propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
    }

    protected final Object _deserializeWithErrorWrapping(JsonParser jsonParser, DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) throws IOException {
        try {
            return settableBeanProperty.deserialize(jsonParser, deserializationContext);
        }
        catch (Exception exception) {
            return this.wrapAndThrow(exception, this.handledType(), settableBeanProperty.getName(), deserializationContext);
        }
    }

    protected Object wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) throws IOException {
        throw JsonMappingException.wrapWithPath(this.throwOrReturnThrowable(throwable, deserializationContext), object, string);
    }

    private Throwable throwOrReturnThrowable(Throwable throwable, DeserializationContext deserializationContext) throws IOException {
        boolean bl2;
        throwable = ClassUtil.getRootCause(throwable);
        ClassUtil.throwIfError(throwable);
        boolean bl3 = bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl2 || !(throwable instanceof JsonProcessingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl2) {
            ClassUtil.throwIfRTE(throwable);
        }
        return throwable;
    }
}

