/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.AtomicBooleanDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.AtomicIntegerDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.AtomicLongDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.ByteBufferDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.FromStringDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.NullifyingDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.StackTraceElementDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.UUIDDeserializer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (_classNames.contains(string)) {
            FromStringDeserializer<?> fromStringDeserializer = FromStringDeserializer.findDeserializer(clazz);
            if (fromStringDeserializer != null) {
                return fromStringDeserializer;
            }
            if (clazz == UUID.class) {
                return new UUIDDeserializer();
            }
            if (clazz == StackTraceElement.class) {
                return new StackTraceElementDeserializer();
            }
            if (clazz == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (clazz == AtomicInteger.class) {
                return new AtomicIntegerDeserializer();
            }
            if (clazz == AtomicLong.class) {
                return new AtomicLongDeserializer();
            }
            if (clazz == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
            if (clazz == Void.class) {
                return NullifyingDeserializer.instance;
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> clazz) {
        return _classNames.contains(clazz.getName());
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{UUID.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class, StackTraceElement.class, ByteBuffer.class, Void.class}) {
            _classNames.add(clazz.getName());
        }
        for (Class clazz : FromStringDeserializer.types()) {
            _classNames.add(clazz.getName());
        }
    }
}

