/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ext;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanDescription;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.Deserializers;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.FromStringDeserializer;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLDeserializers
extends Deserializers.Base {
    static final DatatypeFactory _dataTypeFactory;
    protected static final int TYPE_DURATION = 1;
    protected static final int TYPE_G_CALENDAR = 2;
    protected static final int TYPE_QNAME = 3;

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz == QName.class) {
            return new Std(clazz, 3);
        }
        if (clazz == XMLGregorianCalendar.class) {
            return new Std(clazz, 2);
        }
        if (clazz == Duration.class) {
            return new Std(clazz, 1);
        }
        return null;
    }

    @Override
    public boolean hasDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return clazz == QName.class || clazz == XMLGregorianCalendar.class || clazz == Duration.class;
    }

    static {
        try {
            _dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        protected final int _kind;

        public Std(Class<?> clazz, int n2) {
            super(clazz);
            this._kind = n2;
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (this._kind == 2 && jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return this._gregorianFromDate(deserializationContext, this._parseDate(jsonParser, deserializationContext));
            }
            return super.deserialize(jsonParser, deserializationContext);
        }

        @Override
        protected Object _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            switch (this._kind) {
                case 1: {
                    return _dataTypeFactory.newDuration(string);
                }
                case 3: {
                    return QName.valueOf(string);
                }
                case 2: {
                    Date date;
                    try {
                        date = this._parseDate(string, deserializationContext);
                    }
                    catch (JsonMappingException jsonMappingException) {
                        return _dataTypeFactory.newXMLGregorianCalendar(string);
                    }
                    return this._gregorianFromDate(deserializationContext, date);
                }
            }
            throw new IllegalStateException();
        }

        protected XMLGregorianCalendar _gregorianFromDate(DeserializationContext deserializationContext, Date date) {
            if (date == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            TimeZone timeZone = deserializationContext.getTimeZone();
            if (timeZone != null) {
                gregorianCalendar.setTimeZone(timeZone);
            }
            return _dataTypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        }
    }
}

