/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.annotation.JsonCreator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.annotation.JsonFormat;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.annotation.JsonInclude;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.AnnotationIntrospector;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanDescription;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.MapperFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.PropertyName;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.annotation.JsonPOJOBuilder;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.HandlerInstantiator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.MapperConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedClass;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedConstructor;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedField;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedMember;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedMethod;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedParameter;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.BeanPropertyDefinition;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.ObjectIdInfo;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.POJOPropertiesCollector;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.TypeBindings;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.Annotations;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ClassUtil;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.Converter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBeanDescription
extends BeanDescription {
    private static final Class<?>[] NO_VIEWS = new Class[0];
    protected final POJOPropertiesCollector _propCollector;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedClass _classInfo;
    protected Class<?>[] _defaultViews;
    protected boolean _defaultViewsResolved;
    protected List<BeanPropertyDefinition> _properties;
    protected ObjectIdInfo _objectIdInfo;

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector, JavaType javaType, AnnotatedClass annotatedClass) {
        super(javaType);
        this._propCollector = pOJOPropertiesCollector;
        this._config = pOJOPropertiesCollector.getConfig();
        this._annotationIntrospector = this._config == null ? null : this._config.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
    }

    protected BasicBeanDescription(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass, List<BeanPropertyDefinition> list) {
        super(javaType);
        this._propCollector = null;
        this._config = mapperConfig;
        this._annotationIntrospector = this._config == null ? null : this._config.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
        this._properties = list;
    }

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector) {
        this(pOJOPropertiesCollector, pOJOPropertiesCollector.getType(), pOJOPropertiesCollector.getClassDef());
        this._objectIdInfo = pOJOPropertiesCollector.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forOtherUse(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass) {
        return new BasicBeanDescription(mapperConfig, javaType, annotatedClass, Collections.emptyList());
    }

    protected List<BeanPropertyDefinition> _properties() {
        if (this._properties == null) {
            this._properties = this._propCollector.getProperties();
        }
        return this._properties;
    }

    public boolean removeProperty(String string) {
        Iterator<BeanPropertyDefinition> iterator = this._properties().iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            if (!beanPropertyDefinition.getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean addProperty(BeanPropertyDefinition beanPropertyDefinition) {
        if (this.hasProperty(beanPropertyDefinition.getFullName())) {
            return false;
        }
        this._properties().add(beanPropertyDefinition);
        return true;
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public BeanPropertyDefinition findProperty(PropertyName propertyName) {
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            if (!beanPropertyDefinition.hasName(propertyName)) continue;
            return beanPropertyDefinition;
        }
        return null;
    }

    @Override
    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    @Override
    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    @Override
    public List<BeanPropertyDefinition> findProperties() {
        return this._properties();
    }

    @Override
    public AnnotatedMember findJsonKeyAccessor() {
        return this._propCollector == null ? null : this._propCollector.getJsonKeyAccessor();
    }

    @Override
    @Deprecated
    public AnnotatedMethod findJsonValueMethod() {
        return this._propCollector == null ? null : this._propCollector.getJsonValueMethod();
    }

    @Override
    public AnnotatedMember findJsonValueAccessor() {
        return this._propCollector == null ? null : this._propCollector.getJsonValueAccessor();
    }

    @Override
    public Set<String> getIgnoredPropertyNames() {
        Set<String> set;
        Set<String> set2 = set = this._propCollector == null ? null : this._propCollector.getIgnoredPropertyNames();
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    @Override
    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    @Override
    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    @Override
    @Deprecated
    public TypeBindings bindingsForBeanType() {
        return this._type.getBindings();
    }

    @Override
    @Deprecated
    public JavaType resolveType(Type type) {
        return this._config.getTypeFactory().resolveMemberType(type, this._type.getBindings());
    }

    @Override
    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    @Override
    public AnnotatedMember findAnySetterAccessor() throws IllegalArgumentException {
        if (this._propCollector != null) {
            AnnotatedMethod annotatedMethod = this._propCollector.getAnySetterMethod();
            if (annotatedMethod != null) {
                Class<?> clazz = annotatedMethod.getRawParameterType(0);
                if (clazz != String.class && clazz != Object.class) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on method '%s()': first argument not of type String or Object, but %s", annotatedMethod.getName(), clazz.getName()));
                }
                return annotatedMethod;
            }
            AnnotatedMember annotatedMember = this._propCollector.getAnySetterField();
            if (annotatedMember != null) {
                Class<?> clazz = annotatedMember.getRawType();
                if (!Map.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on field '%s': type is not instance of java.util.Map", annotatedMember.getName()));
                }
                return annotatedMember;
            }
        }
        return null;
    }

    @Override
    public Map<Object, AnnotatedMember> findInjectables() {
        if (this._propCollector != null) {
            return this._propCollector.getInjectables();
        }
        return Collections.emptyMap();
    }

    @Override
    public List<AnnotatedConstructor> getConstructors() {
        return this._classInfo.getConstructors();
    }

    @Override
    public Object instantiateBean(boolean bl2) {
        AnnotatedConstructor annotatedConstructor = this._classInfo.getDefaultConstructor();
        if (annotatedConstructor == null) {
            return null;
        }
        if (bl2) {
            annotatedConstructor.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        try {
            return ((Constructor)annotatedConstructor.getAnnotated()).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            ClassUtil.throwIfError(throwable);
            ClassUtil.throwIfRTE(throwable);
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + throwable.getClass().getName() + ") " + ClassUtil.exceptionMessage(throwable), throwable);
        }
    }

    @Override
    public AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        return this._classInfo.findMethod(string, classArray);
    }

    @Override
    public JsonFormat.Value findExpectedFormat(JsonFormat.Value value) {
        JsonFormat.Value value2;
        if (this._annotationIntrospector != null && (value2 = this._annotationIntrospector.findFormat(this._classInfo)) != null) {
            value = value == null ? value2 : value.withOverrides(value2);
        }
        if ((value2 = this._config.getDefaultPropertyFormat(this._classInfo.getRawType())) != null) {
            value = value == null ? value2 : value.withOverrides(value2);
        }
        return value;
    }

    @Override
    public Class<?>[] findDefaultViews() {
        if (!this._defaultViewsResolved) {
            Class<?>[] classArray;
            this._defaultViewsResolved = true;
            Class<?>[] classArray2 = classArray = this._annotationIntrospector == null ? null : this._annotationIntrospector.findViews(this._classInfo);
            if (classArray == null && !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                classArray = NO_VIEWS;
            }
            this._defaultViews = classArray;
        }
        return this._defaultViews;
    }

    @Override
    public Converter<Object, Object> findSerializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(this._annotationIntrospector.findSerializationConverter(this._classInfo));
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(JsonInclude.Value value) {
        JsonInclude.Value value2;
        if (this._annotationIntrospector != null && (value2 = this._annotationIntrospector.findPropertyInclusion(this._classInfo)) != null) {
            return value == null ? value2 : value.withOverrides(value2);
        }
        return value;
    }

    @Override
    public AnnotatedMember findAnyGetter() throws IllegalArgumentException {
        if (this._propCollector != null) {
            AnnotatedMember annotatedMember = this._propCollector.getAnyGetterMethod();
            if (annotatedMember != null) {
                Class<?> clazz = annotatedMember.getRawType();
                if (!Map.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on method %s(): return type is not instance of java.util.Map", annotatedMember.getName()));
                }
                return annotatedMember;
            }
            AnnotatedMember annotatedMember2 = this._propCollector.getAnyGetterField();
            if (annotatedMember2 != null) {
                Class<?> clazz = annotatedMember2.getRawType();
                if (!Map.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on field '%s': type is not instance of java.util.Map", annotatedMember2.getName()));
                }
                return annotatedMember2;
            }
        }
        return null;
    }

    @Override
    public List<BeanPropertyDefinition> findBackReferences() {
        ArrayList<BeanPropertyDefinition> arrayList = null;
        HashSet<String> hashSet = null;
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
            if (referenceProperty == null || !referenceProperty.isBackReference()) continue;
            String string = referenceProperty.getName();
            if (arrayList == null) {
                arrayList = new ArrayList<BeanPropertyDefinition>();
                hashSet = new HashSet<String>();
                hashSet.add(string);
            } else if (!hashSet.add(string)) {
                throw new IllegalArgumentException("Multiple back-reference properties with name " + ClassUtil.name(string));
            }
            arrayList.add(beanPropertyDefinition);
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public Map<String, AnnotatedMember> findBackReferenceProperties() {
        List<BeanPropertyDefinition> list = this.findBackReferences();
        if (list == null) {
            return null;
        }
        HashMap<String, AnnotatedMember> hashMap = new HashMap<String, AnnotatedMember>();
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            hashMap.put(beanPropertyDefinition.getName(), beanPropertyDefinition.getMutator());
        }
        return hashMap;
    }

    @Override
    public List<AnnotatedMethod> getFactoryMethods() {
        List<AnnotatedMethod> list = this._classInfo.getFactoryMethods();
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<AnnotatedMethod> arrayList = null;
        for (AnnotatedMethod annotatedMethod : list) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<AnnotatedMethod>();
            }
            arrayList.add(annotatedMethod);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    public Constructor<?> findSingleArgConstructor(Class<?> ... classArray) {
        for (AnnotatedConstructor annotatedConstructor : this._classInfo.getConstructors()) {
            if (annotatedConstructor.getParameterCount() != 1) continue;
            Class<?> clazz = annotatedConstructor.getRawParameterType(0);
            for (Class<?> clazz2 : classArray) {
                if (clazz2 != clazz) continue;
                return annotatedConstructor.getAnnotated();
            }
        }
        return null;
    }

    @Override
    public Method findFactoryMethod(Class<?> ... classArray) {
        for (AnnotatedMethod annotatedMethod : this._classInfo.getFactoryMethods()) {
            if (!this.isFactoryMethod(annotatedMethod) || annotatedMethod.getParameterCount() != 1) continue;
            Class<?> clazz = annotatedMethod.getRawParameterType(0);
            for (Class<?> clazz2 : classArray) {
                if (!clazz.isAssignableFrom(clazz2)) continue;
                return annotatedMethod.getAnnotated();
            }
        }
        return null;
    }

    protected boolean isFactoryMethod(AnnotatedMethod annotatedMethod) {
        Class<?> clazz;
        Class<?> clazz2 = annotatedMethod.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(clazz2)) {
            return false;
        }
        JsonCreator.Mode mode = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedMethod);
        if (mode != null && mode != JsonCreator.Mode.DISABLED) {
            return true;
        }
        String string = annotatedMethod.getName();
        if ("valueOf".equals(string) && annotatedMethod.getParameterCount() == 1) {
            return true;
        }
        return "fromString".equals(string) && annotatedMethod.getParameterCount() == 1 && ((clazz = annotatedMethod.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom(clazz));
    }

    @Deprecated
    protected PropertyName _findCreatorPropertyName(AnnotatedParameter annotatedParameter) {
        String string;
        PropertyName propertyName = this._annotationIntrospector.findNameForDeserialization(annotatedParameter);
        if ((propertyName == null || propertyName.isEmpty()) && (string = this._annotationIntrospector.findImplicitPropertyName(annotatedParameter)) != null && !string.isEmpty()) {
            propertyName = PropertyName.construct(string);
        }
        return propertyName;
    }

    @Override
    public Class<?> findPOJOBuilder() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilder(this._classInfo);
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilderConfig(this._classInfo);
    }

    @Override
    public Converter<Object, Object> findDeserializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(this._annotationIntrospector.findDeserializationConverter(this._classInfo));
    }

    @Override
    public String findClassDescription() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findClassDescription(this._classInfo);
    }

    @Deprecated
    public LinkedHashMap<String, AnnotatedField> _findPropertyFields(Collection<String> collection, boolean bl2) {
        LinkedHashMap<String, AnnotatedField> linkedHashMap = new LinkedHashMap<String, AnnotatedField>();
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            AnnotatedField annotatedField = beanPropertyDefinition.getField();
            if (annotatedField == null) continue;
            String string = beanPropertyDefinition.getName();
            if (collection != null && collection.contains(string)) continue;
            linkedHashMap.put(string, annotatedField);
        }
        return linkedHashMap;
    }

    protected Converter<Object, Object> _createConverter(Object object) {
        Converter converter;
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class clazz = (Class)object;
        if (clazz == Converter.None.class || ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<Converter>");
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        Converter converter2 = converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(this._config, this._classInfo, clazz);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        return converter;
    }
}

