/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.module;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanDescription;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonNode;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.KeyDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.Deserializers;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.TypeDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.ArrayType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.ClassKey;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.CollectionLikeType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.CollectionType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.MapLikeType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.MapType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.ReferenceType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SimpleDeserializers
extends Deserializers.Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected HashMap<ClassKey, JsonDeserializer<?>> _classMappings = null;
    protected boolean _hasEnumDeserializer = false;

    public SimpleDeserializers() {
    }

    public SimpleDeserializers(Map<Class<?>, JsonDeserializer<?>> map) {
        this.addDeserializers(map);
    }

    public <T> void addDeserializer(Class<T> clazz, JsonDeserializer<? extends T> jsonDeserializer) {
        ClassKey classKey = new ClassKey(clazz);
        if (this._classMappings == null) {
            this._classMappings = new HashMap();
        }
        this._classMappings.put(classKey, jsonDeserializer);
        if (clazz == Enum.class) {
            this._hasEnumDeserializer = true;
        }
    }

    public void addDeserializers(Map<Class<?>, JsonDeserializer<?>> map) {
        for (Map.Entry<Class<?>, JsonDeserializer<?>> entry : map.entrySet()) {
            Class<?> clazz = entry.getKey();
            JsonDeserializer<?> jsonDeserializer = entry.getValue();
            this.addDeserializer(clazz, jsonDeserializer);
        }
    }

    @Override
    public JsonDeserializer<?> findArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(arrayType);
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        return this._find(javaType);
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(collectionType);
    }

    @Override
    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(collectionLikeType);
    }

    @Override
    public JsonDeserializer<?> findEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        JsonDeserializer<?> jsonDeserializer = this._classMappings.get(new ClassKey(clazz));
        if (jsonDeserializer == null && this._hasEnumDeserializer && clazz.isEnum()) {
            jsonDeserializer = this._classMappings.get(new ClassKey(Enum.class));
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(clazz));
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(referenceType);
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(mapType);
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(mapLikeType);
    }

    @Override
    public boolean hasDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return this._classMappings != null && this._classMappings.containsKey(new ClassKey(clazz));
    }

    private final JsonDeserializer<?> _find(JavaType javaType) {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(javaType.getRawClass()));
    }
}

