/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.SerializerProvider;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node.JsonNodeType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node.ValueNode;
import java.io.IOException;

public class BooleanNode
extends ValueNode {
    private static final long serialVersionUID = 2L;
    public static final BooleanNode TRUE = new BooleanNode(true);
    public static final BooleanNode FALSE = new BooleanNode(false);
    private final boolean _value;

    protected BooleanNode(boolean bl2) {
        this._value = bl2;
    }

    protected Object readResolve() {
        return this._value ? TRUE : FALSE;
    }

    public static BooleanNode getTrue() {
        return TRUE;
    }

    public static BooleanNode getFalse() {
        return FALSE;
    }

    public static BooleanNode valueOf(boolean bl2) {
        return bl2 ? TRUE : FALSE;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.BOOLEAN;
    }

    @Override
    public JsonToken asToken() {
        return this._value ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
    }

    @Override
    public boolean booleanValue() {
        return this._value;
    }

    @Override
    public String asText() {
        return this._value ? "true" : "false";
    }

    @Override
    public boolean asBoolean() {
        return this._value;
    }

    @Override
    public boolean asBoolean(boolean bl2) {
        return this._value;
    }

    @Override
    public int asInt(int n2) {
        return this._value ? 1 : 0;
    }

    @Override
    public long asLong(long l2) {
        return this._value ? 1L : 0L;
    }

    @Override
    public double asDouble(double d2) {
        return this._value ? 1.0 : 0.0;
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeBoolean(this._value);
    }

    @Override
    public int hashCode() {
        return this._value ? 3 : 1;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BooleanNode)) {
            return false;
        }
        return this._value == ((BooleanNode)object)._value;
    }
}

