/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonNode;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ObjectReader;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ObjectWriter;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.json.JsonMapper;
import java.io.IOException;

final class InternalNodeMapper {
    private static final JsonMapper JSON_MAPPER = new JsonMapper();
    private static final ObjectWriter STD_WRITER = JSON_MAPPER.writer();
    private static final ObjectWriter PRETTY_WRITER = JSON_MAPPER.writer().withDefaultPrettyPrinter();
    private static final ObjectReader NODE_READER = JSON_MAPPER.readerFor(JsonNode.class);

    InternalNodeMapper() {
    }

    public static String nodeToString(JsonNode jsonNode) {
        try {
            return STD_WRITER.writeValueAsString(jsonNode);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String nodeToPrettyString(JsonNode jsonNode) {
        try {
            return PRETTY_WRITER.writeValueAsString(jsonNode);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static byte[] valueToBytes(Object object) throws IOException {
        return JSON_MAPPER.writeValueAsBytes(object);
    }

    public static JsonNode bytesToNode(byte[] byArray) throws IOException {
        return (JsonNode)NODE_READER.readValue(byArray);
    }
}

