/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.AnnotationIntrospector;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanDescription;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.PropertyName;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.MapperConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedClass;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.ClassKey;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    public PropertyName findRootName(Class<?> clazz, MapperConfig<?> mapperConfig) {
        AnnotatedClass annotatedClass;
        ClassKey classKey = new ClassKey(clazz);
        PropertyName propertyName = this._rootNames.get(classKey);
        if (propertyName != null) {
            return propertyName;
        }
        BeanDescription beanDescription = mapperConfig.introspectClassAnnotations(clazz);
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        propertyName = annotationIntrospector.findRootName(annotatedClass = beanDescription.getClassInfo());
        if (propertyName == null || !propertyName.hasSimpleName()) {
            propertyName = PropertyName.construct(clazz.getSimpleName());
        }
        this._rootNames.put(classKey, propertyName);
        return propertyName;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

