/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public enum FileSystem {
    GENERIC(false, false, Integer.MAX_VALUE, Integer.MAX_VALUE, new char[]{'\u0000'}, new String[0]),
    LINUX(true, true, 255, 4096, new char[]{'\u0000', '/'}, new String[0]),
    MAC_OSX(true, true, 255, 1024, new char[]{'\u0000', '/', ':'}, new String[0]),
    WINDOWS(false, true, 255, 32000, new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '*', '/', ':', '<', '>', '?', '\\', '|'}, new String[]{"AUX", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "CON", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "NUL", "PRN"});

    private static final boolean IS_OS_LINUX;
    private static final boolean IS_OS_MAC;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    private static final boolean IS_OS_WINDOWS;
    private final boolean casePreserving;
    private final boolean caseSensitive;
    private final char[] illegalFileNameChars;
    private final int maxFileNameLength;
    private final int maxPathLength;
    private final String[] reservedFileNames;

    public static FileSystem getCurrent() {
        if (IS_OS_LINUX) {
            return LINUX;
        }
        if (IS_OS_MAC) {
            return MAC_OSX;
        }
        if (IS_OS_WINDOWS) {
            return WINDOWS;
        }
        return GENERIC;
    }

    private static boolean getOsMatchesName(String string) {
        return FileSystem.isOsNameMatch(FileSystem.getSystemProperty("os.name"), string);
    }

    private static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a SecurityException reading the system property '" + string + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    private static boolean isOsNameMatch(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.toUpperCase(Locale.ROOT).startsWith(string2.toUpperCase(Locale.ROOT));
    }

    private FileSystem(boolean bl2, boolean bl3, int n3, int n4, char[] cArray, String[] stringArray) {
        this.maxFileNameLength = n3;
        this.maxPathLength = n4;
        this.illegalFileNameChars = Objects.requireNonNull(cArray, "illegalFileNameChars");
        this.reservedFileNames = Objects.requireNonNull(stringArray, "reservedFileNames");
        this.caseSensitive = bl2;
        this.casePreserving = bl3;
    }

    public char[] getIllegalFileNameChars() {
        return (char[])this.illegalFileNameChars.clone();
    }

    public int getMaxFileNameLength() {
        return this.maxFileNameLength;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public String[] getReservedFileNames() {
        return (String[])this.reservedFileNames.clone();
    }

    public boolean isCasePreserving() {
        return this.casePreserving;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private boolean isIllegalFileNameChar(char c2) {
        return Arrays.binarySearch(this.illegalFileNameChars, c2) >= 0;
    }

    public boolean isLegalFileName(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0 || charSequence.length() > this.maxFileNameLength) {
            return false;
        }
        if (this.isReservedFileName(charSequence)) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (!this.isIllegalFileNameChar(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean isReservedFileName(CharSequence charSequence) {
        return Arrays.binarySearch(this.reservedFileNames, charSequence) >= 0;
    }

    public String toLegalFileName(String string, char c2) {
        if (this.isIllegalFileNameChar(c2)) {
            throw new IllegalArgumentException(String.format("The replacement character '%s' cannot be one of the %s illegal characters: %s", c2 == '\u0000' ? "\\0" : Character.valueOf(c2), this.name(), Arrays.toString(this.illegalFileNameChars)));
        }
        String string2 = string.length() > this.maxFileNameLength ? string.substring(0, this.maxFileNameLength) : string;
        boolean bl2 = false;
        char[] cArray = string2.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (!this.isIllegalFileNameChar(cArray[i2])) continue;
            cArray[i2] = c2;
            bl2 = true;
        }
        return bl2 ? String.valueOf(cArray) : string2;
    }

    static {
        IS_OS_LINUX = FileSystem.getOsMatchesName("Linux");
        IS_OS_MAC = FileSystem.getOsMatchesName("Mac");
        IS_OS_WINDOWS = FileSystem.getOsMatchesName(OS_NAME_WINDOWS_PREFIX);
    }
}

