/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.Charsets;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.FileExistsException;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.FilenameUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.IOExceptionList;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.IOUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.LineIterator;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.Counters;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.PathUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter.DirectoryFileFilter;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter.FalseFileFilter;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter.FileFilterUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter.IOFileFilter;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter.SuffixFileFilter;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter.TrueFileFilter;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

public class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    public static final long ONE_MB = 0x100000L;
    public static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    public static final long ONE_GB = 0x40000000L;
    public static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    public static final long ONE_TB = 0x10000000000L;
    public static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    public static final long ONE_PB = 0x4000000000000L;
    public static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    public static final long ONE_EB = 0x1000000000000000L;
    public static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);
    public static final BigInteger ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
    public static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public static String byteCountToDisplaySize(BigInteger bigInteger) {
        String string = bigInteger.divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(bigInteger.divide(ONE_EB_BI)) + " EB" : (bigInteger.divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(bigInteger.divide(ONE_PB_BI)) + " PB" : (bigInteger.divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(bigInteger.divide(ONE_TB_BI)) + " TB" : (bigInteger.divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(bigInteger.divide(ONE_GB_BI)) + " GB" : (bigInteger.divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(bigInteger.divide(ONE_MB_BI)) + " MB" : (bigInteger.divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(bigInteger.divide(ONE_KB_BI)) + " KB" : String.valueOf(bigInteger) + " bytes")))));
        return string;
    }

    public static String byteCountToDisplaySize(long l2) {
        return FileUtils.byteCountToDisplaySize(BigInteger.valueOf(l2));
    }

    private static void checkDirectory(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
    }

    private static void checkEqualSizes(File file, File file2, long l2, long l3) throws IOException {
        if (l2 != l3) {
            throw new IOException("Failed to copy full contents from '" + file + "' to '" + file2 + "' Expected length: " + l2 + " Actual: " + l3);
        }
    }

    private static void checkFileRequirements(File file, File file2) throws FileNotFoundException {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "target");
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
    }

    public static Checksum checksum(File file, Checksum checksum) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try (CheckedInputStream checkedInputStream = new CheckedInputStream(new FileInputStream(file), checksum);){
            IOUtils.consume(checkedInputStream);
        }
        return checksum;
    }

    public static long checksumCRC32(File file) throws IOException {
        return FileUtils.checksum(file, new CRC32()).getValue();
    }

    public static void cleanDirectory(File file) throws IOException {
        File[] fileArray = FileUtils.verifiedListFiles(file);
        ArrayList<IOException> arrayList = new ArrayList<IOException>();
        for (File file2 : fileArray) {
            try {
                FileUtils.forceDelete(file2);
            }
            catch (IOException iOException) {
                arrayList.add(iOException);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new IOExceptionList(arrayList);
        }
    }

    private static void cleanDirectoryOnExit(File file) throws IOException {
        File[] fileArray = FileUtils.verifiedListFiles(file);
        ArrayList<IOException> arrayList = new ArrayList<IOException>();
        for (File file2 : fileArray) {
            try {
                FileUtils.forceDeleteOnExit(file2);
            }
            catch (IOException iOException) {
                arrayList.add(iOException);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new IOExceptionList(arrayList);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEquals(File var0, File var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEqualsIgnoreEOL(File var0, File var1_1, String var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File[] convertFileCollectionToFileArray(Collection<File> collection) {
        return collection.toArray(new File[collection.size()]);
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl2) throws IOException {
        FileUtils.copyDirectory(file, file2, null, bl2);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) throws IOException {
        FileUtils.copyDirectory(file, file2, fileFilter, true);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl2) throws IOException {
        FileUtils.copyDirectory(file, file2, fileFilter, bl2, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl2, CopyOption ... copyOptionArray) throws IOException {
        FileUtils.checkFileRequirements(file, file2);
        if (!file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is not a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        ArrayList<String> arrayList = null;
        if (file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
            File[] fileArray;
            File[] fileArray2 = fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
            if (fileArray != null && fileArray.length > 0) {
                arrayList = new ArrayList<String>(fileArray.length);
                for (File file3 : fileArray) {
                    File file4 = new File(file2, file3.getName());
                    arrayList.add(file4.getCanonicalPath());
                }
            }
        }
        FileUtils.doCopyDirectory(file, file2, fileFilter, bl2, arrayList, copyOptionArray);
    }

    public static void copyDirectoryToDirectory(File file, File file2) throws IOException {
        Objects.requireNonNull(file, "sourceDir");
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Source '" + file + "' is not a directory");
        }
        Objects.requireNonNull(file2, "destinationDir");
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.copyDirectory(file, new File(file2, file.getName()), true);
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtils.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl2) throws IOException {
        FileUtils.copyFile(file, file2, bl2, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File file, File file2, boolean bl2, CopyOption ... copyOptionArray) throws IOException {
        FileUtils.checkFileRequirements(file, file2);
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        File file3 = file2.getParentFile();
        if (file3 != null && !file3.mkdirs() && !file3.isDirectory()) {
            throw new IOException("Destination '" + file3 + "' directory cannot be created");
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' exists but is read-only");
        }
        FileUtils.doCopyFile(file, file2, bl2, copyOptionArray);
    }

    public static long copyFile(File file, OutputStream outputStream) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            long l2 = IOUtils.copyLarge(fileInputStream, outputStream);
            return l2;
        }
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl2) throws IOException {
        Objects.requireNonNull(file2, "destinationDir");
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + file2 + "' is not a directory");
        }
        File file3 = new File(file2, file.getName());
        FileUtils.copyFile(file, file3, bl2);
    }

    public static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (InputStream inputStream2 = inputStream;){
            FileUtils.copyToFile(inputStream2, file);
        }
    }

    public static void copyToDirectory(File file, File file2) throws IOException {
        Objects.requireNonNull(file, "sourceFile");
        if (file.isFile()) {
            FileUtils.copyFileToDirectory(file, file2);
        } else if (file.isDirectory()) {
            FileUtils.copyDirectoryToDirectory(file, file2);
        } else {
            throw new IOException("The source " + file + " does not exist");
        }
    }

    public static void copyToDirectory(Iterable<File> iterable, File file) throws IOException {
        Objects.requireNonNull(iterable, "sourceIterable");
        for (File file2 : iterable) {
            FileUtils.copyFileToDirectory(file2, file);
        }
    }

    public static void copyToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);){
            IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
        }
    }

    public static void copyURLToFile(URL uRL, File file) throws IOException {
        try (InputStream inputStream = uRL.openStream();){
            FileUtils.copyInputStreamToFile(inputStream, file);
        }
    }

    public static void copyURLToFile(URL uRL, File file, int n2, int n3) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(n2);
        uRLConnection.setReadTimeout(n3);
        try (InputStream inputStream = uRLConnection.getInputStream();){
            FileUtils.copyInputStreamToFile(inputStream, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decodeUrl(String string) {
        String string2 = string;
        if (string != null && string.indexOf(37) >= 0) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            int n3 = 0;
            while (n3 < n2) {
                if (string.charAt(n3) == '%') {
                    try {
                        do {
                            byte by2 = (byte)Integer.parseInt(string.substring(n3 + 1, n3 + 3), 16);
                            byteBuffer.put(by2);
                        } while ((n3 += 3) < n2 && string.charAt(n3) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (byteBuffer.position() <= 0) continue;
                        byteBuffer.flip();
                        stringBuilder.append(StandardCharsets.UTF_8.decode(byteBuffer).toString());
                        byteBuffer.clear();
                        continue;
                    }
                }
                stringBuilder.append(string.charAt(n3++));
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static void deleteDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectory(file);
        }
        if (!file.delete()) {
            String string = "Unable to delete directory " + file + ".";
            throw new IOException(string);
        }
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        file.deleteOnExit();
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectoryOnExit(file);
        }
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean directoryContains(File file, File file2) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + file);
        }
        if (file2 == null) {
            return false;
        }
        if (!file.exists() || !file2.exists()) {
            return false;
        }
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        return FilenameUtils.directoryContains(string, string2);
    }

    private static void doCopyDirectory(File file, File file2, FileFilter fileFilter, boolean bl2, List<String> list, CopyOption ... copyOptionArray) throws IOException {
        File[] fileArray;
        File[] fileArray2 = fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException("Destination '" + file2 + "' exists but is not a directory");
            }
        } else if (!file2.mkdirs() && !file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' directory cannot be created");
        }
        if (!file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' cannot be written to");
        }
        for (File file3 : fileArray) {
            File file4 = new File(file2, file3.getName());
            if (list != null && list.contains(file3.getCanonicalPath())) continue;
            if (file3.isDirectory()) {
                FileUtils.doCopyDirectory(file3, file4, fileFilter, bl2, list, copyOptionArray);
                continue;
            }
            FileUtils.doCopyFile(file3, file4, bl2, copyOptionArray);
        }
        if (bl2) {
            FileUtils.setLastModified(file, file2);
        }
    }

    private static void doCopyFile(File file, File file2, boolean bl2, CopyOption ... copyOptionArray) throws IOException {
        if (file2.exists() && file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' exists but is a directory");
        }
        Path path = file.toPath();
        Path path2 = file2.toPath();
        Files.copy(path, path2, copyOptionArray);
        FileUtils.checkEqualSizes(file, file2, Files.size(path), Files.size(path2));
        FileUtils.checkEqualSizes(file, file2, file.length(), file2.length());
        if (bl2) {
            FileUtils.setLastModified(file, file2);
        }
    }

    public static void forceDelete(File file) throws IOException {
        Counters.PathCounters pathCounters;
        try {
            pathCounters = PathUtils.delete(file.toPath());
        }
        catch (IOException iOException) {
            throw new IOException("Unable to delete file: " + file, iOException);
        }
        if (pathCounters.getFileCounter().get() < 1L && pathCounters.getDirectoryCounter().get() < 1L) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    public static void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                String string = "File " + file + " exists and is not a directory. Unable to create directory.";
                throw new IOException(string);
            }
        } else if (!file.mkdirs() && !file.isDirectory()) {
            String string = "Unable to create directory " + file;
            throw new IOException(string);
        }
    }

    public static void forceMkdirParent(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return;
        }
        FileUtils.forceMkdir(file2);
    }

    public static File getFile(File file, String ... stringArray) {
        Objects.requireNonNull(file, "directory");
        Objects.requireNonNull(stringArray, "names");
        File file2 = file;
        for (String string : stringArray) {
            file2 = new File(file2, string);
        }
        return file2;
    }

    public static File getFile(String ... stringArray) {
        Objects.requireNonNull(stringArray, "names");
        File file = null;
        for (String string : stringArray) {
            file = file == null ? new File(string) : new File(file, string);
        }
        return file;
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getUserDirectory() {
        return new File(FileUtils.getUserDirectoryPath());
    }

    public static String getUserDirectoryPath() {
        return System.getProperty("user.home");
    }

    private static void innerListFiles(Collection<File> collection, File file, IOFileFilter iOFileFilter, boolean bl2) {
        File[] fileArray = file.listFiles(iOFileFilter);
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    if (bl2) {
                        collection.add(file2);
                    }
                    FileUtils.innerListFiles(collection, file2, iOFileFilter, bl2);
                    continue;
                }
                collection.add(file2);
            }
        }
    }

    private static Collection<File> innerListFilesOrDirectories(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, boolean bl2) {
        FileUtils.validateListFilesParameters(file, iOFileFilter);
        IOFileFilter iOFileFilter3 = FileUtils.setUpEffectiveFileFilter(iOFileFilter);
        IOFileFilter iOFileFilter4 = FileUtils.setUpEffectiveDirFilter(iOFileFilter2);
        LinkedList<File> linkedList = new LinkedList<File>();
        if (bl2) {
            linkedList.add(file);
        }
        FileUtils.innerListFiles(linkedList, file, FileFilterUtils.or(iOFileFilter3, iOFileFilter4), bl2);
        return linkedList;
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate) {
        return FileUtils.isFileNewer(file, chronoLocalDate, LocalTime.now());
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(localTime, "localTime");
        return FileUtils.isFileNewer(file, chronoLocalDate.atTime(localTime));
    }

    public static boolean isFileNewer(File file, ChronoLocalDateTime<?> chronoLocalDateTime) {
        return FileUtils.isFileNewer(file, chronoLocalDateTime, ZoneId.systemDefault());
    }

    public static boolean isFileNewer(File file, ChronoLocalDateTime<?> chronoLocalDateTime, ZoneId zoneId) {
        Objects.requireNonNull(chronoLocalDateTime, "chronoLocalDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return FileUtils.isFileNewer(file, chronoLocalDateTime.atZone(zoneId));
    }

    public static boolean isFileNewer(File file, ChronoZonedDateTime<?> chronoZonedDateTime) {
        Objects.requireNonNull(chronoZonedDateTime, "chronoZonedDateTime");
        return FileUtils.isFileNewer(file, chronoZonedDateTime.toInstant());
    }

    public static boolean isFileNewer(File file, Date date) {
        Objects.requireNonNull(date, "date");
        return FileUtils.isFileNewer(file, date.getTime());
    }

    public static boolean isFileNewer(File file, File file2) {
        Objects.requireNonNull(file2, "reference");
        if (!file2.exists()) {
            throw new IllegalArgumentException("The reference file '" + file2 + "' doesn't exist");
        }
        return FileUtils.isFileNewer(file, file2.lastModified());
    }

    public static boolean isFileNewer(File file, Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return FileUtils.isFileNewer(file, instant.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static boolean isFileNewer(File file, long l2) {
        Objects.requireNonNull(file, "file");
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() > l2;
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate) {
        return FileUtils.isFileOlder(file, chronoLocalDate, LocalTime.now());
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(localTime, "localTime");
        return FileUtils.isFileOlder(file, chronoLocalDate.atTime(localTime));
    }

    public static boolean isFileOlder(File file, ChronoLocalDateTime<?> chronoLocalDateTime) {
        return FileUtils.isFileOlder(file, chronoLocalDateTime, ZoneId.systemDefault());
    }

    public static boolean isFileOlder(File file, ChronoLocalDateTime<?> chronoLocalDateTime, ZoneId zoneId) {
        Objects.requireNonNull(chronoLocalDateTime, "chronoLocalDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return FileUtils.isFileOlder(file, chronoLocalDateTime.atZone(zoneId));
    }

    public static boolean isFileOlder(File file, ChronoZonedDateTime<?> chronoZonedDateTime) {
        Objects.requireNonNull(chronoZonedDateTime, "chronoZonedDateTime");
        return FileUtils.isFileOlder(file, chronoZonedDateTime.toInstant());
    }

    public static boolean isFileOlder(File file, Date date) {
        Objects.requireNonNull(date, "date");
        return FileUtils.isFileOlder(file, date.getTime());
    }

    public static boolean isFileOlder(File file, File file2) {
        if (!Objects.requireNonNull(file2, "reference").exists()) {
            throw new IllegalArgumentException("The reference file '" + file2 + "' doesn't exist");
        }
        return FileUtils.isFileOlder(file, file2.lastModified());
    }

    public static boolean isFileOlder(File file, Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return FileUtils.isFileOlder(file, instant.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static boolean isFileOlder(File file, long l2) {
        Objects.requireNonNull(file, "file");
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() < l2;
    }

    public static boolean isSymlink(File file) {
        Objects.requireNonNull(file, "file");
        return Files.isSymbolicLink(file.toPath());
    }

    public static Iterator<File> iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static Iterator<File> iterateFiles(File file, String[] stringArray, boolean bl2) {
        return FileUtils.listFiles(file, stringArray, bl2).iterator();
    }

    public static Iterator<File> iterateFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFilesAndDirs(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static LineIterator lineIterator(File file) throws IOException {
        return FileUtils.lineIterator(file, null);
    }

    public static LineIterator lineIterator(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            return IOUtils.lineIterator((InputStream)fileInputStream, string);
        }
        catch (IOException | RuntimeException exception) {
            IOUtils.closeQuietly((Closeable)fileInputStream, iOException -> exception.addSuppressed((Throwable)iOException));
            throw exception;
        }
    }

    public static Collection<File> listFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.innerListFilesOrDirectories(file, iOFileFilter, iOFileFilter2, false);
    }

    public static Collection<File> listFiles(File file, String[] stringArray, boolean bl2) {
        IOFileFilter iOFileFilter;
        if (stringArray == null) {
            iOFileFilter = TrueFileFilter.INSTANCE;
        } else {
            String[] stringArray2 = FileUtils.toSuffixes(stringArray);
            iOFileFilter = new SuffixFileFilter(stringArray2);
        }
        return FileUtils.listFiles(file, iOFileFilter, bl2 ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE);
    }

    public static Collection<File> listFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.innerListFilesOrDirectories(file, iOFileFilter, iOFileFilter2, true);
    }

    public static void moveDirectory(File file, File file2) throws IOException {
        FileUtils.validateMoveParameters(file, file2);
        if (!file.isDirectory()) {
            throw new IOException("Source '" + file + "' is not a directory");
        }
        if (file2.exists()) {
            throw new FileExistsException("Destination '" + file2 + "' already exists");
        }
        boolean bl2 = file.renameTo(file2);
        if (!bl2) {
            if (file2.getCanonicalPath().startsWith(file.getCanonicalPath() + File.separator)) {
                throw new IOException("Cannot move directory: " + file + " to a subdirectory of itself: " + file2);
            }
            FileUtils.copyDirectory(file, file2);
            FileUtils.deleteDirectory(file);
            if (file.exists()) {
                throw new IOException("Failed to delete original directory '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveDirectoryToDirectory(File file, File file2, boolean bl2) throws IOException {
        FileUtils.validateMoveParameters(file, file2);
        if (!file2.exists() && bl2 && !file2.mkdirs()) {
            throw new IOException("Could not create destination directories '" + file2 + "'");
        }
        if (!file2.exists()) {
            throw new FileNotFoundException("Destination directory '" + file2 + "' does not exist [createDestDir=" + bl2 + "]");
        }
        if (!file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.moveDirectory(file, new File(file2, file.getName()));
    }

    public static void moveFile(File file, File file2) throws IOException {
        FileUtils.validateMoveParameters(file, file2);
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' is a directory");
        }
        if (file2.exists()) {
            throw new FileExistsException("Destination '" + file2 + "' already exists");
        }
        if (file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' is a directory");
        }
        boolean bl2 = file.renameTo(file2);
        if (!bl2) {
            FileUtils.copyFile(file, file2);
            if (!file.delete()) {
                FileUtils.deleteQuietly(file2);
                throw new IOException("Failed to delete original file '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveFileToDirectory(File file, File file2, boolean bl2) throws IOException {
        FileUtils.validateMoveParameters(file, file2);
        if (!file2.exists() && bl2 && !file2.mkdirs()) {
            throw new IOException("Could not create destination directories '" + file2 + "'");
        }
        if (!file2.exists()) {
            throw new FileNotFoundException("Destination directory '" + file2 + "' does not exist [createDestDir=" + bl2 + "]");
        }
        if (!file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.moveFile(file, new File(file2, file.getName()));
    }

    public static void moveToDirectory(File file, File file2, boolean bl2) throws IOException {
        FileUtils.validateMoveParameters(file, file2);
        if (file.isDirectory()) {
            FileUtils.moveDirectoryToDirectory(file, file2, bl2);
        } else {
            FileUtils.moveFileToDirectory(file, file2, bl2);
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean bl2) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.mkdirs() && !file2.isDirectory()) {
                throw new IOException("Directory '" + file2 + "' could not be created");
            }
        }
        return new FileOutputStream(file, bl2);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        try (FileInputStream fileInputStream = FileUtils.openInputStream(file);){
            long l2 = file.length();
            byte[] byArray = l2 > 0L ? IOUtils.toByteArray((InputStream)fileInputStream, l2) : IOUtils.toByteArray(fileInputStream);
            return byArray;
        }
    }

    @Deprecated
    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset charset) throws IOException {
        try (FileInputStream fileInputStream = FileUtils.openInputStream(file);){
            String string = IOUtils.toString((InputStream)fileInputStream, Charsets.toCharset(charset));
            return string;
        }
    }

    public static String readFileToString(File file, String string) throws IOException {
        return FileUtils.readFileToString(file, Charsets.toCharset(string));
    }

    @Deprecated
    public static List<String> readLines(File file) throws IOException {
        return FileUtils.readLines(file, Charset.defaultCharset());
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        try (FileInputStream fileInputStream = FileUtils.openInputStream(file);){
            List<String> list = IOUtils.readLines((InputStream)fileInputStream, Charsets.toCharset(charset));
            return list;
        }
    }

    public static List<String> readLines(File file, String string) throws IOException {
        return FileUtils.readLines(file, Charsets.toCharset(string));
    }

    private static void setLastModified(File file, File file2) throws IOException {
        if (!file2.setLastModified(file.lastModified())) {
            throw new IOException("Failed setLastModified on " + file);
        }
    }

    private static IOFileFilter setUpEffectiveDirFilter(IOFileFilter iOFileFilter) {
        return iOFileFilter == null ? FalseFileFilter.INSTANCE : FileFilterUtils.and(iOFileFilter, DirectoryFileFilter.INSTANCE);
    }

    private static IOFileFilter setUpEffectiveFileFilter(IOFileFilter iOFileFilter) {
        return FileFilterUtils.and(iOFileFilter, FileFilterUtils.notFileFilter(DirectoryFileFilter.INSTANCE));
    }

    public static long sizeOf(File file) {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (file.isDirectory()) {
            return FileUtils.sizeOfDirectory0(file);
        }
        return file.length();
    }

    private static long sizeOf0(File file) {
        if (file.isDirectory()) {
            return FileUtils.sizeOfDirectory0(file);
        }
        return file.length();
    }

    public static BigInteger sizeOfAsBigInteger(File file) {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (file.isDirectory()) {
            return FileUtils.sizeOfDirectoryBig0(file);
        }
        return BigInteger.valueOf(file.length());
    }

    private static BigInteger sizeOfBig0(File file) {
        if (file.isDirectory()) {
            return FileUtils.sizeOfDirectoryBig0(file);
        }
        return BigInteger.valueOf(file.length());
    }

    public static long sizeOfDirectory(File file) {
        FileUtils.checkDirectory(file);
        return FileUtils.sizeOfDirectory0(file);
    }

    private static long sizeOfDirectory0(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        long l2 = 0L;
        for (File file2 : fileArray) {
            if (!FileUtils.isSymlink(file2) && (l2 += FileUtils.sizeOf0(file2)) < 0L) break;
        }
        return l2;
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(File file) {
        FileUtils.checkDirectory(file);
        return FileUtils.sizeOfDirectoryBig0(file);
    }

    private static BigInteger sizeOfDirectoryBig0(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return BigInteger.ZERO;
        }
        BigInteger bigInteger = BigInteger.ZERO;
        for (File file2 : fileArray) {
            if (FileUtils.isSymlink(file2)) continue;
            bigInteger = bigInteger.add(FileUtils.sizeOfBig0(file2));
        }
        return bigInteger;
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !"file".equalsIgnoreCase(uRL.getProtocol())) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        string = FileUtils.decodeUrl(string);
        return new File(string);
    }

    public static File[] toFiles(URL ... uRLArray) {
        if (uRLArray == null || uRLArray.length == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[uRLArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            if (uRL == null) continue;
            if (!uRL.getProtocol().equals("file")) {
                throw new IllegalArgumentException("URL could not be converted to a File: " + uRL);
            }
            fileArray[i2] = FileUtils.toFile(uRL);
        }
        return fileArray;
    }

    private static String[] toSuffixes(String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = "." + stringArray[i2];
        }
        return stringArray2;
    }

    public static void touch(File file) throws IOException {
        boolean bl2;
        if (!file.exists()) {
            FileUtils.openOutputStream(file).close();
        }
        if (!(bl2 = file.setLastModified(System.currentTimeMillis()))) {
            throw new IOException("Unable to set the last modification time for " + file);
        }
    }

    public static URL[] toURLs(File ... fileArray) throws IOException {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = fileArray[i2].toURI().toURL();
        }
        return uRLArray;
    }

    private static void validateListFilesParameters(File file, IOFileFilter iOFileFilter) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter 'directory' is not a directory: " + file);
        }
        Objects.requireNonNull(iOFileFilter, "fileFilter");
    }

    private static void validateMoveParameters(File file, File file2) throws FileNotFoundException {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "destination");
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
    }

    private static File[] verifiedListFiles(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFor(File file, int n2) {
        long l2 = System.currentTimeMillis() + (long)n2 * 1000L;
        boolean bl2 = false;
        try {
            while (!file.exists()) {
                long l3 = l2 - System.currentTimeMillis();
                if (l3 < 0L) {
                    boolean bl3 = false;
                    return bl3;
                }
                try {
                    Thread.sleep(Math.min(100L, l3));
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence) throws IOException {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence, boolean bl2) throws IOException {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), bl2);
    }

    public static void write(File file, CharSequence charSequence, Charset charset) throws IOException {
        FileUtils.write(file, charSequence, charset, false);
    }

    public static void write(File file, CharSequence charSequence, Charset charset, boolean bl2) throws IOException {
        String string = charSequence == null ? null : charSequence.toString();
        FileUtils.writeStringToFile(file, string, charset, bl2);
    }

    public static void write(File file, CharSequence charSequence, String string) throws IOException {
        FileUtils.write(file, charSequence, string, false);
    }

    public static void write(File file, CharSequence charSequence, String string, boolean bl2) throws IOException {
        FileUtils.write(file, charSequence, Charsets.toCharset(string), bl2);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) throws IOException {
        FileUtils.writeByteArrayToFile(file, byArray, false);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, boolean bl2) throws IOException {
        FileUtils.writeByteArrayToFile(file, byArray, 0, byArray.length, bl2);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, int n2, int n3) throws IOException {
        FileUtils.writeByteArrayToFile(file, byArray, n2, n3, false);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, int n2, int n3, boolean bl2) throws IOException {
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream(file, bl2);){
            ((OutputStream)fileOutputStream).write(byArray, n2, n3);
        }
    }

    public static void writeLines(File file, Collection<?> collection) throws IOException {
        FileUtils.writeLines(file, null, collection, null, false);
    }

    public static void writeLines(File file, Collection<?> collection, boolean bl2) throws IOException {
        FileUtils.writeLines(file, null, collection, null, bl2);
    }

    public static void writeLines(File file, Collection<?> collection, String string) throws IOException {
        FileUtils.writeLines(file, null, collection, string, false);
    }

    public static void writeLines(File file, Collection<?> collection, String string, boolean bl2) throws IOException {
        FileUtils.writeLines(file, null, collection, string, bl2);
    }

    public static void writeLines(File file, String string, Collection<?> collection) throws IOException {
        FileUtils.writeLines(file, string, collection, null, false);
    }

    public static void writeLines(File file, String string, Collection<?> collection, boolean bl2) throws IOException {
        FileUtils.writeLines(file, string, collection, null, bl2);
    }

    public static void writeLines(File file, String string, Collection<?> collection, String string2) throws IOException {
        FileUtils.writeLines(file, string, collection, string2, false);
    }

    public static void writeLines(File file, String string, Collection<?> collection, String string2, boolean bl2) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(FileUtils.openOutputStream(file, bl2));){
            IOUtils.writeLines(collection, string2, (OutputStream)bufferedOutputStream, string);
        }
    }

    @Deprecated
    public static void writeStringToFile(File file, String string) throws IOException {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void writeStringToFile(File file, String string, boolean bl2) throws IOException {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), bl2);
    }

    public static void writeStringToFile(File file, String string, Charset charset) throws IOException {
        FileUtils.writeStringToFile(file, string, charset, false);
    }

    public static void writeStringToFile(File file, String string, Charset charset, boolean bl2) throws IOException {
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream(file, bl2);){
            IOUtils.write(string, (OutputStream)fileOutputStream, charset);
        }
    }

    public static void writeStringToFile(File file, String string, String string2) throws IOException {
        FileUtils.writeStringToFile(file, string, string2, false);
    }

    public static void writeStringToFile(File file, String string, String string2, boolean bl2) throws IOException {
        FileUtils.writeStringToFile(file, string, Charsets.toCharset(string2), bl2);
    }
}

