/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.Counters;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.CountingPathVisitor;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.PathUtils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class AccumulatorPathVisitor
extends CountingPathVisitor {
    private final List<Path> dirList = new ArrayList<Path>();
    private final List<Path> fileList = new ArrayList<Path>();

    public static AccumulatorPathVisitor withBigIntegerCounters() {
        return new AccumulatorPathVisitor(Counters.bigIntegerPathCounters());
    }

    public static AccumulatorPathVisitor withLongCounters() {
        return new AccumulatorPathVisitor(Counters.longPathCounters());
    }

    public AccumulatorPathVisitor(Counters.PathCounters pathCounters) {
        super(pathCounters);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof AccumulatorPathVisitor)) {
            return false;
        }
        AccumulatorPathVisitor accumulatorPathVisitor = (AccumulatorPathVisitor)object;
        return Objects.equals(this.dirList, accumulatorPathVisitor.dirList) && Objects.equals(this.fileList, accumulatorPathVisitor.fileList);
    }

    public List<Path> getDirList() {
        return this.dirList;
    }

    public List<Path> getFileList() {
        return this.fileList;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Objects.hash(this.dirList, this.fileList);
        return n3;
    }

    public List<Path> relativizeDirectories(Path path, boolean bl2, Comparator<? super Path> comparator) {
        return PathUtils.relativize(this.getDirList(), path, bl2, comparator);
    }

    public List<Path> relativizeFiles(Path path, boolean bl2, Comparator<? super Path> comparator) {
        return PathUtils.relativize(this.getFileList(), path, bl2, comparator);
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        (Files.isDirectory(path, new LinkOption[0]) ? this.dirList : this.fileList).add(path.normalize());
        return super.visitFile(path, basicFileAttributes);
    }
}

