/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.AccumulatorPathVisitor;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.CleaningPathVisitor;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.CopyDirectoryVisitor;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.Counters;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.CountingPathVisitor;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.DeleteOption;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.DeletingPathVisitor;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.StandardDeleteOption;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class PathUtils {
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];

    private static AccumulatorPathVisitor accumulate(Path path, int n2, FileVisitOption[] fileVisitOptionArray) throws IOException {
        return PathUtils.visitFileTree(AccumulatorPathVisitor.withLongCounters(), path, PathUtils.toFileVisitOptionSet(fileVisitOptionArray), n2);
    }

    public static Counters.PathCounters cleanDirectory(Path path) throws IOException {
        return PathUtils.cleanDirectory(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters cleanDirectory(Path path, DeleteOption ... deleteOptionArray) throws IOException {
        return PathUtils.visitFileTree(new CleaningPathVisitor(Counters.longPathCounters(), deleteOptionArray, new String[0]), path).getPathCounters();
    }

    public static Counters.PathCounters copyDirectory(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        return PathUtils.visitFileTree(new CopyDirectoryVisitor(Counters.longPathCounters(), path, path2, copyOptionArray), path).getPathCounters();
    }

    public static Path copyFile(URL uRL, Path path, CopyOption ... copyOptionArray) throws IOException {
        try (InputStream inputStream = uRL.openStream();){
            Files.copy(inputStream, path, copyOptionArray);
            Path path2 = path;
            return path2;
        }
    }

    public static Path copyFileToDirectory(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        return Files.copy(path, path2.resolve(path.getFileName()), copyOptionArray);
    }

    public static Path copyFileToDirectory(URL uRL, Path path, CopyOption ... copyOptionArray) throws IOException {
        try (InputStream inputStream = uRL.openStream();){
            Files.copy(inputStream, path.resolve(uRL.getFile()), copyOptionArray);
            Path path2 = path;
            return path2;
        }
    }

    public static Counters.PathCounters countDirectory(Path path) throws IOException {
        return PathUtils.visitFileTree(new CountingPathVisitor(Counters.longPathCounters()), path).getPathCounters();
    }

    public static Counters.PathCounters delete(Path path) throws IOException {
        return PathUtils.delete(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters delete(Path path, DeleteOption ... deleteOptionArray) throws IOException {
        return Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) ? PathUtils.deleteDirectory(path, deleteOptionArray) : PathUtils.deleteFile(path, deleteOptionArray);
    }

    public static Counters.PathCounters deleteDirectory(Path path) throws IOException {
        return PathUtils.deleteDirectory(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters deleteDirectory(Path path, DeleteOption ... deleteOptionArray) throws IOException {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), deleteOptionArray, new String[0]), path).getPathCounters();
    }

    public static Counters.PathCounters deleteFile(Path path) throws IOException {
        return PathUtils.deleteFile(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters deleteFile(Path path, DeleteOption ... deleteOptionArray) throws IOException {
        long l2;
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            throw new NoSuchFileException(path.toString());
        }
        Counters.PathCounters pathCounters = Counters.longPathCounters();
        boolean bl2 = Files.exists(path, LinkOption.NOFOLLOW_LINKS);
        long l3 = l2 = bl2 ? Files.size(path) : 0L;
        if (PathUtils.overrideReadOnly(deleteOptionArray) && bl2) {
            PathUtils.setReadOnly(path, false, LinkOption.NOFOLLOW_LINKS);
        }
        if (Files.deleteIfExists(path)) {
            pathCounters.getFileCounter().increment();
            pathCounters.getByteCounter().add(l2);
        }
        return pathCounters;
    }

    private static boolean overrideReadOnly(DeleteOption[] deleteOptionArray) {
        if (deleteOptionArray == null) {
            return false;
        }
        for (DeleteOption deleteOption : deleteOptionArray) {
            if (deleteOption != StandardDeleteOption.OVERRIDE_READ_ONLY) continue;
            return true;
        }
        return false;
    }

    public static boolean directoryAndFileContentEquals(Path path, Path path2) throws IOException {
        return PathUtils.directoryAndFileContentEquals(path, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryAndFileContentEquals(Path path, Path path2, LinkOption[] linkOptionArray, OpenOption[] openOptionArray, FileVisitOption[] fileVisitOptionArray) throws IOException {
        if (path == null && path2 == null) {
            return true;
        }
        if (path == null ^ path2 == null) {
            return false;
        }
        if (!Files.exists(path, new LinkOption[0]) && !Files.exists(path2, new LinkOption[0])) {
            return true;
        }
        RelativeSortedPaths relativeSortedPaths = new RelativeSortedPaths(path, path2, Integer.MAX_VALUE, linkOptionArray, fileVisitOptionArray);
        if (!relativeSortedPaths.equals) {
            return false;
        }
        List<Path> list = relativeSortedPaths.relativeFileList1;
        List<Path> list2 = relativeSortedPaths.relativeFileList2;
        for (Path path3 : list) {
            int n2 = Collections.binarySearch(list2, path3);
            if (n2 > -1) {
                if (PathUtils.fileContentEquals(path.resolve(path3), path2.resolve(path3), linkOptionArray, openOptionArray)) continue;
                return false;
            }
            throw new IllegalStateException("Unexpected mismatch.");
        }
        return true;
    }

    public static boolean directoryContentEquals(Path path, Path path2) throws IOException {
        return PathUtils.directoryContentEquals(path, path2, Integer.MAX_VALUE, EMPTY_LINK_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryContentEquals(Path path, Path path2, int n2, LinkOption[] linkOptionArray, FileVisitOption[] fileVisitOptionArray) throws IOException {
        return new RelativeSortedPaths((Path)path, (Path)path2, (int)n2, (LinkOption[])linkOptionArray, (FileVisitOption[])fileVisitOptionArray).equals;
    }

    public static boolean fileContentEquals(Path path, Path path2) throws IOException {
        return PathUtils.fileContentEquals(path, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY);
    }

    /*
     * Exception decompiling
     */
    public static boolean fileContentEquals(Path var0, Path var1_1, LinkOption[] var2_2, OpenOption[] var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<AclEntry> getAclEntryList(Path path) throws IOException {
        AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        return aclFileAttributeView == null ? null : aclFileAttributeView.getAcl();
    }

    public static boolean isEmpty(Path path) throws IOException {
        return Files.isDirectory(path, new LinkOption[0]) ? PathUtils.isEmptyDirectory(path) : PathUtils.isEmptyFile(path);
    }

    public static boolean isEmptyDirectory(Path path) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            if (directoryStream.iterator().hasNext()) {
                boolean bl2 = false;
                return bl2;
            }
        }
        return true;
    }

    public static boolean isEmptyFile(Path path) throws IOException {
        return Files.size(path) <= 0L;
    }

    static List<Path> relativize(Collection<Path> collection, Path path, boolean bl2, Comparator<? super Path> comparator) {
        Stream<Path> stream = collection.stream().map(path::relativize);
        if (bl2) {
            stream = comparator == null ? stream.sorted() : stream.sorted(comparator);
        }
        return stream.collect(Collectors.toList());
    }

    public static Path setReadOnly(Path path, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, linkOptionArray);
        if (dosFileAttributeView != null) {
            dosFileAttributeView.setReadOnly(bl2);
            return path;
        }
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, linkOptionArray);
        if (posixFileAttributeView != null) {
            PosixFileAttributes posixFileAttributes = posixFileAttributeView.readAttributes();
            Set<PosixFilePermission> set = posixFileAttributes.permissions();
            set.remove((Object)PosixFilePermission.OWNER_WRITE);
            set.remove((Object)PosixFilePermission.GROUP_WRITE);
            set.remove((Object)PosixFilePermission.OTHERS_WRITE);
            return Files.setPosixFilePermissions(path, set);
        }
        throw new IOException("No DosFileAttributeView or PosixFileAttributeView for " + path);
    }

    static Set<FileVisitOption> toFileVisitOptionSet(FileVisitOption ... fileVisitOptionArray) {
        return fileVisitOptionArray == null ? EnumSet.noneOf(FileVisitOption.class) : Arrays.stream(fileVisitOptionArray).collect(Collectors.toSet());
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, Path path) throws IOException {
        Files.walkFileTree(path, t2);
        return t2;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, Path path, Set<FileVisitOption> set, int n2) throws IOException {
        Files.walkFileTree(path, set, n2, t2);
        return t2;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, String string, String ... stringArray) throws IOException {
        return PathUtils.visitFileTree(t2, Paths.get(string, stringArray));
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, URI uRI) throws IOException {
        return PathUtils.visitFileTree(t2, Paths.get(uRI));
    }

    private PathUtils() {
    }

    private static class RelativeSortedPaths {
        final boolean equals;
        final List<Path> relativeFileList1;
        final List<Path> relativeFileList2;

        private RelativeSortedPaths(Path path, Path path2, int n2, LinkOption[] linkOptionArray, FileVisitOption[] fileVisitOptionArray) throws IOException {
            List<Path> list = null;
            List<Path> list2 = null;
            List<Path> list3 = null;
            List<Path> list4 = null;
            if (path == null && path2 == null) {
                this.equals = true;
            } else if (path == null ^ path2 == null) {
                this.equals = false;
            } else {
                boolean bl2 = Files.exists(path, linkOptionArray);
                boolean bl3 = Files.exists(path2, linkOptionArray);
                if (!bl2 || !bl3) {
                    this.equals = !bl2 && !bl3;
                } else {
                    AccumulatorPathVisitor accumulatorPathVisitor = PathUtils.accumulate(path, n2, fileVisitOptionArray);
                    AccumulatorPathVisitor accumulatorPathVisitor2 = PathUtils.accumulate(path2, n2, fileVisitOptionArray);
                    if (accumulatorPathVisitor.getDirList().size() != accumulatorPathVisitor2.getDirList().size() || accumulatorPathVisitor.getFileList().size() != accumulatorPathVisitor2.getFileList().size()) {
                        this.equals = false;
                    } else {
                        list = accumulatorPathVisitor.relativizeDirectories(path, true, null);
                        if (!list.equals(list2 = accumulatorPathVisitor2.relativizeDirectories(path2, true, null))) {
                            this.equals = false;
                        } else {
                            list3 = accumulatorPathVisitor.relativizeFiles(path, true, null);
                            list4 = accumulatorPathVisitor2.relativizeFiles(path2, true, null);
                            this.equals = list3.equals(list4);
                        }
                    }
                }
            }
            this.relativeFileList1 = list3;
            this.relativeFileList2 = list4;
        }
    }
}

