/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.FilenameUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.IOCase;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.Serializable;
import java.util.List;

public class WildcardFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -7426486598995782105L;
    private final String[] wildcards;
    private final IOCase caseSensitivity;

    public WildcardFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public WildcardFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public WildcardFileFilter(String ... stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public WildcardFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.wildcards, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public WildcardFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    public WildcardFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(EMPTY_STRING_ARRAY);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File file, String string) {
        for (String string2 : this.wildcards) {
            if (!FilenameUtils.wildcardMatch(string, string2, this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        String string = file.getName();
        for (String string2 : this.wildcards) {
            if (!FilenameUtils.wildcardMatch(string, string2, this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.wildcards != null) {
            for (int i2 = 0; i2 < this.wildcards.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.wildcards[i2]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

