/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Objects;

public class RandomAccessFileInputStream
extends InputStream {
    private final boolean closeOnClose;
    private final RandomAccessFile randomAccessFile;

    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, false);
    }

    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile, boolean bl2) {
        this.randomAccessFile = Objects.requireNonNull(randomAccessFile, "file");
        this.closeOnClose = bl2;
    }

    @Override
    public int available() throws IOException {
        long l2 = this.availableLong();
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    public long availableLong() throws IOException {
        return this.randomAccessFile.length() - this.randomAccessFile.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.closeOnClose) {
            this.randomAccessFile.close();
        }
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public boolean isCloseOnClose() {
        return this.closeOnClose;
    }

    @Override
    public int read() throws IOException {
        return this.randomAccessFile.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.randomAccessFile.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.randomAccessFile.read(byArray, n2, n3);
    }

    private void seek(long l2) throws IOException {
        this.randomAccessFile.seek(l2);
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3;
        long l4;
        if (l2 <= 0L) {
            return 0L;
        }
        long l5 = this.randomAccessFile.getFilePointer();
        if (l5 >= (l4 = this.randomAccessFile.length())) {
            return 0L;
        }
        long l6 = l5 + l2;
        long l7 = l3 = l6 > l4 ? l4 - 1L : l6;
        if (l3 > 0L) {
            this.seek(l3);
        }
        return this.randomAccessFile.getFilePointer() - l5;
    }
}

