/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReversedLinesFileReader
implements Closeable {
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private final int blockSize;
    private final Charset encoding;
    private final SeekableByteChannel channel;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped;

    @Deprecated
    public ReversedLinesFileReader(File file) throws IOException {
        this(file, 8192, Charset.defaultCharset());
    }

    public ReversedLinesFileReader(File file, Charset charset) throws IOException {
        this(file.toPath(), charset);
    }

    public ReversedLinesFileReader(File file, int n2, Charset charset) throws IOException {
        this(file.toPath(), n2, charset);
    }

    public ReversedLinesFileReader(File file, int n2, String string) throws IOException {
        this(file.toPath(), n2, string);
    }

    public ReversedLinesFileReader(Path path, Charset charset) throws IOException {
        this(path, 8192, charset);
    }

    public ReversedLinesFileReader(Path path, int n2, Charset charset) throws IOException {
        this.blockSize = n2;
        this.encoding = Charsets.toCharset(charset);
        CharsetEncoder charsetEncoder = this.encoding.newEncoder();
        float f2 = charsetEncoder.maxBytesPerChar();
        if (f2 == 1.0f) {
            this.byteDecrement = 1;
        } else if (this.encoding == StandardCharsets.UTF_8) {
            this.byteDecrement = 1;
        } else if (this.encoding == Charset.forName("Shift_JIS") || this.encoding == Charset.forName("windows-31j") || this.encoding == Charset.forName("x-windows-949") || this.encoding == Charset.forName("gbk") || this.encoding == Charset.forName("x-windows-950")) {
            this.byteDecrement = 1;
        } else if (this.encoding == StandardCharsets.UTF_16BE || this.encoding == StandardCharsets.UTF_16LE) {
            this.byteDecrement = 2;
        } else {
            if (this.encoding == StandardCharsets.UTF_16) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + charset + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{"\r\n".getBytes(this.encoding), "\n".getBytes(this.encoding), "\r".getBytes(this.encoding)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
        this.channel = Files.newByteChannel(path, StandardOpenOption.READ);
        this.totalByteLength = this.channel.size();
        int n3 = (int)(this.totalByteLength % (long)n2);
        if (n3 > 0) {
            this.totalBlockCount = this.totalByteLength / (long)n2 + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)n2;
            if (this.totalByteLength > 0L) {
                n3 = n2;
            }
        }
        this.currentFilePart = new FilePart(this.totalBlockCount, n3, null);
    }

    public ReversedLinesFileReader(Path path, int n2, String string) throws IOException {
        this(path, n2, Charsets.toCharset(string));
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public String readLine() throws IOException {
        String string = this.currentFilePart.readLine();
        while (string == null) {
            this.currentFilePart = this.currentFilePart.rollOver();
            if (this.currentFilePart == null) break;
            string = this.currentFilePart.readLine();
        }
        if (EMPTY_STRING.equals(string) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            string = this.readLine();
        }
        return string;
    }

    public List<String> readLines(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("lineCount < 0");
        }
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.readLine();
            if (string == null) {
                return arrayList;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public String toString(int n2) throws IOException {
        List<String> list = this.readLines(n2);
        Collections.reverse(list);
        return list.isEmpty() ? EMPTY_STRING : String.join((CharSequence)System.lineSeparator(), list) + System.lineSeparator();
    }

    private class FilePart {
        private final long no;
        private final byte[] data;
        private byte[] leftOver;
        private int currentLastBytePos;

        private FilePart(long l2, int n2, byte[] byArray) throws IOException {
            this.no = l2;
            int n3 = n2 + (byArray != null ? byArray.length : 0);
            this.data = new byte[n3];
            long l3 = (l2 - 1L) * (long)ReversedLinesFileReader.this.blockSize;
            if (l2 > 0L) {
                ReversedLinesFileReader.this.channel.position(l3);
                int n4 = ReversedLinesFileReader.this.channel.read(ByteBuffer.wrap(this.data, 0, n2));
                if (n4 != n2) {
                    throw new IllegalStateException("Count of requested bytes and actually read bytes don't match");
                }
            }
            if (byArray != null) {
                System.arraycopy(byArray, 0, this.data, n2, byArray.length);
            }
            this.currentLastBytePos = this.data.length - 1;
            this.leftOver = null;
        }

        private void createLeftOver() {
            int n2 = this.currentLastBytePos + 1;
            if (n2 > 0) {
                this.leftOver = new byte[n2];
                System.arraycopy(this.data, 0, this.leftOver, 0, n2);
            } else {
                this.leftOver = null;
            }
            this.currentLastBytePos = -1;
        }

        private int getNewLineMatchByteCount(byte[] byArray, int n2) {
            for (byte[] byArray2 : ReversedLinesFileReader.this.newLineSequences) {
                boolean bl2 = true;
                for (int i2 = byArray2.length - 1; i2 >= 0; --i2) {
                    int n3 = n2 + i2 - (byArray2.length - 1);
                    bl2 &= n3 >= 0 && byArray[n3] == byArray2[i2];
                }
                if (!bl2) continue;
                return byArray2.length;
            }
            return 0;
        }

        private String readLine() throws IOException {
            String string = null;
            boolean bl2 = this.no == 1L;
            int n2 = this.currentLastBytePos;
            while (n2 > -1) {
                if (!bl2 && n2 < ReversedLinesFileReader.this.avoidNewlineSplitBufferSize) {
                    this.createLeftOver();
                    break;
                }
                int n3 = this.getNewLineMatchByteCount(this.data, n2);
                if (n3 > 0) {
                    int n4 = n2 + 1;
                    int n5 = this.currentLastBytePos - n4 + 1;
                    if (n5 < 0) {
                        throw new IllegalStateException("Unexpected negative line length=" + n5);
                    }
                    byte[] byArray = new byte[n5];
                    System.arraycopy(this.data, n4, byArray, 0, n5);
                    string = new String(byArray, ReversedLinesFileReader.this.encoding);
                    this.currentLastBytePos = n2 - n3;
                    break;
                }
                if ((n2 -= ReversedLinesFileReader.this.byteDecrement) >= 0) continue;
                this.createLeftOver();
                break;
            }
            if (bl2 && this.leftOver != null) {
                string = new String(this.leftOver, ReversedLinesFileReader.this.encoding);
                this.leftOver = null;
            }
            return string;
        }

        private FilePart rollOver() throws IOException {
            if (this.currentLastBytePos > -1) {
                throw new IllegalStateException("Current currentLastCharPos unexpectedly positive... last readLine() should have returned something! currentLastCharPos=" + this.currentLastBytePos);
            }
            if (this.no > 1L) {
                return new FilePart(this.no - 1L, ReversedLinesFileReader.this.blockSize, this.leftOver);
            }
            if (this.leftOver != null) {
                throw new IllegalStateException("Unexpected leftover of the last block: leftOverOfThisFilePart=" + new String(this.leftOver, ReversedLinesFileReader.this.encoding));
            }
            return null;
        }
    }
}

