/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.FileUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input.TailerListener;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input.TailerListenerAdapter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

public class Tailer
implements Runnable {
    private static final int DEFAULT_DELAY_MILLIS = 1000;
    private static final String RAF_MODE = "r";
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private final byte[] inbuf;
    private final File file;
    private final Charset charset;
    private final long delayMillis;
    private final boolean end;
    private final TailerListener listener;
    private final boolean reOpen;
    private volatile boolean run = true;

    public Tailer(File file, TailerListener tailerListener) {
        this(file, tailerListener, 1000L);
    }

    public Tailer(File file, TailerListener tailerListener, long l2) {
        this(file, tailerListener, l2, false);
    }

    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl2) {
        this(file, tailerListener, l2, bl2, 8192);
    }

    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl2, boolean bl3) {
        this(file, tailerListener, l2, bl2, bl3, 8192);
    }

    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl2, int n2) {
        this(file, tailerListener, l2, bl2, false, n2);
    }

    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl2, boolean bl3, int n2) {
        this(file, DEFAULT_CHARSET, tailerListener, l2, bl2, bl3, n2);
    }

    public Tailer(File file, Charset charset, TailerListener tailerListener, long l2, boolean bl2, boolean bl3, int n2) {
        this.file = file;
        this.delayMillis = l2;
        this.end = bl2;
        this.inbuf = new byte[n2];
        this.listener = tailerListener;
        tailerListener.init(this);
        this.reOpen = bl3;
        this.charset = charset;
    }

    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl2, int n2) {
        return Tailer.create(file, tailerListener, l2, bl2, false, n2);
    }

    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl2, boolean bl3, int n2) {
        return Tailer.create(file, DEFAULT_CHARSET, tailerListener, l2, bl2, bl3, n2);
    }

    public static Tailer create(File file, Charset charset, TailerListener tailerListener, long l2, boolean bl2, boolean bl3, int n2) {
        Tailer tailer = new Tailer(file, charset, tailerListener, l2, bl2, bl3, n2);
        Thread thread = new Thread(tailer);
        thread.setDaemon(true);
        thread.start();
        return tailer;
    }

    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl2) {
        return Tailer.create(file, tailerListener, l2, bl2, 8192);
    }

    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl2, boolean bl3) {
        return Tailer.create(file, tailerListener, l2, bl2, bl3, 8192);
    }

    public static Tailer create(File file, TailerListener tailerListener, long l2) {
        return Tailer.create(file, tailerListener, l2, false);
    }

    public static Tailer create(File file, TailerListener tailerListener) {
        return Tailer.create(file, tailerListener, 1000L, false);
    }

    public File getFile() {
        return this.file;
    }

    protected boolean getRun() {
        return this.run;
    }

    public long getDelay() {
        return this.delayMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RandomAccessFile randomAccessFile = null;
        try {
            long l2 = 0L;
            long l3 = 0L;
            while (this.getRun() && randomAccessFile == null) {
                try {
                    randomAccessFile = new RandomAccessFile(this.file, RAF_MODE);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.listener.fileNotFound();
                }
                if (randomAccessFile == null) {
                    Thread.sleep(this.delayMillis);
                    continue;
                }
                l3 = this.end ? this.file.length() : 0L;
                l2 = this.file.lastModified();
                randomAccessFile.seek(l3);
            }
            while (this.getRun()) {
                boolean bl2 = FileUtils.isFileNewer(this.file, l2);
                long l4 = this.file.length();
                if (l4 < l3) {
                    this.listener.fileRotated();
                    try {
                        RandomAccessFile randomAccessFile2 = randomAccessFile;
                        Throwable throwable = null;
                        try {
                            randomAccessFile = new RandomAccessFile(this.file, RAF_MODE);
                            try {
                                this.readLines(randomAccessFile2);
                            }
                            catch (IOException iOException) {
                                this.listener.handle(iOException);
                            }
                            l3 = 0L;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (randomAccessFile2 == null) continue;
                            if (throwable != null) {
                                try {
                                    randomAccessFile2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            randomAccessFile2.close();
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.listener.fileNotFound();
                        Thread.sleep(this.delayMillis);
                    }
                    continue;
                }
                if (l4 > l3) {
                    l3 = this.readLines(randomAccessFile);
                    l2 = this.file.lastModified();
                } else if (bl2) {
                    l3 = 0L;
                    randomAccessFile.seek(l3);
                    l3 = this.readLines(randomAccessFile);
                    l2 = this.file.lastModified();
                }
                if (this.reOpen && randomAccessFile != null) {
                    randomAccessFile.close();
                }
                Thread.sleep(this.delayMillis);
                if (!this.getRun() || !this.reOpen) continue;
                randomAccessFile = new RandomAccessFile(this.file, RAF_MODE);
                randomAccessFile.seek(l3);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.listener.handle(interruptedException);
        }
        catch (Exception exception) {
            this.listener.handle(exception);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                this.listener.handle(iOException);
            }
            this.stop();
        }
    }

    public void stop() {
        this.run = false;
    }

    private long readLines(RandomAccessFile randomAccessFile) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);){
            int n2;
            long l2;
            long l3 = l2 = randomAccessFile.getFilePointer();
            boolean bl2 = false;
            while (this.getRun() && (n2 = randomAccessFile.read(this.inbuf)) != -1) {
                block14: for (int i2 = 0; i2 < n2; ++i2) {
                    byte by2 = this.inbuf[i2];
                    switch (by2) {
                        case 10: {
                            bl2 = false;
                            this.listener.handle(new String(byteArrayOutputStream.toByteArray(), this.charset));
                            byteArrayOutputStream.reset();
                            l3 = l2 + (long)i2 + 1L;
                            continue block14;
                        }
                        case 13: {
                            if (bl2) {
                                byteArrayOutputStream.write(13);
                            }
                            bl2 = true;
                            continue block14;
                        }
                        default: {
                            if (bl2) {
                                bl2 = false;
                                this.listener.handle(new String(byteArrayOutputStream.toByteArray(), this.charset));
                                byteArrayOutputStream.reset();
                                l3 = l2 + (long)i2 + 1L;
                            }
                            byteArrayOutputStream.write(by2);
                        }
                    }
                }
                l2 = randomAccessFile.getFilePointer();
            }
            randomAccessFile.seek(l3);
            if (this.listener instanceof TailerListenerAdapter) {
                ((TailerListenerAdapter)this.listener).endOfFileReached();
            }
            long l4 = l3;
            return l4;
        }
    }
}

