/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends ProxyInputStream {
    private final OutputStream branch;
    private final boolean closeBranch;

    public TeeInputStream(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, false);
    }

    public TeeInputStream(InputStream inputStream, OutputStream outputStream, boolean bl2) {
        super(inputStream);
        this.branch = outputStream;
        this.closeBranch = bl2;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.closeBranch) {
                this.branch.close();
            }
        }
    }

    @Override
    public int read() throws IOException {
        int n2 = super.read();
        if (n2 != -1) {
            this.branch.write(n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = super.read(byArray, n2, n3);
        if (n4 != -1) {
            this.branch.write(byArray, n2, n4);
        }
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = super.read(byArray);
        if (n2 != -1) {
            this.branch.write(byArray, 0, n2);
        }
        return n2;
    }
}

