/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input;

import java.io.InputStream;
import java.util.Objects;

public class UnsynchronizedByteArrayInputStream
extends InputStream {
    public static final int END_OF_STREAM = -1;
    private final byte[] data;
    private final int eod;
    private int offset;
    private int markedOffset;

    public UnsynchronizedByteArrayInputStream(byte[] byArray) {
        Objects.requireNonNull(byArray);
        this.data = byArray;
        this.offset = 0;
        this.eod = byArray.length;
        this.markedOffset = this.offset;
    }

    public UnsynchronizedByteArrayInputStream(byte[] byArray, int n2) {
        Objects.requireNonNull(byArray);
        if (n2 < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        this.data = byArray;
        this.offset = Math.min(n2, byArray.length > 0 ? byArray.length : n2);
        this.eod = byArray.length;
        this.markedOffset = this.offset;
    }

    public UnsynchronizedByteArrayInputStream(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray);
        if (n2 < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        this.data = byArray;
        this.offset = Math.min(n2, byArray.length > 0 ? byArray.length : n2);
        this.eod = Math.min(this.offset + n3, byArray.length);
        this.markedOffset = this.offset;
    }

    @Override
    public int available() {
        return this.offset < this.eod ? this.eod - this.offset : 0;
    }

    @Override
    public int read() {
        return this.offset < this.eod ? this.data[this.offset++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray) {
        Objects.requireNonNull(byArray);
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray);
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.offset >= this.eod) {
            return -1;
        }
        int n4 = this.eod - this.offset;
        if (n3 < n4) {
            n4 = n3;
        }
        if (n4 <= 0) {
            return 0;
        }
        System.arraycopy(this.data, this.offset, byArray, n2, n4);
        this.offset += n4;
        return n4;
    }

    @Override
    public long skip(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skipping backward is not supported");
        }
        long l3 = this.eod - this.offset;
        if (l2 < l3) {
            l3 = l2;
        }
        this.offset = (int)((long)this.offset + l3);
        return l3;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n2) {
        this.markedOffset = this.offset;
    }

    @Override
    public void reset() {
        this.offset = this.markedOffset;
    }
}

