/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.Charsets;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private final Writer out;
    private final File lockFile;

    public LockableFileWriter(String string) throws IOException {
        this(string, false, null);
    }

    public LockableFileWriter(String string, boolean bl2) throws IOException {
        this(string, bl2, null);
    }

    public LockableFileWriter(String string, boolean bl2, String string2) throws IOException {
        this(new File(string), bl2, string2);
    }

    public LockableFileWriter(File file) throws IOException {
        this(file, false, null);
    }

    public LockableFileWriter(File file, boolean bl2) throws IOException {
        this(file, bl2, null);
    }

    @Deprecated
    public LockableFileWriter(File file, boolean bl2, String string) throws IOException {
        this(file, Charset.defaultCharset(), bl2, string);
    }

    public LockableFileWriter(File file, Charset charset) throws IOException {
        this(file, charset, false, null);
    }

    public LockableFileWriter(File file, String string) throws IOException {
        this(file, string, false, null);
    }

    public LockableFileWriter(File file, Charset charset, boolean bl2, String string) throws IOException {
        file = file.getAbsoluteFile();
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir(file.getParentFile());
        }
        if (file.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        if (string == null) {
            string = System.getProperty("java.io.tmpdir");
        }
        File file2 = new File(string);
        FileUtils.forceMkdir(file2);
        this.testLockDir(file2);
        this.lockFile = new File(file2, file.getName() + LCK);
        this.createLock();
        this.out = this.initWriter(file, charset, bl2);
    }

    public LockableFileWriter(File file, String string, boolean bl2, String string2) throws IOException {
        this(file, Charsets.toCharset(string), bl2, string2);
    }

    private void testLockDir(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("Could not find lockDir: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new IOException("Could not write to lockDir: " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLock() throws IOException {
        Class<LockableFileWriter> clazz = LockableFileWriter.class;
        synchronized (LockableFileWriter.class) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Writer initWriter(File file, Charset charset, boolean bl2) throws IOException {
        boolean bl3 = file.exists();
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), bl2), Charsets.toCharset(charset));
        }
        catch (IOException | RuntimeException exception) {
            FileUtils.deleteQuietly(this.lockFile);
            if (!bl3) {
                FileUtils.deleteQuietly(file);
            }
            throw exception;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.lockFile.delete();
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.out.write(n2);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.out.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.out.write(cArray, n2, n3);
    }

    @Override
    public void write(String string) throws IOException {
        this.out.write(string);
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this.out.write(string, n2, n3);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

