/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl;

import com.ibm.cognos.externals.org.apache.http_4_4_14.ConnectionClosedException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpConnectionMetrics;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpInetConnection;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpMessage;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.MessageConstraints;
import com.ibm.cognos.externals.org.apache.http_4_4_14.entity.BasicHttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.entity.ContentLengthStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.HttpConnectionMetricsImpl;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.entity.LaxContentLengthStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.entity.StrictContentLengthStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.ChunkedInputStream;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.ChunkedOutputStream;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.ContentLengthInputStream;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.ContentLengthOutputStream;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.EmptyInputStream;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.HttpTransportMetricsImpl;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.IdentityInputStream;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.IdentityOutputStream;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.SessionInputBufferImpl;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.SessionOutputBufferImpl;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.SessionInputBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.SessionOutputBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.NetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.atomic.AtomicReference;

public class BHttpConnectionBase
implements HttpInetConnection {
    private final SessionInputBufferImpl inBuffer;
    private final SessionOutputBufferImpl outbuffer;
    private final MessageConstraints messageConstraints;
    private final HttpConnectionMetricsImpl connMetrics;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final AtomicReference<Socket> socketHolder;

    protected BHttpConnectionBase(int n2, int n3, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2) {
        Args.positive(n2, "Buffer size");
        HttpTransportMetricsImpl httpTransportMetricsImpl = new HttpTransportMetricsImpl();
        HttpTransportMetricsImpl httpTransportMetricsImpl2 = new HttpTransportMetricsImpl();
        this.inBuffer = new SessionInputBufferImpl(httpTransportMetricsImpl, n2, -1, messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT, charsetDecoder);
        this.outbuffer = new SessionOutputBufferImpl(httpTransportMetricsImpl2, n2, n3, charsetEncoder);
        this.messageConstraints = messageConstraints;
        this.connMetrics = new HttpConnectionMetricsImpl(httpTransportMetricsImpl, httpTransportMetricsImpl2);
        this.incomingContentStrategy = contentLengthStrategy != null ? contentLengthStrategy : LaxContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = contentLengthStrategy2 != null ? contentLengthStrategy2 : StrictContentLengthStrategy.INSTANCE;
        this.socketHolder = new AtomicReference();
    }

    protected void ensureOpen() throws IOException {
        Socket socket = this.socketHolder.get();
        if (socket == null) {
            throw new ConnectionClosedException();
        }
        if (!this.inBuffer.isBound()) {
            this.inBuffer.bind(this.getSocketInputStream(socket));
        }
        if (!this.outbuffer.isBound()) {
            this.outbuffer.bind(this.getSocketOutputStream(socket));
        }
    }

    protected InputStream getSocketInputStream(Socket socket) throws IOException {
        return socket.getInputStream();
    }

    protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    protected void bind(Socket socket) throws IOException {
        Args.notNull(socket, "Socket");
        this.socketHolder.set(socket);
        this.inBuffer.bind(null);
        this.outbuffer.bind(null);
    }

    protected SessionInputBuffer getSessionInputBuffer() {
        return this.inBuffer;
    }

    protected SessionOutputBuffer getSessionOutputBuffer() {
        return this.outbuffer;
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    @Override
    public boolean isOpen() {
        return this.socketHolder.get() != null;
    }

    protected Socket getSocket() {
        return this.socketHolder.get();
    }

    protected OutputStream createOutputStream(long l2, SessionOutputBuffer sessionOutputBuffer) {
        if (l2 == -2L) {
            return new ChunkedOutputStream(2048, sessionOutputBuffer);
        }
        if (l2 == -1L) {
            return new IdentityOutputStream(sessionOutputBuffer);
        }
        return new ContentLengthOutputStream(sessionOutputBuffer, l2);
    }

    protected OutputStream prepareOutput(HttpMessage httpMessage) throws HttpException {
        long l2 = this.outgoingContentStrategy.determineLength(httpMessage);
        return this.createOutputStream(l2, this.outbuffer);
    }

    protected InputStream createInputStream(long l2, SessionInputBuffer sessionInputBuffer) {
        if (l2 == -2L) {
            return new ChunkedInputStream(sessionInputBuffer, this.messageConstraints);
        }
        if (l2 == -1L) {
            return new IdentityInputStream(sessionInputBuffer);
        }
        if (l2 == 0L) {
            return EmptyInputStream.INSTANCE;
        }
        return new ContentLengthInputStream(sessionInputBuffer, l2);
    }

    protected HttpEntity prepareInput(HttpMessage httpMessage) throws HttpException {
        Header header;
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        long l2 = this.incomingContentStrategy.determineLength(httpMessage);
        InputStream inputStream = this.createInputStream(l2, this.inBuffer);
        if (l2 == -2L) {
            basicHttpEntity.setChunked(true);
            basicHttpEntity.setContentLength(-1L);
            basicHttpEntity.setContent(inputStream);
        } else if (l2 == -1L) {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(-1L);
            basicHttpEntity.setContent(inputStream);
        } else {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(l2);
            basicHttpEntity.setContent(inputStream);
        }
        Header header2 = httpMessage.getFirstHeader("Content-Type");
        if (header2 != null) {
            basicHttpEntity.setContentType(header2);
        }
        if ((header = httpMessage.getFirstHeader("Content-Encoding")) != null) {
            basicHttpEntity.setContentEncoding(header);
        }
        return basicHttpEntity;
    }

    @Override
    public InetAddress getLocalAddress() {
        Socket socket = this.socketHolder.get();
        return socket != null ? socket.getLocalAddress() : null;
    }

    @Override
    public int getLocalPort() {
        Socket socket = this.socketHolder.get();
        return socket != null ? socket.getLocalPort() : -1;
    }

    @Override
    public InetAddress getRemoteAddress() {
        Socket socket = this.socketHolder.get();
        return socket != null ? socket.getInetAddress() : null;
    }

    @Override
    public int getRemotePort() {
        Socket socket = this.socketHolder.get();
        return socket != null ? socket.getPort() : -1;
    }

    @Override
    public void setSocketTimeout(int n2) {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            try {
                socket.setSoTimeout(n2);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getSocketTimeout() {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            try {
                return socket.getSoTimeout();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws IOException {
        Socket socket = this.socketHolder.getAndSet(null);
        if (socket != null) {
            try {
                socket.setSoLinger(true, 0);
            }
            catch (IOException iOException) {
            }
            finally {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Socket socket = this.socketHolder.getAndSet(null);
        if (socket != null) {
            try {
                this.inBuffer.clear();
                this.outbuffer.flush();
                try {
                    try {
                        socket.shutdownOutput();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        socket.shutdownInput();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            finally {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillInputBuffer(int n2) throws IOException {
        Socket socket = this.socketHolder.get();
        int n3 = socket.getSoTimeout();
        try {
            socket.setSoTimeout(n2);
            int n4 = this.inBuffer.fillBuffer();
            return n4;
        }
        finally {
            socket.setSoTimeout(n3);
        }
    }

    protected boolean awaitInput(int n2) throws IOException {
        if (this.inBuffer.hasBufferedData()) {
            return true;
        }
        this.fillInputBuffer(n2);
        return this.inBuffer.hasBufferedData();
    }

    @Override
    public boolean isStale() {
        if (!this.isOpen()) {
            return true;
        }
        try {
            int n2 = this.fillInputBuffer(1);
            return n2 < 0;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    protected void incrementRequestCount() {
        this.connMetrics.incrementRequestCount();
    }

    protected void incrementResponseCount() {
        this.connMetrics.incrementResponseCount();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.connMetrics;
    }

    public String toString() {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            StringBuilder stringBuilder = new StringBuilder();
            SocketAddress socketAddress = socket.getRemoteSocketAddress();
            SocketAddress socketAddress2 = socket.getLocalSocketAddress();
            if (socketAddress != null && socketAddress2 != null) {
                NetUtils.formatAddress(stringBuilder, socketAddress2);
                stringBuilder.append("<->");
                NetUtils.formatAddress(stringBuilder, socketAddress);
            }
            return stringBuilder.toString();
        }
        return "[Not bound]";
    }
}

