/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponseFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ReasonPhraseCatalog;
import com.ibm.cognos.externals.org.apache.http_4_4_14.StatusLine;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.EnglishReasonPhraseCatalog;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.BasicHttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.BasicStatusLine;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog reasonPhraseCatalog) {
        this.reasonCatalog = Args.notNull(reasonPhraseCatalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion protocolVersion, int n2, HttpContext httpContext) {
        Args.notNull(protocolVersion, "HTTP version");
        Locale locale = this.determineLocale(httpContext);
        String string = this.reasonCatalog.getReason(n2, locale);
        BasicStatusLine basicStatusLine = new BasicStatusLine(protocolVersion, n2, string);
        return new BasicHttpResponse(basicStatusLine, this.reasonCatalog, locale);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusLine, HttpContext httpContext) {
        Args.notNull(statusLine, "Status line");
        return new BasicHttpResponse(statusLine, this.reasonCatalog, this.determineLocale(httpContext));
    }

    protected Locale determineLocale(HttpContext httpContext) {
        return Locale.getDefault();
    }
}

