/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl.bootstrap;

import com.ibm.cognos.externals.org.apache.http_4_4_14.ConnectionReuseStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ExceptionLogger;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpConnectionFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequestInterceptor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponseFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponseInterceptor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.ConnectionConfig;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.SocketConfig;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.DefaultBHttpServerConnection;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.DefaultBHttpServerConnectionFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.DefaultConnectionReuseStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.DefaultHttpResponseFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.bootstrap.HttpServer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.bootstrap.SSLServerSetupHandler;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpExpectationVerifier;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpProcessor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpProcessorBuilder;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpRequestHandler;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpRequestHandlerMapper;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpService;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.ResponseConnControl;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.ResponseContent;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.ResponseDate;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.ResponseServer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.UriHttpRequestHandlerMapper;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;

public class ServerBootstrap {
    private int listenerPort;
    private InetAddress localAddress;
    private SocketConfig socketConfig;
    private ConnectionConfig connectionConfig;
    private LinkedList<HttpRequestInterceptor> requestFirst;
    private LinkedList<HttpRequestInterceptor> requestLast;
    private LinkedList<HttpResponseInterceptor> responseFirst;
    private LinkedList<HttpResponseInterceptor> responseLast;
    private String serverInfo;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private HttpResponseFactory responseFactory;
    private HttpRequestHandlerMapper handlerMapper;
    private Map<String, HttpRequestHandler> handlerMap;
    private HttpExpectationVerifier expectationVerifier;
    private ServerSocketFactory serverSocketFactory;
    private SSLContext sslContext;
    private SSLServerSetupHandler sslSetupHandler;
    private HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory;
    private ExceptionLogger exceptionLogger;

    private ServerBootstrap() {
    }

    public static ServerBootstrap bootstrap() {
        return new ServerBootstrap();
    }

    public final ServerBootstrap setListenerPort(int n2) {
        this.listenerPort = n2;
        return this;
    }

    public final ServerBootstrap setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
        return this;
    }

    public final ServerBootstrap setSocketConfig(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
        return this;
    }

    public final ServerBootstrap setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
        return this;
    }

    public final ServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final ServerBootstrap addInterceptorFirst(HttpResponseInterceptor httpResponseInterceptor) {
        if (httpResponseInterceptor == null) {
            return this;
        }
        if (this.responseFirst == null) {
            this.responseFirst = new LinkedList();
        }
        this.responseFirst.addFirst(httpResponseInterceptor);
        return this;
    }

    public final ServerBootstrap addInterceptorLast(HttpResponseInterceptor httpResponseInterceptor) {
        if (httpResponseInterceptor == null) {
            return this;
        }
        if (this.responseLast == null) {
            this.responseLast = new LinkedList();
        }
        this.responseLast.addLast(httpResponseInterceptor);
        return this;
    }

    public final ServerBootstrap addInterceptorFirst(HttpRequestInterceptor httpRequestInterceptor) {
        if (httpRequestInterceptor == null) {
            return this;
        }
        if (this.requestFirst == null) {
            this.requestFirst = new LinkedList();
        }
        this.requestFirst.addFirst(httpRequestInterceptor);
        return this;
    }

    public final ServerBootstrap addInterceptorLast(HttpRequestInterceptor httpRequestInterceptor) {
        if (httpRequestInterceptor == null) {
            return this;
        }
        if (this.requestLast == null) {
            this.requestLast = new LinkedList();
        }
        this.requestLast.addLast(httpRequestInterceptor);
        return this;
    }

    public final ServerBootstrap setServerInfo(String string) {
        this.serverInfo = string;
        return this;
    }

    public final ServerBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.connStrategy = connectionReuseStrategy;
        return this;
    }

    public final ServerBootstrap setResponseFactory(HttpResponseFactory httpResponseFactory) {
        this.responseFactory = httpResponseFactory;
        return this;
    }

    public final ServerBootstrap setHandlerMapper(HttpRequestHandlerMapper httpRequestHandlerMapper) {
        this.handlerMapper = httpRequestHandlerMapper;
        return this;
    }

    public final ServerBootstrap registerHandler(String string, HttpRequestHandler httpRequestHandler) {
        if (string == null || httpRequestHandler == null) {
            return this;
        }
        if (this.handlerMap == null) {
            this.handlerMap = new HashMap<String, HttpRequestHandler>();
        }
        this.handlerMap.put(string, httpRequestHandler);
        return this;
    }

    public final ServerBootstrap setExpectationVerifier(HttpExpectationVerifier httpExpectationVerifier) {
        this.expectationVerifier = httpExpectationVerifier;
        return this;
    }

    public final ServerBootstrap setConnectionFactory(HttpConnectionFactory<? extends DefaultBHttpServerConnection> httpConnectionFactory) {
        this.connectionFactory = httpConnectionFactory;
        return this;
    }

    public final ServerBootstrap setSslSetupHandler(SSLServerSetupHandler sSLServerSetupHandler) {
        this.sslSetupHandler = sSLServerSetupHandler;
        return this;
    }

    public final ServerBootstrap setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
        return this;
    }

    public final ServerBootstrap setSslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
        return this;
    }

    public final ServerBootstrap setExceptionLogger(ExceptionLogger exceptionLogger) {
        this.exceptionLogger = exceptionLogger;
        return this;
    }

    public HttpServer create() {
        ExceptionLogger exceptionLogger;
        DefaultBHttpServerConnectionFactory defaultBHttpServerConnectionFactory;
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        HttpProcessor httpProcessor = this.httpProcessor;
        if (httpProcessor == null) {
            object3 = HttpProcessorBuilder.create();
            if (this.requestFirst != null) {
                object2 = this.requestFirst.iterator();
                while (object2.hasNext()) {
                    iterator = (HttpRequestInterceptor)object2.next();
                    ((HttpProcessorBuilder)object3).addFirst((HttpRequestInterceptor)((Object)iterator));
                }
            }
            if (this.responseFirst != null) {
                object2 = this.responseFirst.iterator();
                while (object2.hasNext()) {
                    iterator = (HttpResponseInterceptor)object2.next();
                    ((HttpProcessorBuilder)object3).addFirst((HttpResponseInterceptor)((Object)iterator));
                }
            }
            if ((object2 = this.serverInfo) == null) {
                object2 = "Apache-HttpCore/1.1";
            }
            ((HttpProcessorBuilder)object3).addAll(new ResponseDate(), new ResponseServer((String)object2), new ResponseContent(), new ResponseConnControl());
            if (this.requestLast != null) {
                iterator = this.requestLast.iterator();
                while (iterator.hasNext()) {
                    object = (HttpRequestInterceptor)iterator.next();
                    ((HttpProcessorBuilder)object3).addLast((HttpRequestInterceptor)object);
                }
            }
            if (this.responseLast != null) {
                iterator = this.responseLast.iterator();
                while (iterator.hasNext()) {
                    object = (HttpResponseInterceptor)iterator.next();
                    ((HttpProcessorBuilder)object3).addLast((HttpResponseInterceptor)object);
                }
            }
            httpProcessor = ((HttpProcessorBuilder)object3).build();
        }
        if ((object3 = this.handlerMapper) == null) {
            object2 = new UriHttpRequestHandlerMapper();
            if (this.handlerMap != null) {
                iterator = this.handlerMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    object = (Map.Entry)iterator.next();
                    ((UriHttpRequestHandlerMapper)object2).register((String)object.getKey(), (HttpRequestHandler)object.getValue());
                }
            }
            object3 = object2;
        }
        if ((object2 = this.connStrategy) == null) {
            object2 = DefaultConnectionReuseStrategy.INSTANCE;
        }
        if ((iterator = this.responseFactory) == null) {
            iterator = DefaultHttpResponseFactory.INSTANCE;
        }
        object = new HttpService(httpProcessor, (ConnectionReuseStrategy)object2, (HttpResponseFactory)((Object)iterator), (HttpRequestHandlerMapper)object3, this.expectationVerifier);
        ServerSocketFactory serverSocketFactory = this.serverSocketFactory;
        if (serverSocketFactory == null) {
            serverSocketFactory = this.sslContext != null ? this.sslContext.getServerSocketFactory() : ServerSocketFactory.getDefault();
        }
        if ((defaultBHttpServerConnectionFactory = this.connectionFactory) == null) {
            defaultBHttpServerConnectionFactory = this.connectionConfig != null ? new DefaultBHttpServerConnectionFactory(this.connectionConfig) : DefaultBHttpServerConnectionFactory.INSTANCE;
        }
        if ((exceptionLogger = this.exceptionLogger) == null) {
            exceptionLogger = ExceptionLogger.NO_OP;
        }
        return new HttpServer(this.listenerPort > 0 ? this.listenerPort : 0, this.localAddress, this.socketConfig != null ? this.socketConfig : SocketConfig.DEFAULT, serverSocketFactory, (HttpService)object, defaultBHttpServerConnectionFactory, this.sslSetupHandler, exceptionLogger);
    }
}

