/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl.entity;

import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpMessage;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.entity.ContentLengthStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StrictContentLengthStrategy
implements ContentLengthStrategy {
    public static final StrictContentLengthStrategy INSTANCE = new StrictContentLengthStrategy();
    private final int implicitLen;

    public StrictContentLengthStrategy(int n2) {
        this.implicitLen = n2;
    }

    public StrictContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage httpMessage) throws HttpException {
        Args.notNull(httpMessage, "HTTP message");
        Header header = httpMessage.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            String string = header.getValue();
            if ("chunked".equalsIgnoreCase(string)) {
                if (httpMessage.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + httpMessage.getProtocolVersion());
                }
                return -2L;
            }
            if ("identity".equalsIgnoreCase(string)) {
                return -1L;
            }
            throw new ProtocolException("Unsupported transfer encoding: " + string);
        }
        Header header2 = httpMessage.getFirstHeader("Content-Length");
        if (header2 != null) {
            String string = header2.getValue();
            try {
                long l2 = Long.parseLong(string);
                if (l2 < 0L) {
                    throw new ProtocolException("Negative content length: " + string);
                }
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException("Invalid content length: " + string);
            }
        }
        return this.implicitLen;
    }
}

