/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io;

import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpMessage;
import com.ibm.cognos.externals.org.apache.http_4_4_14.MessageConstraintException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ParseException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.MessageConstraints;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpMessageParser;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.SessionInputBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.BasicLineParser;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.LineParser;
import com.ibm.cognos.externals.org.apache.http_4_4_14.params.HttpParamConfig;
import com.ibm.cognos.externals.org.apache.http_4_4_14.params.HttpParams;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMessageParser<T extends HttpMessage>
implements HttpMessageParser<T> {
    private static final int HEAD_LINE = 0;
    private static final int HEADERS = 1;
    private final SessionInputBuffer sessionBuffer;
    private final MessageConstraints messageConstraints;
    private final List<CharArrayBuffer> headerLines;
    protected final LineParser lineParser;
    private int state;
    private T message;

    @Deprecated
    public AbstractMessageParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpParams httpParams) {
        Args.notNull(sessionInputBuffer, "Session input buffer");
        Args.notNull(httpParams, "HTTP parameters");
        this.sessionBuffer = sessionInputBuffer;
        this.messageConstraints = HttpParamConfig.getMessageConstraints(httpParams);
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.headerLines = new ArrayList<CharArrayBuffer>();
        this.state = 0;
    }

    public AbstractMessageParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, MessageConstraints messageConstraints) {
        this.sessionBuffer = Args.notNull(sessionInputBuffer, "Session input buffer");
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.messageConstraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.headerLines = new ArrayList<CharArrayBuffer>();
        this.state = 0;
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, int n2, int n3, LineParser lineParser) throws HttpException, IOException {
        ArrayList<CharArrayBuffer> arrayList = new ArrayList<CharArrayBuffer>();
        return AbstractMessageParser.parseHeaders(sessionInputBuffer, n2, n3, lineParser != null ? lineParser : BasicLineParser.INSTANCE, arrayList);
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, int n2, int n3, LineParser lineParser, List<CharArrayBuffer> list) throws HttpException, IOException {
        int n4;
        block9: {
            Args.notNull(sessionInputBuffer, "Session input buffer");
            Args.notNull(lineParser, "Line parser");
            Args.notNull(list, "Header line list");
            CharArrayBuffer charArrayBuffer = null;
            CharArrayBuffer charArrayBuffer2 = null;
            do {
                if (charArrayBuffer == null) {
                    charArrayBuffer = new CharArrayBuffer(64);
                } else {
                    charArrayBuffer.clear();
                }
                int n5 = sessionInputBuffer.readLine(charArrayBuffer);
                if (n5 == -1 || charArrayBuffer.length() < 1) break block9;
                if ((charArrayBuffer.charAt(0) == ' ' || charArrayBuffer.charAt(0) == '\t') && charArrayBuffer2 != null) {
                    char c2;
                    for (n4 = 0; n4 < charArrayBuffer.length() && ((c2 = charArrayBuffer.charAt(n4)) == ' ' || c2 == '\t'); ++n4) {
                    }
                    if (n3 > 0 && charArrayBuffer2.length() + 1 + charArrayBuffer.length() - n4 > n3) {
                        throw new MessageConstraintException("Maximum line length limit exceeded");
                    }
                    charArrayBuffer2.append(' ');
                    charArrayBuffer2.append(charArrayBuffer, n4, charArrayBuffer.length() - n4);
                    continue;
                }
                list.add(charArrayBuffer);
                charArrayBuffer2 = charArrayBuffer;
                charArrayBuffer = null;
            } while (n2 <= 0 || list.size() < n2);
            throw new MessageConstraintException("Maximum header count exceeded");
        }
        Header[] headerArray = new Header[list.size()];
        for (n4 = 0; n4 < list.size(); ++n4) {
            CharArrayBuffer charArrayBuffer = list.get(n4);
            try {
                headerArray[n4] = lineParser.parseHeader(charArrayBuffer);
                continue;
            }
            catch (ParseException parseException) {
                throw new ProtocolException(parseException.getMessage());
            }
        }
        return headerArray;
    }

    protected abstract T parseHead(SessionInputBuffer var1) throws IOException, HttpException, ParseException;

    @Override
    public T parse() throws IOException, HttpException {
        int n2 = this.state;
        switch (n2) {
            case 0: {
                try {
                    this.message = this.parseHead(this.sessionBuffer);
                }
                catch (ParseException parseException) {
                    throw new ProtocolException(parseException.getMessage(), parseException);
                }
                this.state = 1;
            }
            case 1: {
                Header[] headerArray = AbstractMessageParser.parseHeaders(this.sessionBuffer, this.messageConstraints.getMaxHeaderCount(), this.messageConstraints.getMaxLineLength(), this.lineParser, this.headerLines);
                this.message.setHeaders(headerArray);
                T t2 = this.message;
                this.message = null;
                this.headerLines.clear();
                this.state = 0;
                return t2;
            }
        }
        throw new IllegalStateException("Inconsistent parser state");
    }
}

