/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io;

import com.ibm.cognos.externals.org.apache.http_4_4_14.Consts;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.HttpTransportMetricsImpl;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.BufferInfo;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpTransportMetrics;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.SessionInputBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.params.HttpParams;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.ByteArrayBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

@Deprecated
public abstract class AbstractSessionInputBuffer
implements BufferInfo,
SessionInputBuffer {
    private InputStream inStream;
    private byte[] buffer;
    private ByteArrayBuffer lineBuffer;
    private Charset charset;
    private boolean ascii;
    private int maxLineLen;
    private int minChunkLimit;
    private HttpTransportMetricsImpl metrics;
    private CodingErrorAction onMalformedCharAction;
    private CodingErrorAction onUnmappableCharAction;
    private int bufferPos;
    private int bufferLen;
    private CharsetDecoder decoder;
    private CharBuffer cbuf;

    protected void init(InputStream inputStream, int n2, HttpParams httpParams) {
        Args.notNull(inputStream, "Input stream");
        Args.notNegative(n2, "Buffer size");
        Args.notNull(httpParams, "HTTP parameters");
        this.inStream = inputStream;
        this.buffer = new byte[n2];
        this.bufferPos = 0;
        this.bufferLen = 0;
        this.lineBuffer = new ByteArrayBuffer(n2);
        String string = (String)httpParams.getParameter("http.protocol.element-charset");
        this.charset = string != null ? Charset.forName(string) : Consts.ASCII;
        this.ascii = this.charset.equals(Consts.ASCII);
        this.decoder = null;
        this.maxLineLen = httpParams.getIntParameter("http.connection.max-line-length", -1);
        this.minChunkLimit = httpParams.getIntParameter("http.connection.min-chunk-limit", 512);
        this.metrics = this.createTransportMetrics();
        CodingErrorAction codingErrorAction = (CodingErrorAction)httpParams.getParameter("http.malformed.input.action");
        this.onMalformedCharAction = codingErrorAction != null ? codingErrorAction : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction2 = (CodingErrorAction)httpParams.getParameter("http.unmappable.input.action");
        this.onUnmappableCharAction = codingErrorAction2 != null ? codingErrorAction2 : CodingErrorAction.REPORT;
    }

    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public int length() {
        return this.bufferLen - this.bufferPos;
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    protected int fillBuffer() throws IOException {
        int n2;
        int n3;
        int n4;
        if (this.bufferPos > 0) {
            n4 = this.bufferLen - this.bufferPos;
            if (n4 > 0) {
                System.arraycopy(this.buffer, this.bufferPos, this.buffer, 0, n4);
            }
            this.bufferPos = 0;
            this.bufferLen = n4;
        }
        if ((n4 = this.inStream.read(this.buffer, n3 = this.bufferLen, n2 = this.buffer.length - n3)) == -1) {
            return -1;
        }
        this.bufferLen = n3 + n4;
        this.metrics.incrementBytesTransferred(n4);
        return n4;
    }

    protected boolean hasBufferedData() {
        return this.bufferPos < this.bufferLen;
    }

    @Override
    public int read() throws IOException {
        while (!this.hasBufferedData()) {
            int n2 = this.fillBuffer();
            if (n2 != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferPos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (byArray == null) {
            return 0;
        }
        if (this.hasBufferedData()) {
            int n5 = Math.min(n3, this.bufferLen - this.bufferPos);
            System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n5);
            this.bufferPos += n5;
            return n5;
        }
        if (n3 > this.minChunkLimit) {
            int n6 = this.inStream.read(byArray, n2, n3);
            if (n6 > 0) {
                this.metrics.incrementBytesTransferred(n6);
            }
            return n6;
        }
        while (!this.hasBufferedData()) {
            n4 = this.fillBuffer();
            if (n4 != -1) continue;
            return -1;
        }
        n4 = Math.min(n3, this.bufferLen - this.bufferPos);
        System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n4);
        this.bufferPos += n4;
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    private int locateLF() {
        for (int i2 = this.bufferPos; i2 < this.bufferLen; ++i2) {
            if (this.buffer[i2] != 10) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int readLine(CharArrayBuffer charArrayBuffer) throws IOException {
        Args.notNull(charArrayBuffer, "Char array buffer");
        int n2 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n3;
            int n4 = this.locateLF();
            if (n4 != -1) {
                if (this.lineBuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charArrayBuffer, n4);
                }
                bl2 = false;
                n3 = n4 + 1 - this.bufferPos;
                this.lineBuffer.append(this.buffer, this.bufferPos, n3);
                this.bufferPos = n4 + 1;
            } else {
                if (this.hasBufferedData()) {
                    n3 = this.bufferLen - this.bufferPos;
                    this.lineBuffer.append(this.buffer, this.bufferPos, n3);
                    this.bufferPos = this.bufferLen;
                }
                if ((n2 = this.fillBuffer()) == -1) {
                    bl2 = false;
                }
            }
            if (this.maxLineLen <= 0 || this.lineBuffer.length() < this.maxLineLen) continue;
            throw new IOException("Maximum line length limit exceeded");
        }
        if (n2 == -1 && this.lineBuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer(charArrayBuffer);
    }

    private int lineFromLineBuffer(CharArrayBuffer charArrayBuffer) throws IOException {
        int n2 = this.lineBuffer.length();
        if (n2 > 0) {
            if (this.lineBuffer.byteAt(n2 - 1) == 10) {
                --n2;
            }
            if (n2 > 0 && this.lineBuffer.byteAt(n2 - 1) == 13) {
                --n2;
            }
        }
        if (this.ascii) {
            charArrayBuffer.append(this.lineBuffer, 0, n2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.lineBuffer.buffer(), 0, n2);
            n2 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        this.lineBuffer.clear();
        return n2;
    }

    private int lineFromReadBuffer(CharArrayBuffer charArrayBuffer, int n2) throws IOException {
        int n3 = this.bufferPos;
        int n4 = n2;
        this.bufferPos = n4 + 1;
        if (n4 > n3 && this.buffer[n4 - 1] == 13) {
            --n4;
        }
        int n5 = n4 - n3;
        if (this.ascii) {
            charArrayBuffer.append(this.buffer, n3, n5);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer, n3, n5);
            n5 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        return n5;
    }

    private int appendDecoded(CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) throws IOException {
        CoderResult coderResult;
        if (!byteBuffer.hasRemaining()) {
            return 0;
        }
        if (this.decoder == null) {
            this.decoder = this.charset.newDecoder();
            this.decoder.onMalformedInput(this.onMalformedCharAction);
            this.decoder.onUnmappableCharacter(this.onUnmappableCharAction);
        }
        if (this.cbuf == null) {
            this.cbuf = CharBuffer.allocate(1024);
        }
        this.decoder.reset();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            coderResult = this.decoder.decode(byteBuffer, this.cbuf, true);
            n2 += this.handleDecodingResult(coderResult, charArrayBuffer, byteBuffer);
        }
        coderResult = this.decoder.flush(this.cbuf);
        this.cbuf.clear();
        return n2 += this.handleDecodingResult(coderResult, charArrayBuffer, byteBuffer);
    }

    private int handleDecodingResult(CoderResult coderResult, CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) throws IOException {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.cbuf.flip();
        int n2 = this.cbuf.remaining();
        while (this.cbuf.hasRemaining()) {
            charArrayBuffer.append(this.cbuf.get());
        }
        this.cbuf.compact();
        return n2;
    }

    @Override
    public String readLine() throws IOException {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        int n2 = this.readLine(charArrayBuffer);
        if (n2 != -1) {
            return charArrayBuffer.toString();
        }
        return null;
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

