/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.message;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ReasonPhraseCatalog;
import com.ibm.cognos.externals.org.apache.http_4_4_14.StatusLine;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.AbstractHttpMessage;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.BasicStatusLine;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.TextUtils;
import java.util.Locale;

public class BasicHttpResponse
extends AbstractHttpMessage
implements HttpResponse {
    private StatusLine statusline;
    private ProtocolVersion ver;
    private int code;
    private String reasonPhrase;
    private HttpEntity entity;
    private final ReasonPhraseCatalog reasonCatalog;
    private Locale locale;

    public BasicHttpResponse(StatusLine statusLine, ReasonPhraseCatalog reasonPhraseCatalog, Locale locale) {
        this.statusline = Args.notNull(statusLine, "Status line");
        this.ver = statusLine.getProtocolVersion();
        this.code = statusLine.getStatusCode();
        this.reasonPhrase = statusLine.getReasonPhrase();
        this.reasonCatalog = reasonPhraseCatalog;
        this.locale = locale;
    }

    public BasicHttpResponse(StatusLine statusLine) {
        this.statusline = Args.notNull(statusLine, "Status line");
        this.ver = statusLine.getProtocolVersion();
        this.code = statusLine.getStatusCode();
        this.reasonPhrase = statusLine.getReasonPhrase();
        this.reasonCatalog = null;
        this.locale = null;
    }

    public BasicHttpResponse(ProtocolVersion protocolVersion, int n2, String string) {
        Args.notNegative(n2, "Status code");
        this.statusline = null;
        this.ver = protocolVersion;
        this.code = n2;
        this.reasonPhrase = string;
        this.reasonCatalog = null;
        this.locale = null;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.ver;
    }

    @Override
    public StatusLine getStatusLine() {
        if (this.statusline == null) {
            this.statusline = new BasicStatusLine(this.ver != null ? this.ver : HttpVersion.HTTP_1_1, this.code, this.reasonPhrase != null ? this.reasonPhrase : this.getReason(this.code));
        }
        return this.statusline;
    }

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setStatusLine(StatusLine statusLine) {
        this.statusline = Args.notNull(statusLine, "Status line");
        this.ver = statusLine.getProtocolVersion();
        this.code = statusLine.getStatusCode();
        this.reasonPhrase = statusLine.getReasonPhrase();
    }

    @Override
    public void setStatusLine(ProtocolVersion protocolVersion, int n2) {
        Args.notNegative(n2, "Status code");
        this.statusline = null;
        this.ver = protocolVersion;
        this.code = n2;
        this.reasonPhrase = null;
    }

    @Override
    public void setStatusLine(ProtocolVersion protocolVersion, int n2, String string) {
        Args.notNegative(n2, "Status code");
        this.statusline = null;
        this.ver = protocolVersion;
        this.code = n2;
        this.reasonPhrase = string;
    }

    @Override
    public void setStatusCode(int n2) {
        Args.notNegative(n2, "Status code");
        this.statusline = null;
        this.code = n2;
        this.reasonPhrase = null;
    }

    @Override
    public void setReasonPhrase(String string) {
        this.statusline = null;
        this.reasonPhrase = TextUtils.isBlank(string) ? null : string;
    }

    @Override
    public void setEntity(HttpEntity httpEntity) {
        this.entity = httpEntity;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = Args.notNull(locale, "Locale");
        this.statusline = null;
    }

    protected String getReason(int n2) {
        return this.reasonCatalog != null ? this.reasonCatalog.getReason(n2, this.locale != null ? this.locale : Locale.getDefault()) : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getStatusLine());
        stringBuilder.append(' ');
        stringBuilder.append(this.headergroup);
        if (this.entity != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.entity);
        }
        return stringBuilder.toString();
    }
}

