/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.protocol;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpConnection;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpInetConnection;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequestInterceptor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpCoreContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        HttpCoreContext httpCoreContext = HttpCoreContext.adapt(httpContext);
        ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT") && protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!httpRequest.containsHeader("Host")) {
            HttpHost httpHost = httpCoreContext.getTargetHost();
            if (httpHost == null) {
                HttpConnection httpConnection = httpCoreContext.getConnection();
                if (httpConnection instanceof HttpInetConnection) {
                    InetAddress inetAddress = ((HttpInetConnection)httpConnection).getRemoteAddress();
                    int n2 = ((HttpInetConnection)httpConnection).getRemotePort();
                    if (inetAddress != null) {
                        httpHost = new HttpHost(inetAddress.getHostName(), n2);
                    }
                }
                if (httpHost == null) {
                    if (protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            httpRequest.addHeader("Host", httpHost.toHostString());
        }
    }
}

