/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.protocol;

import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponseInterceptor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpCoreContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Object object;
        Args.notNull(httpResponse, "HTTP response");
        HttpCoreContext httpCoreContext = HttpCoreContext.adapt(httpContext);
        int n2 = httpResponse.getStatusLine().getStatusCode();
        if (n2 == 400 || n2 == 408 || n2 == 411 || n2 == 413 || n2 == 414 || n2 == 503 || n2 == 501) {
            httpResponse.setHeader("Connection", "Close");
            return;
        }
        Header header = httpResponse.getFirstHeader("Connection");
        if (header != null && "Close".equalsIgnoreCase(header.getValue())) {
            return;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            object = httpResponse.getStatusLine().getProtocolVersion();
            if (httpEntity.getContentLength() < 0L && (!httpEntity.isChunked() || ((ProtocolVersion)object).lessEquals(HttpVersion.HTTP_1_0))) {
                httpResponse.setHeader("Connection", "Close");
                return;
            }
        }
        if ((object = httpCoreContext.getRequest()) != null) {
            Header header2 = object.getFirstHeader("Connection");
            if (header2 != null) {
                httpResponse.setHeader("Connection", header2.getValue());
            } else if (object.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                httpResponse.setHeader("Connection", "Close");
            }
        }
    }
}

