/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth;

import com.ibm.cognos.externals.org.apache.http_4_4_14.FormattedHeader;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HTTP;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthenticationException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.ChallengeState;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.ContextAwareAuthScheme;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.Credentials;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.MalformedChallengeException;
import java.util.Locale;

public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    protected ChallengeState challengeState;

    @Deprecated
    public AuthSchemeBase(ChallengeState challengeState) {
        this.challengeState = challengeState;
    }

    public AuthSchemeBase() {
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        int n2;
        CharArrayBuffer charArrayBuffer;
        Args.notNull(header, "Header");
        String string = header.getName();
        if (string.equalsIgnoreCase("WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (string.equalsIgnoreCase("Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + string);
        }
        if (header instanceof FormattedHeader) {
            charArrayBuffer = ((FormattedHeader)header).getBuffer();
            n2 = ((FormattedHeader)header).getValuePos();
        } else {
            String string2 = header.getValue();
            if (string2 == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            charArrayBuffer = new CharArrayBuffer(string2.length());
            charArrayBuffer.append(string2);
            n2 = 0;
        }
        while (n2 < charArrayBuffer.length() && HTTP.isWhitespace(charArrayBuffer.charAt(n2))) {
            ++n2;
        }
        int n3 = n2;
        while (n2 < charArrayBuffer.length() && !HTTP.isWhitespace(charArrayBuffer.charAt(n2))) {
            ++n2;
        }
        int n4 = n2;
        String string3 = charArrayBuffer.substring(n3, n4);
        if (!string3.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + string3);
        }
        this.parseChallenge(charArrayBuffer, n2, charArrayBuffer.length());
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        return this.authenticate(credentials, httpRequest);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public ChallengeState getChallengeState() {
        return this.challengeState;
    }

    public String toString() {
        String string = this.getSchemeName();
        return string != null ? string.toUpperCase(Locale.ROOT) : super.toString();
    }
}

