/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Asserts;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthOption;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthProtocolState;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthScheme;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthState;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthenticationException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.ContextAwareAuthScheme;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.Credentials;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.MalformedChallengeException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.AuthenticationStrategy;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;

public class HttpAuthenticator {
    private final Log log;

    public HttpAuthenticator(Log log) {
        this.log = log != null ? log : LogFactory.getLog(this.getClass());
    }

    public HttpAuthenticator() {
        this(null);
    }

    public boolean isAuthenticationRequested(HttpHost httpHost, HttpResponse httpResponse, AuthenticationStrategy authenticationStrategy, AuthState authState, HttpContext httpContext) {
        if (authenticationStrategy.isAuthenticationRequested(httpHost, httpResponse, httpContext)) {
            this.log.debug("Authentication required");
            if (authState.getState() == AuthProtocolState.SUCCESS) {
                authenticationStrategy.authFailed(httpHost, authState.getAuthScheme(), httpContext);
            }
            return true;
        }
        switch (authState.getState()) {
            case CHALLENGED: 
            case HANDSHAKE: {
                this.log.debug("Authentication succeeded");
                authState.setState(AuthProtocolState.SUCCESS);
                authenticationStrategy.authSucceeded(httpHost, authState.getAuthScheme(), httpContext);
                break;
            }
            case SUCCESS: {
                break;
            }
            default: {
                authState.setState(AuthProtocolState.UNCHALLENGED);
            }
        }
        return false;
    }

    public boolean handleAuthChallenge(HttpHost httpHost, HttpResponse httpResponse, AuthenticationStrategy authenticationStrategy, AuthState authState, HttpContext httpContext) {
        try {
            Object object;
            Map<String, Header> map;
            if (this.log.isDebugEnabled()) {
                this.log.debug(httpHost.toHostString() + " requested authentication");
            }
            if ((map = authenticationStrategy.getChallenges(httpHost, httpResponse, httpContext)).isEmpty()) {
                this.log.debug("Response contains no authentication challenges");
                return false;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            switch (authState.getState()) {
                case FAILURE: {
                    return false;
                }
                case SUCCESS: {
                    authState.reset();
                    break;
                }
                case CHALLENGED: 
                case HANDSHAKE: {
                    if (authScheme == null) {
                        this.log.debug("Auth scheme is null");
                        authenticationStrategy.authFailed(httpHost, null, httpContext);
                        authState.reset();
                        authState.setState(AuthProtocolState.FAILURE);
                        return false;
                    }
                }
                case UNCHALLENGED: {
                    if (authScheme == null) break;
                    object = authScheme.getSchemeName();
                    Header header = map.get(((String)object).toLowerCase(Locale.ROOT));
                    if (header != null) {
                        this.log.debug("Authorization challenge processed");
                        authScheme.processChallenge(header);
                        if (authScheme.isComplete()) {
                            this.log.debug("Authentication failed");
                            authenticationStrategy.authFailed(httpHost, authState.getAuthScheme(), httpContext);
                            authState.reset();
                            authState.setState(AuthProtocolState.FAILURE);
                            return false;
                        }
                        authState.setState(AuthProtocolState.HANDSHAKE);
                        return true;
                    }
                    authState.reset();
                }
            }
            object = authenticationStrategy.select(map, httpHost, httpResponse, httpContext);
            if (object != null && !object.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Selected authentication options: " + object);
                }
                authState.setState(AuthProtocolState.CHALLENGED);
                authState.update((Queue<AuthOption>)object);
                return true;
            }
            return false;
        }
        catch (MalformedChallengeException malformedChallengeException) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Malformed challenge: " + malformedChallengeException.getMessage());
            }
            authState.reset();
            return false;
        }
    }

    public void generateAuthResponse(HttpRequest httpRequest, AuthState authState, HttpContext httpContext) throws HttpException, IOException {
        block13: {
            Object object;
            AuthScheme authScheme = authState.getAuthScheme();
            Credentials credentials = authState.getCredentials();
            switch (authState.getState()) {
                case FAILURE: {
                    return;
                }
                case SUCCESS: {
                    this.ensureAuthScheme(authScheme);
                    if (!authScheme.isConnectionBased()) break;
                    return;
                }
                case CHALLENGED: {
                    object = authState.getAuthOptions();
                    if (object != null) {
                        while (!object.isEmpty()) {
                            AuthOption authOption = object.remove();
                            authScheme = authOption.getAuthScheme();
                            credentials = authOption.getCredentials();
                            authState.update(authScheme, credentials);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Generating response to an authentication challenge using " + authScheme.getSchemeName() + " scheme");
                            }
                            try {
                                Header header = this.doAuth(authScheme, credentials, httpRequest, httpContext);
                                httpRequest.addHeader(header);
                                break;
                            }
                            catch (AuthenticationException authenticationException) {
                                if (!this.log.isWarnEnabled()) continue;
                                this.log.warn(authScheme + " authentication error: " + authenticationException.getMessage());
                            }
                        }
                        return;
                    }
                    this.ensureAuthScheme(authScheme);
                }
            }
            if (authScheme != null) {
                try {
                    object = this.doAuth(authScheme, credentials, httpRequest, httpContext);
                    httpRequest.addHeader((Header)object);
                }
                catch (AuthenticationException authenticationException) {
                    if (!this.log.isErrorEnabled()) break block13;
                    this.log.error(authScheme + " authentication error: " + authenticationException.getMessage());
                }
            }
        }
    }

    private void ensureAuthScheme(AuthScheme authScheme) {
        Asserts.notNull(authScheme, "Auth scheme");
    }

    private Header doAuth(AuthScheme authScheme, Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        return authScheme instanceof ContextAwareAuthScheme ? ((ContextAwareAuthScheme)authScheme).authenticate(credentials, httpRequest, httpContext) : authScheme.authenticate(credentials, httpRequest);
    }
}

