/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntityEnclosingRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.HttpRequestRetryHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpUriRequest;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client.RequestWrapper;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    public static final DefaultHttpRequestRetryHandler INSTANCE = new DefaultHttpRequestRetryHandler();
    private final int retryCount;
    private final boolean requestSentRetryEnabled;
    private final Set<Class<? extends IOException>> nonRetriableClasses;

    protected DefaultHttpRequestRetryHandler(int n2, boolean bl2, Collection<Class<? extends IOException>> collection) {
        this.retryCount = n2;
        this.requestSentRetryEnabled = bl2;
        this.nonRetriableClasses = new HashSet<Class<? extends IOException>>();
        for (Class<? extends IOException> clazz : collection) {
            this.nonRetriableClasses.add(clazz);
        }
    }

    public DefaultHttpRequestRetryHandler(int n2, boolean bl2) {
        this(n2, bl2, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class));
    }

    public DefaultHttpRequestRetryHandler() {
        this(3, false);
    }

    @Override
    public boolean retryRequest(IOException iOException, int n2, HttpContext httpContext) {
        Args.notNull(iOException, "Exception parameter");
        Args.notNull(httpContext, "HTTP context");
        if (n2 > this.retryCount) {
            return false;
        }
        if (this.nonRetriableClasses.contains(iOException.getClass())) {
            return false;
        }
        for (Class<? extends IOException> object2 : this.nonRetriableClasses) {
            if (!object2.isInstance(iOException)) continue;
            return false;
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        HttpRequest httpRequest = httpClientContext.getRequest();
        if (this.requestIsAborted(httpRequest)) {
            return false;
        }
        if (this.handleAsIdempotent(httpRequest)) {
            return true;
        }
        return !httpClientContext.isRequestSent() || this.requestSentRetryEnabled;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected boolean handleAsIdempotent(HttpRequest httpRequest) {
        return !(httpRequest instanceof HttpEntityEnclosingRequest);
    }

    @Deprecated
    protected boolean requestIsAborted(HttpRequest httpRequest) {
        HttpRequest httpRequest2 = httpRequest;
        if (httpRequest instanceof RequestWrapper) {
            httpRequest2 = ((RequestWrapper)httpRequest).getOriginal();
        }
        return httpRequest2 instanceof HttpUriRequest && ((HttpUriRequest)httpRequest2).isAborted();
    }
}

