/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie;

import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.ClientCookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CommonCookieAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.Cookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieOrigin;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieRestrictionViolationException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.MalformedCookieException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.SetCookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.SetCookie2;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (n2 < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        setCookie.setVersion(n2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

