/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpProcessor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthScope;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.UsernamePasswordCredentials;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.CredentialsProvider;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.CloseableHttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpExecutionAware;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpRequestWrapper;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpUriRequest;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.utils.URIUtils;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.routing.HttpRoute;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client.BasicCredentialsProvider;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain.ClientExecChain;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ProtocolExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpProcessor httpProcessor;

    public ProtocolExec(ClientExecChain clientExecChain, HttpProcessor httpProcessor) {
        Args.notNull(clientExecChain, "HTTP client request executor");
        Args.notNull(httpProcessor, "HTTP protocol processor");
        this.requestExecutor = clientExecChain;
        this.httpProcessor = httpProcessor;
    }

    void rewriteRequestURI(HttpRequestWrapper httpRequestWrapper, HttpRoute httpRoute, boolean bl2) throws ProtocolException {
        URI uRI = httpRequestWrapper.getURI();
        if (uRI != null) {
            try {
                httpRequestWrapper.setURI(URIUtils.rewriteURIForRoute(uRI, httpRoute, bl2));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException("Invalid URI: " + uRI, uRISyntaxException);
            }
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Object object;
        Object object2;
        URI uRI;
        block18: {
            Args.notNull(httpRoute, "HTTP route");
            Args.notNull(httpRequestWrapper, "HTTP request");
            Args.notNull(httpClientContext, "HTTP context");
            HttpRequest httpRequest = httpRequestWrapper.getOriginal();
            uRI = null;
            if (httpRequest instanceof HttpUriRequest) {
                uRI = ((HttpUriRequest)httpRequest).getURI();
            } else {
                object2 = httpRequest.getRequestLine().getUri();
                try {
                    uRI = URI.create((String)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.debug("Unable to parse '" + (String)object2 + "' as a valid URI; " + "request URI and Host header may be inconsistent", illegalArgumentException);
                }
            }
        }
        httpRequestWrapper.setURI(uRI);
        this.rewriteRequestURI(httpRequestWrapper, httpRoute, httpClientContext.getRequestConfig().isNormalizeUri());
        object2 = httpRequestWrapper.getParams();
        HttpHost httpHost = (HttpHost)object2.getParameter("http.virtual-host");
        if (httpHost != null && httpHost.getPort() == -1) {
            int n2 = httpRoute.getTargetHost().getPort();
            if (n2 != -1) {
                httpHost = new HttpHost(httpHost.getHostName(), n2, httpHost.getSchemeName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using virtual host" + httpHost);
            }
        }
        HttpHost httpHost2 = null;
        if (httpHost != null) {
            httpHost2 = httpHost;
        } else if (uRI != null && uRI.isAbsolute() && uRI.getHost() != null) {
            httpHost2 = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
        }
        if (httpHost2 == null) {
            httpHost2 = httpRequestWrapper.getTarget();
        }
        if (httpHost2 == null) {
            httpHost2 = httpRoute.getTargetHost();
        }
        if (uRI != null && (object = uRI.getUserInfo()) != null) {
            CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
            if (credentialsProvider == null) {
                credentialsProvider = new BasicCredentialsProvider();
                httpClientContext.setCredentialsProvider(credentialsProvider);
            }
            credentialsProvider.setCredentials(new AuthScope(httpHost2), new UsernamePasswordCredentials((String)object));
        }
        httpClientContext.setAttribute("http.target_host", httpHost2);
        httpClientContext.setAttribute("http.route", httpRoute);
        httpClientContext.setAttribute("http.request", httpRequestWrapper);
        this.httpProcessor.process(httpRequestWrapper, (HttpContext)httpClientContext);
        object = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        try {
            httpClientContext.setAttribute("http.response", object);
            this.httpProcessor.process((HttpResponse)object, (HttpContext)httpClientContext);
            return object;
        }
        catch (RuntimeException runtimeException) {
            object.close();
            throw runtimeException;
        }
        catch (IOException iOException) {
            object.close();
            throw iOException;
        }
        catch (HttpException httpException) {
            object.close();
            throw httpException;
        }
    }
}

